/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.constraint;

import jakarta.data.constraint.Constraint;
import jakarta.data.constraint.LikeRecord;
import jakarta.data.expression.TextExpression;
import jakarta.data.messages.Messages;
import jakarta.data.spi.expression.literal.StringLiteral;

public interface Like
extends Constraint<String> {
    public Character escape();

    public static Like literal(String value) {
        Messages.requireNonNull(value, "value");
        StringLiteral expression = StringLiteral.of(LikeRecord.escape(value));
        return new LikeRecord(expression, Character.valueOf('\\'));
    }

    public TextExpression<?> pattern();

    public static Like pattern(String pattern) {
        Messages.requireNonNull(pattern, "pattern");
        StringLiteral expression = StringLiteral.of(pattern);
        return new LikeRecord(expression, null);
    }

    public static Like pattern(String pattern, char charWildcard, char stringWildcard) {
        return Like.pattern(pattern, charWildcard, stringWildcard, '\\');
    }

    public static Like pattern(String pattern, char charWildcard, char stringWildcard, char escape) {
        Messages.requireNonNull(pattern, "pattern");
        StringLiteral expression = StringLiteral.of(LikeRecord.translate(pattern, charWildcard, stringWildcard, escape));
        return new LikeRecord(expression, Character.valueOf(escape));
    }

    public static Like pattern(TextExpression<?> pattern, char escape) {
        Messages.requireNonNull(pattern, "pattern");
        return new LikeRecord(pattern, Character.valueOf(escape));
    }

    public static Like prefix(String prefix) {
        Messages.requireNonNull(prefix, "prefix");
        StringLiteral expression = StringLiteral.of(LikeRecord.escape(prefix) + "%");
        return new LikeRecord(expression, Character.valueOf('\\'));
    }

    public static Like substring(String substring) {
        Messages.requireNonNull(substring, "substring");
        StringLiteral expression = StringLiteral.of("%" + LikeRecord.escape(substring) + "%");
        return new LikeRecord(expression, Character.valueOf('\\'));
    }

    public static Like suffix(String suffix) {
        Messages.requireNonNull(suffix, "suffix");
        StringLiteral expression = StringLiteral.of("%" + LikeRecord.escape(suffix));
        return new LikeRecord(expression, Character.valueOf('\\'));
    }
}

