/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.xml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.ImportSupport;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ParseSupport
extends BodyTagSupport {
    protected Object xml;
    protected String systemId;
    protected XMLFilter filter;
    private String var;
    private String varDom;
    private int scope;
    private int scopeDom;
    private DocumentBuilderFactory dbf;
    private DocumentBuilder db;
    private TransformerFactory tf;
    private TransformerHandler th;
    private static final String ACCESS_EXTERNAL_DTD_SETTING = "javax.xml.accessExternalDTD";
    private static final String ACCESS_EXTERNAL_SCHEMA_SETTING = "javax.xml.accessExternalSchema";
    static final long serialVersionUID = 3251017143893752745L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ParseSupport() {
        this.init();
    }

    private void init() {
        this.varDom = null;
        this.var = null;
        this.xml = null;
        this.systemId = null;
        this.filter = null;
        this.dbf = null;
        this.db = null;
        this.tf = null;
        this.th = null;
        this.scope = 1;
        this.scopeDom = 1;
    }

    /*
     * WARNING - void declaration
     */
    public int doEndTag() throws JspException {
        try {
            Document d;
            Object xmlText;
            if (this.dbf == null) {
                this.dbf = DocumentBuilderFactory.newInstance();
                this.dbf.setNamespaceAware(true);
                this.dbf.setValidating(false);
                try {
                    this.dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    String accessExternalDTD = null;
                    String accessExternalSchema = null;
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        try {
                            accessExternalDTD = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                                static final long serialVersionUID = 8446445855725421811L;
                                private static final /* synthetic */ TraceComponent $$$tc$$$;

                                @Override
                                public String run() throws PrivilegedActionException {
                                    return System.getProperty(ParseSupport.ACCESS_EXTERNAL_DTD_SETTING);
                                }

                                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                static {
                                    $$$tc$$$ = Tr.register((String)"org.apache.taglibs.standard.tag.common.xml.ParseSupport$1", 1.class, null, null);
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException, (String)"org.apache.taglibs.standard.tag.common.xml.ParseSupport", (String)"140", (Object)((Object)this), (Object[])new Object[0]);
                        }
                        try {
                            accessExternalSchema = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                                static final long serialVersionUID = 6893186834760713161L;
                                private static final /* synthetic */ TraceComponent $$$tc$$$;

                                @Override
                                public String run() throws PrivilegedActionException {
                                    return System.getProperty(ParseSupport.ACCESS_EXTERNAL_SCHEMA_SETTING);
                                }

                                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                static {
                                    $$$tc$$$ = Tr.register((String)"org.apache.taglibs.standard.tag.common.xml.ParseSupport$2", 2.class, null, null);
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException, (String)"org.apache.taglibs.standard.tag.common.xml.ParseSupport", (String)"148", (Object)((Object)this), (Object[])new Object[0]);
                        }
                    } else {
                        accessExternalDTD = System.getProperty(ACCESS_EXTERNAL_DTD_SETTING);
                        accessExternalSchema = System.getProperty(ACCESS_EXTERNAL_SCHEMA_SETTING);
                    }
                    if (accessExternalDTD == null) {
                        this.dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    }
                    if (accessExternalSchema == null) {
                        this.dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                    }
                }
                catch (ParserConfigurationException accessExternalDTD) {
                    FFDCFilter.processException((Throwable)accessExternalDTD, (String)"org.apache.taglibs.standard.tag.common.xml.ParseSupport", (String)"161", (Object)((Object)this), (Object[])new Object[0]);
                    throw new AssertionError((Object)"Parser does not support secure processing");
                }
            }
            this.db = this.dbf.newDocumentBuilder();
            if (this.filter != null) {
                if (this.tf == null) {
                    this.tf = TransformerFactory.newInstance();
                }
                if (!this.tf.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                    throw new JspTagException(Resources.getMessage("PARSE_NO_SAXTRANSFORMER"));
                }
                try {
                    this.tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (TransformerConfigurationException e) {
                    FFDCFilter.processException((Throwable)e, (String)"org.apache.taglibs.standard.tag.common.xml.ParseSupport", (String)"176", (Object)((Object)this), (Object[])new Object[0]);
                    throw new AssertionError((Object)"TransformerFactory does not support secure processing");
                }
                SAXTransformerFactory stf = (SAXTransformerFactory)this.tf;
                this.th = stf.newTransformerHandler();
            }
            if ((xmlText = this.xml) == null) {
                xmlText = this.bodyContent != null && this.bodyContent.getString() != null ? this.bodyContent.getString().trim() : "";
            }
            if (xmlText instanceof String) {
                d = this.parseStringWithFilter((String)xmlText, this.filter);
            } else if (xmlText instanceof Reader) {
                d = this.parseReaderWithFilter((Reader)xmlText, this.filter);
            } else {
                throw new JspTagException(Resources.getMessage("PARSE_INVALID_SOURCE"));
            }
            if (this.var != null) {
                this.pageContext.setAttribute(this.var, (Object)d, this.scope);
            }
            if (this.varDom != null) {
                this.pageContext.setAttribute(this.varDom, (Object)d, this.scopeDom);
            }
            return 6;
        }
        catch (SAXException d) {
            void ex;
            FFDCFilter.processException((Throwable)d, (String)"org.apache.taglibs.standard.tag.common.xml.ParseSupport", (String)"210", (Object)((Object)this), (Object[])new Object[0]);
            throw new JspException((Throwable)ex);
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.taglibs.standard.tag.common.xml.ParseSupport", (String)"212", (Object)((Object)this), (Object[])new Object[0]);
            throw new JspException((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.taglibs.standard.tag.common.xml.ParseSupport", (String)"214", (Object)((Object)this), (Object[])new Object[0]);
            throw new JspException((Throwable)ex);
        }
        catch (TransformerConfigurationException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.taglibs.standard.tag.common.xml.ParseSupport", (String)"216", (Object)((Object)this), (Object[])new Object[0]);
            throw new JspException((Throwable)ex);
        }
    }

    public void release() {
        this.init();
    }

    private Document parseInputSourceWithFilter(InputSource s, XMLFilter f) throws SAXException, IOException {
        if (f != null) {
            Document o = this.db.newDocument();
            this.th.setResult(new DOMResult(o));
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setEntityResolver(new JstlEntityResolver(this.pageContext));
            f.setParent(xr);
            f.setContentHandler(this.th);
            f.parse(s);
            return o;
        }
        return this.parseInputSource(s);
    }

    private Document parseReaderWithFilter(Reader r, XMLFilter f) throws SAXException, IOException {
        return this.parseInputSourceWithFilter(new InputSource(r), f);
    }

    private Document parseStringWithFilter(String s, XMLFilter f) throws SAXException, IOException {
        StringReader r = new StringReader(s);
        return this.parseReaderWithFilter(r, f);
    }

    private Document parseURLWithFilter(String url, XMLFilter f) throws SAXException, IOException {
        return this.parseInputSourceWithFilter(new InputSource(url), f);
    }

    private Document parseInputSource(InputSource s) throws SAXException, IOException {
        this.db.setEntityResolver(new JstlEntityResolver(this.pageContext));
        if (this.systemId == null) {
            s.setSystemId("jstl:");
        } else if (ImportSupport.isAbsoluteUrl(this.systemId)) {
            s.setSystemId(this.systemId);
        } else {
            s.setSystemId("jstl:" + this.systemId);
        }
        return this.db.parse(s);
    }

    private Document parseReader(Reader r) throws SAXException, IOException {
        return this.parseInputSource(new InputSource(r));
    }

    private Document parseString(String s) throws SAXException, IOException {
        StringReader r = new StringReader(s);
        return this.parseReader(r);
    }

    private Document parseURL(String url) throws SAXException, IOException {
        return this.parseInputSource(new InputSource(url));
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setVarDom(String varDom) {
        this.varDom = varDom;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    public void setScopeDom(String scopeDom) {
        this.scopeDom = Util.getScope(scopeDom);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.taglibs.standard.tag.common.xml.ParseSupport", ParseSupport.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class JstlEntityResolver
    implements EntityResolver {
        private final PageContext ctx;
        static final long serialVersionUID = -7392924249161163872L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public JstlEntityResolver(PageContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws FileNotFoundException {
            InputStream s;
            if (systemId == null) {
                return null;
            }
            if (systemId.startsWith("jstl:")) {
                systemId = systemId.substring(5);
            }
            if (ImportSupport.isAbsoluteUrl(systemId)) {
                return null;
            }
            if (systemId.startsWith("/")) {
                s = this.ctx.getServletContext().getResourceAsStream(systemId);
                if (s == null) {
                    throw new FileNotFoundException(Resources.getMessage("UNABLE_TO_RESOLVE_ENTITY", systemId));
                }
            } else {
                String pagePath = ((HttpServletRequest)this.ctx.getRequest()).getServletPath();
                String basePath = pagePath.substring(0, pagePath.lastIndexOf("/"));
                s = this.ctx.getServletContext().getResourceAsStream(basePath + "/" + systemId);
                if (s == null) {
                    throw new FileNotFoundException(Resources.getMessage("UNABLE_TO_RESOLVE_ENTITY", systemId));
                }
            }
            return new InputSource(s);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.taglibs.standard.tag.common.xml.ParseSupport$JstlEntityResolver", JstlEntityResolver.class, null, null);
        }
    }
}

