/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.impl.AbstractRequestContextImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;

public class ClientRequestContextImpl
extends AbstractRequestContextImpl
implements ClientRequestContext {
    public ClientRequestContextImpl(Message m, boolean responseContext) {
        super(m, responseContext);
    }

    @Override
    public MediaType getMediaType() {
        if (!this.hasEntity()) {
            return null;
        }
        Object mt = HttpUtils.getModifiableHeaders(this.m).getFirst((Object)"Content-Type");
        return mt instanceof MediaType ? (MediaType)mt : JAXRSUtils.toMediaType(mt.toString());
    }

    public Client getClient() {
        return (Client)this.m.getContextualProperty(Client.class.getName());
    }

    public Configuration getConfiguration() {
        ClientProviderFactory cpf = ClientProviderFactory.getInstance(this.m);
        return cpf.getConfiguration(this.m);
    }

    private Object getMessageContent() {
        MessageContentsList objs = MessageContentsList.getContentsList(this.m);
        if (objs == null || objs.size() == 0) {
            return null;
        }
        return objs.get(0);
    }

    public Object getEntity() {
        return this.getMessageContent();
    }

    public Annotation[] getEntityAnnotations() {
        Annotation[] anns = (Annotation[])this.m.get(Annotation.class.getName());
        return anns == null ? new Annotation[]{} : anns;
    }

    public Class<?> getEntityClass() {
        Object entity = this.getEntity();
        return entity == null ? null : entity.getClass();
    }

    public Type getEntityType() {
        Class<?> t = this.m.get(Type.class);
        return t != null ? t : this.getEntityClass();
    }

    public OutputStream getEntityStream() {
        return this.m.getContent(OutputStream.class);
    }

    public boolean hasEntity() {
        return this.getEntity() != null;
    }

    public void setEntity(Object entity, Annotation[] anns, MediaType mt) {
        if (mt != null) {
            MultivaluedMap<String, Object> headers = this.getHeaders();
            headers.putSingle((Object)"Content-Type", (Object)mt);
            this.m.put("Content-Type", mt.toString());
        }
        if (anns != null) {
            this.m.put(Annotation.class.getName(), anns);
        }
        this.doSetEntity(entity);
    }

    public void setEntity(Object entity) {
        this.doSetEntity(entity);
    }

    private void doSetEntity(Object entity) {
        Object actualEntity = InjectionUtils.getEntity(entity);
        this.m.setContent(List.class, actualEntity == null ? new MessageContentsList() : new MessageContentsList(actualEntity));
        Type type = null;
        if (entity != null) {
            type = GenericEntity.class.isAssignableFrom(entity.getClass()) ? ((GenericEntity)entity).getType() : entity.getClass();
            this.m.put(Type.class, type);
            this.m.remove("org.apache.cxf.empty.request");
        }
    }

    public URI getUri() {
        String requestURI = (String)this.m.get("org.apache.cxf.request.uri");
        if (requestURI == null) {
            return null;
        }
        if (requestURI.startsWith("/")) {
            String endpointAddress = (String)this.m.get(Message.ENDPOINT_ADDRESS);
            requestURI = requestURI.length() == 1 ? endpointAddress : endpointAddress + requestURI;
        }
        return URI.create(requestURI);
    }

    public void setEntityStream(OutputStream os) {
        this.m.setContent(OutputStream.class, os);
    }

    public void setUri(URI requestURI) {
        this.m.put(Message.ENDPOINT_ADDRESS, requestURI.toString());
        this.m.put("org.apache.cxf.request.uri", requestURI.toString());
    }

    public MultivaluedMap<String, Object> getHeaders() {
        this.h = null;
        return HttpUtils.getModifiableHeaders(this.m);
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        this.h = null;
        return HttpUtils.getModifiableStringHeaders(this.m);
    }
}

