/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.token;

import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.api.oauth20.token.OAuth20TokenCache;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.statistics.OAuthStatHelper;
import com.ibm.oauth.core.internal.statistics.OAuthStatisticsImpl;

public class OAuth20TokenCacheWrapper
implements OAuth20TokenCache {
    OAuth20TokenCache _real;
    OAuthStatisticsImpl _stats;
    static boolean _debugDumpCallStacks = false;

    public OAuth20TokenCacheWrapper(OAuth20TokenCache real, OAuthStatisticsImpl stats) {
        this._real = real;
        this._stats = stats;
    }

    @Override
    public void init(OAuthComponentConfiguration config) {
        this._real.init(config);
    }

    @Override
    public void add(String lookupKey, OAuth20Token entry, int lifetime) {
        if (_debugDumpCallStacks) {
            System.out.println(this.getClass().getName() + ".add CALLED FROM: " + OAuth20Util.getCurrentStackTraceString(new Exception()));
        }
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.tokenCache.add");
        this._real.add(lookupKey, entry, lifetime);
        this._stats.addMeasurement(statHelper);
    }

    @Override
    public OAuth20Token get(String lookupKey) {
        if (_debugDumpCallStacks) {
            System.out.println(this.getClass().getName() + ".get CALLED FROM: " + OAuth20Util.getCurrentStackTraceString(new Exception()));
        }
        OAuth20Token result = null;
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.tokenCache.get");
        result = this._real.get(lookupKey);
        this._stats.addMeasurement(statHelper);
        return result;
    }

    @Override
    public void remove(String lookupKey) {
        if (_debugDumpCallStacks) {
            System.out.println(this.getClass().getName() + ".remove CALLED FROM: " + OAuth20Util.getCurrentStackTraceString(new Exception()));
        }
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.tokenCache.remove");
        this._real.remove(lookupKey);
        this._stats.addMeasurement(statHelper);
    }
}

