/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.validation.Payload;
import org.apache.bval.jsr.AnnotationConstraintBuilder;
import org.apache.bval.jsr.BaseAppendValidation;
import org.apache.bval.jsr.ConstraintAnnotationAttributes;
import org.apache.bval.jsr.ConstraintValidation;
import org.apache.bval.jsr.xml.AnnotationProxyBuilder;

public class AppendValidationToBuilder
extends BaseAppendValidation {
    private final AnnotationConstraintBuilder<?> builder;

    public AppendValidationToBuilder(AnnotationConstraintBuilder<?> builder) {
        this.builder = builder;
    }

    @Override
    public <T extends Annotation> void preProcessValidation(ConstraintValidation<T> validation) {
        Set<Class<?>> inheritedGroups = this.builder.getConstraintValidation().getGroups();
        validation.setGroups(inheritedGroups);
        Set<Class<? extends Payload>> inheritedPayload = this.builder.getConstraintValidation().getPayload();
        validation.setPayload(inheritedPayload);
        T originalAnnot = validation.getAnnotation();
        AnnotationProxyBuilder<T> apb = new AnnotationProxyBuilder<T>(originalAnnot);
        apb.putValue(ConstraintAnnotationAttributes.GROUPS.getAttributeName(), inheritedGroups.toArray(new Class[inheritedGroups.size()]));
        apb.putValue(ConstraintAnnotationAttributes.PAYLOAD.getAttributeName(), inheritedPayload.toArray(new Class[inheritedPayload.size()]));
        T newAnnot = apb.createAnnotation();
        validation.setAnnotation(newAnnot);
    }

    @Override
    public <T extends Annotation> void performAppend(ConstraintValidation<T> validation) {
        this.builder.addComposed(validation);
    }

    public Set<Class<?>> getInheritedGroups() {
        return this.builder.getConstraintValidation().getGroups();
    }

    public Set<Class<? extends Payload>> getInheritedPayload() {
        return this.builder.getConstraintValidation().getPayload();
    }
}

