/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.openidconnect.server.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.web.OAuth20Request;
import io.openliberty.security.openidconnect.server.config.SpecificOidcEndpointSettings;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.cm.Configuration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcEndpointSettings {
    private static final TraceComponent tc = Tr.register(OidcEndpointSettings.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    public static final String KEY_NAME = "name";
    public static final String KEY_SUPPORTED_HTTP_METHODS = "supportedHttpMethods";
    private final Map<OAuth20Request.EndpointType, SpecificOidcEndpointSettings> allOidcEndpointSettings = new HashMap<OAuth20Request.EndpointType, SpecificOidcEndpointSettings>();
    static final long serialVersionUID = 6653219351520520894L;

    public Map<OAuth20Request.EndpointType, SpecificOidcEndpointSettings> getAllOidcEndpointSettings() {
        return this.allOidcEndpointSettings;
    }

    public SpecificOidcEndpointSettings getSpecificOidcEndpointSettings(OAuth20Request.EndpointType endpointType) {
        return this.allOidcEndpointSettings.get(endpointType);
    }

    @FFDCIgnore(value={RuntimeException.class})
    public void addOidcEndpointSettings(Configuration endpointSettingsConfig) {
        SpecificOidcEndpointSettings endpointSettings;
        block5: {
            if (endpointSettingsConfig == null) {
                return;
            }
            Dictionary configProps = endpointSettingsConfig.getProperties();
            if (configProps == null) {
                return;
            }
            endpointSettings = null;
            try {
                OAuth20Request.EndpointType endpoint = this.getEndpointTypeFromConfigName((String)configProps.get(KEY_NAME));
                if (endpoint == null) {
                    return;
                }
                endpointSettings = new SpecificOidcEndpointSettings(endpoint);
                endpointSettings.setSupportedHttpMethods((String[])configProps.get(KEY_SUPPORTED_HTTP_METHODS));
            }
            catch (RuntimeException e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Caught an exception reading endpoint settings from the config: {0}. Config properties were {1}", (Object[])new Object[]{e, configProps});
            }
        }
        this.updateAllEndpointSettings(endpointSettings);
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    OAuth20Request.EndpointType getEndpointTypeFromConfigName(String endpointName) {
        OAuth20Request.EndpointType endpointType = null;
        try {
            endpointType = OAuth20Request.EndpointType.valueOf((String)endpointName);
        }
        catch (IllegalArgumentException e) {
            endpointType = this.getNonStandardEndpointTypeFromConfigName(endpointName);
        }
        if (endpointType == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Failed to find matching endpoint type for intput [" + endpointName + "]"), (Object[])new Object[0]);
        }
        return endpointType;
    }

    OAuth20Request.EndpointType getNonStandardEndpointTypeFromConfigName(String endpointName) {
        if ("endSession".equals(endpointName)) {
            return OAuth20Request.EndpointType.end_session;
        }
        if ("checkSessionIframe".equals(endpointName)) {
            return OAuth20Request.EndpointType.check_session_iframe;
        }
        return null;
    }

    void updateAllEndpointSettings(SpecificOidcEndpointSettings newEndpointSettings) {
        if (newEndpointSettings == null) {
            return;
        }
        OAuth20Request.EndpointType newEndpointType = newEndpointSettings.getEndpointType();
        if (this.allOidcEndpointSettings.containsKey(newEndpointType)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Endpoint settings already recorded for endpoint type {0}. Recorded settings are {1}. The following settings will be ignored: {2}", (Object[])new Object[]{newEndpointType, this.allOidcEndpointSettings.get(newEndpointType), newEndpointSettings});
            }
        } else {
            this.allOidcEndpointSettings.put(newEndpointType, newEndpointSettings);
        }
    }
}

