/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.servlet.ESIInputStream;
import com.ibm.ws.cache.servlet.ESIOutputStream;
import com.ibm.ws.cache.servlet.ESIProcessorKeepAliveDaemon;
import com.ibm.ws.cache.servlet.ESIProcessorRequest;
import com.ibm.ws.cache.servlet.ESIProcessorStats;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ESIProcessor {
    private static final List _running = Collections.synchronizedList(new LinkedList());
    private static final TraceComponent _tc = Tr.register(ESIProcessor.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private String _hostName;
    private int _pid;
    private ESIInputStream _in;
    private ESIOutputStream _out;
    private int _localPort;
    private int _serverPort;
    private int _remotePort;
    private String _localAddr;
    private String _localName;
    private boolean _isAlive;
    private ESIProcessorRequest _curRequest = null;
    private static ESIProcessor protoprocessor = null;
    private ESIProcessorKeepAliveDaemon _keepAliveDaemon = null;
    private static final int KEEP_ALIVE_INTERVAL_IN_MS = 45000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(String hostName, InputStream in, OutputStream out) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"run", (Object[])new Object[]{hostName});
        }
        ESIProcessor processor = null;
        try {
            processor = new ESIProcessor(hostName, in, out);
            ESIProcessor.runCommon(processor);
        }
        catch (IOException ioe) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"An exception was thrown constructing the processor or running runCommon.", (Object[])new Object[]{ioe});
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)(ESIProcessor.class.getName() + ".run()"), (String)"69");
        }
        finally {
            if (processor != null) {
                _running.remove(processor);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"run", (Object)processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(HttpServletRequest request, HttpServletResponse response) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"run", (Object[])new Object[]{request.getRemoteHost()});
        }
        ESIProcessor processor = null;
        try {
            processor = new ESIProcessor(request, response);
            ESIProcessor.runCommon(processor);
        }
        catch (IOException ioe) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"An exception was thrown constructing the processor or running runCommon.", (Object[])new Object[]{ioe});
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)(ESIProcessor.class.getName() + ".run()"), (String)"104");
        }
        finally {
            if (processor != null) {
                _running.remove(processor);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"run", (Object)processor);
        }
    }

    private static void runCommon(ESIProcessor processor) throws IOException {
        _running.add(processor);
        processor.listen();
    }

    public static ESIProcessor[] getRunning() {
        return _running.toArray(new ESIProcessor[0]);
    }

    public static synchronized int collectEdgeStats(int _gatherWhat) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("collectEdgeStats " + _gatherWhat), (Object[])new Object[0]);
        }
        String edge = null;
        int count = 0;
        if (protoprocessor == null) {
            throw new IOException("collectEdgeStats() : Edge inactive.");
        }
        protoprocessor.writeInt(2);
        protoprocessor.writeInt(_gatherWhat);
        protoprocessor.flushWithResponse();
        edge = ESIProcessor.protoprocessor._in.readUTF();
        count = new Integer(edge);
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("collectEdgeStats() : plugins responded : " + count));
        }
        return count;
    }

    public static void invalidateIds(Iterator ids) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"invalidateIds", (Object[])new Object[0]);
        }
        ESIProcessor[] processors = ESIProcessor.getRunning();
        while (ids.hasNext()) {
            Object id = ids.next();
            if (!(id instanceof String)) continue;
            for (int idx = 0; idx < processors.length; ++idx) {
                try {
                    processors[idx].invalidateId((String)id);
                    continue;
                }
                catch (Exception e) {
                    Tr.warning((TraceComponent)_tc, (String)("failure invalidating " + id + " in " + processors[idx] + ": " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"invalidateIds");
        }
    }

    public static void clearCaches() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"clearCaches", (Object[])new Object[0]);
        }
        ESIProcessor[] processors = ESIProcessor.getRunning();
        for (int idx = 0; idx < processors.length; ++idx) {
            try {
                processors[idx].clearCache();
                continue;
            }
            catch (Exception e) {
                Tr.warning((TraceComponent)_tc, (String)("failure clearing cache in " + processors[idx] + ": " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"clearCaches");
        }
    }

    public static void resetCounters() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"resetCounters", (Object[])new Object[0]);
        }
        ESIProcessor[] processors = ESIProcessor.getRunning();
        for (int idx = 0; idx < processors.length; ++idx) {
            try {
                processors[idx].resetCounter();
                continue;
            }
            catch (Exception e) {
                Tr.warning((TraceComponent)_tc, (String)("failure resetting counters in " + processors[idx] + ": " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"resetCounters");
        }
    }

    public static synchronized ESIProcessorStats[] gather(int gatherWhat) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"gather", (Object[])new Object[0]);
        }
        ESIProcessor[] processors = ESIProcessor.getRunning();
        ESIProcessorStats[] stats = new ESIProcessorStats[processors.length];
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("submitting requests to " + stats.length + " ESI processors"), (Object[])new Object[0]);
        }
        for (int idx = 0; idx < stats.length; ++idx) {
            stats[idx] = new ESIProcessorStats(processors[idx], gatherWhat);
            processors[idx].submit(stats[idx]);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"waiting for responses", (Object[])new Object[0]);
        }
        int successCount = 0;
        for (int idx = 0; idx < stats.length; ++idx) {
            try {
                if (processors[idx].isAlive()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("waiting for response from " + processors[idx].toString()), (Object[])new Object[0]);
                    }
                    stats[idx].awaitCompletion();
                    ++successCount;
                    continue;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("processor is dead; not waiting for response from " + processors[idx].toString()), (Object[])new Object[0]);
                }
                stats[idx] = null;
                continue;
            }
            catch (Throwable th) {
                stats[idx] = null;
            }
        }
        if (stats.length > successCount) {
            ESIProcessorStats[] successStats = new ESIProcessorStats[successCount];
            successCount = 0;
            for (int idx = 0; idx < stats.length; ++idx) {
                if (stats[idx] == null) continue;
                successStats[successCount++] = stats[idx];
            }
            stats = successStats;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"gather");
        }
        return stats;
    }

    protected ESIProcessor(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this._serverPort = request.getServerPort();
        this._remotePort = request.getRemotePort();
        this._localPort = request.getLocalPort();
        this._localAddr = request.getLocalAddr();
        this._localName = request.getLocalName();
        this.initalizeProcessor(request.getRemoteHost(), new ESIInputStream((InputStream)request.getInputStream()), new ESIOutputStream((OutputStream)response.getOutputStream()));
    }

    protected ESIProcessor(String hostName, InputStream in, OutputStream out) throws IOException {
        this.initalizeProcessor(hostName, in, out);
    }

    private void initalizeProcessor(String hostName, InputStream in, OutputStream out) throws IOException {
        this._hostName = hostName;
        this._in = new ESIInputStream(in);
        this._out = new ESIOutputStream(out);
        this._isAlive = true;
        this._keepAliveDaemon = new ESIProcessorKeepAliveDaemon(45000L);
        this._keepAliveDaemon.setESIProcessor(this);
        this._keepAliveDaemon.start();
        this.initPID();
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("constructed " + this), (Object[])new Object[0]);
        }
    }

    public boolean isAlive() {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("is alive: " + this), (Object[])new Object[0]);
        }
        return this._isAlive;
    }

    public synchronized void markDead() {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("mark dead: " + this), (Object[])new Object[0]);
        }
        this._isAlive = false;
        if (this._keepAliveDaemon != null) {
            this._keepAliveDaemon.stop();
        }
        this.notify();
    }

    public String getHostName() {
        return this._hostName;
    }

    public int getPID() {
        return this._pid;
    }

    public synchronized void invalidateId(String id) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("invalidateId '" + id + "' in " + this), (Object[])new Object[0]);
        }
        this.writeInt(5);
        this.writeString(id);
        this.flush();
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("invalidateId '" + id + "' in " + this));
        }
    }

    public synchronized void clearCache() throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("clearCache in " + this), (Object[])new Object[0]);
        }
        this.writeInt(4);
        this.flush();
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("clearCache in " + this));
        }
    }

    public synchronized void resetCounter() throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("resetCounter in " + this), (Object[])new Object[0]);
        }
        this.writeInt(3);
        this.flush();
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("resetCounter in " + this));
        }
    }

    public synchronized void submit(ESIProcessorRequest request) throws IOException {
        this._curRequest = request;
        this.notify();
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("submit gather in " + this));
        }
    }

    private synchronized void listen() throws IOException {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("begin listening to " + this), (Object[])new Object[0]);
        }
        while (this._isAlive) {
            if (this._curRequest != null) {
                try {
                    this._curRequest.handle();
                    this._curRequest.markCompleted(null);
                }
                catch (Throwable throwable) {
                    this._curRequest.markCompleted(throwable);
                }
                this._curRequest = null;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("end listening to " + this), (Object[])new Object[0]);
        }
    }

    synchronized void initPID() throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("initPID from " + this), (Object[])new Object[0]);
        }
        this.writeInt(1);
        this.flush();
        this._pid = this.readInt();
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("initPID from " + this));
        }
    }

    public int available() throws IOException {
        return this._in.available();
    }

    public int readInt() throws IOException {
        try {
            int val = this._in.readInt();
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("readInt " + val), (Object[])new Object[0]);
            }
            return val;
        }
        catch (IOException ioe) {
            this.markDead();
            throw ioe;
        }
    }

    public String readString() throws IOException {
        try {
            String val = this._in.readUTF();
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("readString " + val), (Object[])new Object[0]);
            }
            return val;
        }
        catch (IOException ioe) {
            this.markDead();
            throw ioe;
        }
    }

    public void writeInt(int val) throws IOException {
        try {
            this._out.writeInt(val);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("writeInt " + val), (Object[])new Object[0]);
            }
        }
        catch (IOException ioe) {
            this.markDead();
            throw ioe;
        }
    }

    public void writeString(String str) throws IOException {
        try {
            this._out.writeUTF(str);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("writeString " + str), (Object[])new Object[0]);
            }
        }
        catch (IOException ioe) {
            this.markDead();
            throw ioe;
        }
    }

    public void flush() throws IOException {
        try {
            this._out.flush();
        }
        catch (IOException ioe) {
            this.markDead();
            throw ioe;
        }
    }

    public void flushWithResponse() throws IOException {
        try {
            this._in = this._out.flushWithResponse();
        }
        catch (IOException ioe) {
            this.markDead();
            throw ioe;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ESIProcessor[");
        buffer.append("_hostName = ").append(this._hostName);
        buffer.append(" _isAlive = ").append(this._isAlive);
        buffer.append(" _localAddr = ").append(this._localAddr);
        buffer.append(" _localName = ").append(this._localName);
        buffer.append(" _localPort = ").append(this._localPort);
        buffer.append(" _pid = ").append(this._pid);
        buffer.append(" _remotePort = ").append(this._remotePort);
        buffer.append(" _serverPort = ").append(this._serverPort);
        buffer.append("]");
        return buffer.toString();
    }
}

