/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.samplers;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class TraceIdRatioBasedSampler
implements Sampler {
    private static final SamplingResult POSITIVE_SAMPLING_RESULT = SamplingResult.recordAndSample();
    private static final SamplingResult NEGATIVE_SAMPLING_RESULT = SamplingResult.drop();
    private final long idUpperBound;
    private final String description;

    static TraceIdRatioBasedSampler create(double ratio) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new IllegalArgumentException("ratio must be in range [0.0, 1.0]");
        }
        long idUpperBound = ratio == 0.0 ? Long.MIN_VALUE : (ratio == 1.0 ? Long.MAX_VALUE : (long)(ratio * 9.223372036854776E18));
        return new TraceIdRatioBasedSampler(ratio, idUpperBound);
    }

    TraceIdRatioBasedSampler(double ratio, long idUpperBound) {
        this.idUpperBound = idUpperBound;
        this.description = "TraceIdRatioBased{" + TraceIdRatioBasedSampler.decimalFormat(ratio) + "}";
    }

    @Override
    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return Math.abs(TraceIdRatioBasedSampler.getTraceIdRandomPart(traceId)) < this.idUpperBound ? POSITIVE_SAMPLING_RESULT : NEGATIVE_SAMPLING_RESULT;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TraceIdRatioBasedSampler)) {
            return false;
        }
        TraceIdRatioBasedSampler that = (TraceIdRatioBasedSampler)obj;
        return this.idUpperBound == that.idUpperBound;
    }

    public int hashCode() {
        return Long.hashCode(this.idUpperBound);
    }

    public String toString() {
        return this.getDescription();
    }

    long getIdUpperBound() {
        return this.idUpperBound;
    }

    private static long getTraceIdRandomPart(String traceId) {
        return OtelEncodingUtils.longFromBase16String(traceId, 16);
    }

    private static String decimalFormat(double value) {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("0.000000", decimalFormatSymbols);
        return decimalFormat.format(value);
    }
}

