/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.persistence;

import com.ibm.jbatch.container.artifact.proxy.ItemReaderProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemWriterProxy;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.persistence.CheckpointData;
import com.ibm.jbatch.container.persistence.jpa.StepThreadInstanceEntity;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.chunk.CheckpointAlgorithm;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class CheckpointManager {
    private static final String sourceClass = CheckpointManager.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private ItemReaderProxy readerProxy;
    private ItemWriterProxy writerProxy;
    int commitInterval;
    private CheckpointAlgorithm checkpointAlgorithm;
    private long executionId;
    private StepThreadInstanceEntity stepThreadInstance;
    static final long serialVersionUID = 8200612055182549335L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public CheckpointManager(ItemReaderProxy reader, ItemWriterProxy writer, CheckpointAlgorithm chkptAlg, StepThreadInstanceEntity stepThreadInstance, IPersistenceManagerService persistenceManagerService) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.persistence.CheckpointManager", "<init>", new Object[]{reader, writer, chkptAlg, stepThreadInstance, persistenceManagerService});
        }
        this.readerProxy = null;
        this.writerProxy = null;
        this.commitInterval = 0;
        this.executionId = 0L;
        this.stepThreadInstance = null;
        this.readerProxy = reader;
        this.writerProxy = writer;
        this.checkpointAlgorithm = chkptAlg;
        this.stepThreadInstance = stepThreadInstance;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.persistence.CheckpointManager", "<init>", this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void beginCheckpoint() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.persistence.CheckpointManager", "beginCheckpoint", new Object[0]);
        }
        try {
            this.checkpointAlgorithm.beginCheckpoint();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.persistence.CheckpointManager", (String)"61", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerRuntimeException("Checkpoint algorithm failed", (Throwable)e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.persistence.CheckpointManager", "beginCheckpoint");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void endCheckpoint() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.persistence.CheckpointManager", "endCheckpoint", new Object[0]);
        }
        try {
            this.checkpointAlgorithm.endCheckpoint();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.persistence.CheckpointManager", (String)"69", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerRuntimeException("Checkpoint algorithm failed", (Throwable)e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.persistence.CheckpointManager", "endCheckpoint");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isReadyToCheckpoint() {
        String method = "isReadyToCheckpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        boolean checkpoint = false;
        try {
            checkpoint = this.checkpointAlgorithm.isReadyToCheckpoint();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.persistence.CheckpointManager", (String)"83", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerRuntimeException("Checkpoint algorithm failed", (Throwable)e);
        }
        if (logger.isLoggable(Level.FINE) && checkpoint) {
            logger.fine("isReadyToCheckpoint - " + checkpoint);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
        return checkpoint;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void checkpoint() {
        String method = "checkpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, " [executionId " + this.executionId + "] ");
        }
        CheckpointData data = null;
        try {
            data = new CheckpointData();
            data.setReaderCheckpoint(this.readerProxy.checkpointInfo());
            data.setWriterCheckpoint(this.writerProxy.checkpointInfo());
            this.stepThreadInstance.setCheckpointData(data);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.persistence.CheckpointManager", (String)"106", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerServiceException("Cannot persist the checkpoint data for " + this.stepThreadInstance);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, " [executionId " + this.executionId + "] ");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int checkpointTimeout() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.persistence.CheckpointManager", "checkpointTimeout", new Object[0]);
        }
        int returnTimeout = 0;
        try {
            returnTimeout = this.checkpointAlgorithm.checkpointTimeout();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.persistence.CheckpointManager", (String)"120", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerRuntimeException("Checkpoint algorithm checkpointTimeout() failed", (Throwable)e);
        }
        int n = returnTimeout;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.persistence.CheckpointManager", "checkpointTimeout", n);
        }
        return n;
    }
}

