/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery.yadis;

import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.html.dom.HTMLDocumentImpl;
import org.openid4java.discovery.yadis.YadisException;
import org.openid4java.discovery.yadis.YadisHtmlParser;
import org.openid4java.util.OpenID4JavaDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLHeadElement;
import org.w3c.dom.html.HTMLMetaElement;

public class CyberNekoDOMYadisHtmlParser
implements YadisHtmlParser {
    private static final Log _log = LogFactory.getLog(CyberNekoDOMYadisHtmlParser.class);
    private static final boolean DEBUG = _log.isDebugEnabled();

    public String getHtmlMeta(String input) throws YadisException {
        NodeList heads;
        String xrdsLocation = null;
        HTMLDocumentImpl doc = this.parseDocument(input);
        if (DEBUG) {
            try {
                _log.debug((Object)("document:\n" + OpenID4JavaDOMParser.toXmlString((Document)doc)));
            }
            catch (TransformerException e) {
                _log.debug((Object)"An exception occurs while transforming the document to string in debugging.", (Throwable)e);
            }
        }
        if ((heads = doc.getElementsByTagName("head")).getLength() != 1) {
            throw new YadisException("HTML response must have exactly one HEAD element, found " + heads.getLength() + " : " + heads.toString(), 1803);
        }
        HTMLHeadElement head = (HTMLHeadElement)doc.getHead();
        NodeList metaElements = head.getElementsByTagName("META");
        if (metaElements == null || metaElements.getLength() == 0) {
            if (DEBUG) {
                _log.debug((Object)"No <meta> element found under <html><head>. See Yadis specification, section 6.2.5/1.");
            }
        } else {
            int len = metaElements.getLength();
            for (int i = 0; i < len; ++i) {
                HTMLMetaElement metaElement = (HTMLMetaElement)metaElements.item(i);
                String httpEquiv = metaElement.getHttpEquiv();
                if (!"X-XRDS-Location".equalsIgnoreCase(httpEquiv)) continue;
                if (xrdsLocation != null) {
                    throw new YadisException("More than one X-XRDS-LocationMETA tags found in HEAD: " + head.toString(), 1803);
                }
                xrdsLocation = metaElement.getContent();
                if (!DEBUG) continue;
                _log.debug((Object)"Found X-XRDS-Location META tags.");
            }
        }
        return xrdsLocation;
    }

    private HTMLDocumentImpl parseDocument(String htmlData) throws YadisException {
        OpenID4JavaDOMParser parser = new OpenID4JavaDOMParser();
        try {
            parser.parse(OpenID4JavaDOMParser.createInputSource(htmlData));
        }
        catch (Exception e) {
            throw new YadisException("Error parsing HTML message", 1803, e);
        }
        if (parser.isIgnoredHeadStartElement()) {
            throw new YadisException("HTML response must have exactly one HEAD element.", 1803);
        }
        return (HTMLDocumentImpl)parser.getDocument();
    }
}

