/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.acme.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.acme.internal.AcmeProviderImpl;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AcmeCertCheckerTask
implements Runnable {
    private static final TraceComponent tc = Tr.register(AcmeCertCheckerTask.class, (String)"ACMECA", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
    private final AcmeProviderImpl acmeProviderImpl;
    private ScheduledFuture<?> certChecker;
    private ScheduledExecutorService service = null;
    private volatile boolean runningOnErrorSchedule = false;
    static final long serialVersionUID = 2362255497801895616L;

    public AcmeCertCheckerTask(AcmeProviderImpl acmePI) {
        this.acmeProviderImpl = acmePI;
    }

    public synchronized void stop() {
        this.cancel(true);
        this.certChecker = null;
    }

    protected synchronized void startCertificateChecker(ScheduledExecutorService service) {
        block10: {
            block9: {
                this.cancel(true);
                AcmeCertCheckerTask acmeCertCheckerTask = this;
                if (acmeCertCheckerTask.acmeProviderImpl.getAcmeConfig() == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Provided acmeProviderImpl.getAcmeConfig() is null, cannot start certificate checker", (Object[])new Object[0]);
                    }
                    return;
                }
                AcmeCertCheckerTask acmeCertCheckerTask2 = this;
                if (acmeCertCheckerTask2.acmeProviderImpl.getAcmeConfig().getCertCheckerScheduler() == 0L) break block9;
                AcmeCertCheckerTask acmeCertCheckerTask3 = this;
                if (acmeCertCheckerTask3.acmeProviderImpl.getAcmeConfig().isAutoRenewOnExpiration()) break block10;
                AcmeCertCheckerTask acmeCertCheckerTask4 = this;
                if (acmeCertCheckerTask4.acmeProviderImpl.getAcmeConfig().isRevocationCheckerEnabled().booleanValue()) break block10;
            }
            if (tc.isDebugEnabled()) {
                AcmeCertCheckerTask acmeCertCheckerTask = this;
                AcmeCertCheckerTask acmeCertCheckerTask5 = this;
                AcmeCertCheckerTask acmeCertCheckerTask6 = this;
                Tr.debug((TraceComponent)tc, (String)("ScheduledExecutorService not started for AcmeCertChecker, it is disabled-- getCertCheckerScheduler: " + acmeCertCheckerTask.acmeProviderImpl.getAcmeConfig().getCertCheckerScheduler() + ", isAutoRenewOnExpiration: " + acmeCertCheckerTask5.acmeProviderImpl.getAcmeConfig().isAutoRenewOnExpiration() + ", isRevocationCheckerEnabled: " + acmeCertCheckerTask6.acmeProviderImpl.getAcmeConfig().isRevocationCheckerEnabled()), (Object[])new Object[0]);
            }
            Tr.info((TraceComponent)tc, (String)"CWPKI2069I", (Object[])new Object[0]);
            return;
        }
        if (service == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Provided ScheduledExecutorService is null, cannot start certificate checker", (Object[])new Object[0]);
            }
            return;
        }
        this.service = service;
        if (tc.isDebugEnabled()) {
            AcmeCertCheckerTask acmeCertCheckerTask = this;
            Tr.debug((TraceComponent)tc, (String)("ScheduledExecutorService starting, time: " + acmeCertCheckerTask.acmeProviderImpl.getAcmeConfig().getCertCheckerScheduler()), (Object[])new Object[0]);
        }
        this.startRegularSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={Throwable.class})
    public void run() {
        boolean isExpired = false;
        boolean isRevoked = false;
        List<X509Certificate> currentCert = null;
        if (FrameworkState.isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Server is marked as stopping, cert checker will stop itself.", (Object[])new Object[0]);
            }
            this.stop();
            return;
        }
        this.acmeProviderImpl.acquireWriteLock();
        try {
            currentCert = this.acmeProviderImpl.getConfiguredDefaultCertificateChain();
            if (currentCert == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Attempted to check the current certificate, but it was null.", (Object[])new Object[0]);
                }
                return;
            }
            AcmeCertCheckerTask acmeCertCheckerTask = this;
            if (acmeCertCheckerTask.acmeProviderImpl.getAcmeConfig().isAutoRenewOnExpiration() && this.acmeProviderImpl.isExpired(currentCert)) {
                isExpired = true;
            } else if (this.acmeProviderImpl.isRevoked(currentCert)) {
                isRevoked = true;
            }
            if (isExpired || isRevoked) {
                if (isExpired) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = currentCert.get(0).getSerialNumber().toString(16);
                    objectArray[1] = currentCert.get(0).getNotAfter().toInstant().toString();
                    AcmeCertCheckerTask acmeCertCheckerTask2 = this;
                    objectArray[2] = acmeCertCheckerTask2.acmeProviderImpl.getAcmeConfig().getDirectoryURI();
                    Tr.info((TraceComponent)tc, (String)"CWPKI2052I", (Object[])objectArray);
                } else if (isRevoked) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = currentCert.get(0).getSerialNumber().toString(16);
                    AcmeCertCheckerTask acmeCertCheckerTask3 = this;
                    objectArray[1] = acmeCertCheckerTask3.acmeProviderImpl.getAcmeConfig().getDirectoryURI();
                    Tr.info((TraceComponent)tc, (String)"CWPKI2067I", (Object[])objectArray);
                }
                this.acmeProviderImpl.renewCertificate();
            } else {
                if (tc.isDebugEnabled()) {
                    AcmeCertCheckerTask acmeCertCheckerTask4 = this;
                    Tr.debug((TraceComponent)tc, (String)("ACME automatic certificate checker verified that the ACME CA cert is valid. Next check is " + acmeCertCheckerTask4.acmeProviderImpl.getAcmeConfig().getCertCheckerScheduler() + "ms. SN is " + currentCert.get(0).getSerialNumber().toString(16)), (Object[])new Object[0]);
                }
                if (this.runningOnErrorSchedule) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ACME automatic certificate checker was running on error time, but we have a valid certificate, swap back to the regular schedule", (Object[])new Object[0]);
                    }
                    this.startRegularSchedule();
                }
            }
        }
        catch (Throwable t) {
            if (FrameworkState.isStopping()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Caught an exception, but server is marked as stopping, cert checker returning.", (Object[])new Object[0]);
                }
                return;
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Requested a new certificate, but request failed.", (Object[])new Object[]{t});
                }
                if (currentCert == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Attempted to check the current certificate, but it was null. Stay on regular schedule.", (Object[])new Object[0]);
                    }
                    return;
                }
                String sn = currentCert.get(0).getSerialNumber().toString(16);
                if (isExpired) {
                    Object[] objectArray = new Object[4];
                    objectArray[0] = sn;
                    AcmeCertCheckerTask acmeCertCheckerTask = this;
                    objectArray[1] = acmeCertCheckerTask.acmeProviderImpl.getAcmeConfig().getCertCheckerErrorScheduler() + "ms";
                    objectArray[2] = currentCert.get(0).getNotAfter().toInstant().toString();
                    objectArray[3] = t;
                    Tr.warning((TraceComponent)tc, (String)"CWPKI2065W", (Object[])objectArray);
                } else if (isRevoked) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = sn;
                    AcmeCertCheckerTask acmeCertCheckerTask = this;
                    objectArray[1] = acmeCertCheckerTask.acmeProviderImpl.getAcmeConfig().getCertCheckerErrorScheduler() + "ms";
                    objectArray[2] = t;
                    Tr.error((TraceComponent)tc, (String)"CWPKI2066E", (Object[])objectArray);
                } else {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = sn;
                    AcmeCertCheckerTask acmeCertCheckerTask = this;
                    objectArray[1] = acmeCertCheckerTask.acmeProviderImpl.getAcmeConfig().getCertCheckerErrorScheduler() + "ms";
                    objectArray[2] = t;
                    Tr.warning((TraceComponent)tc, (String)"CWPKI2068W", (Object[])objectArray);
                }
                this.cancel(false);
                if (tc.isDebugEnabled()) {
                    AcmeCertCheckerTask acmeCertCheckerTask = this;
                    Tr.debug((TraceComponent)tc, (String)("Certificate request failed, swapping to the error schedule: " + acmeCertCheckerTask.acmeProviderImpl.getAcmeConfig().getCertCheckerErrorScheduler()), (Object[])new Object[0]);
                }
            }
            finally {
                this.startErrorSchedule();
            }
        }
        finally {
            this.acmeProviderImpl.releaseWriteLock();
        }
    }

    private synchronized void cancel(boolean interrupt) {
        if (this.certChecker != null) {
            this.certChecker.cancel(interrupt);
        }
    }

    private void startRegularSchedule() {
        this.cancel(false);
        AcmeCertCheckerTask acmeCertCheckerTask = this;
        AcmeCertCheckerTask acmeCertCheckerTask2 = this;
        this.certChecker = this.service.scheduleAtFixedRate(this, acmeCertCheckerTask.acmeProviderImpl.getAcmeConfig().getCertCheckerScheduler(), acmeCertCheckerTask2.acmeProviderImpl.getAcmeConfig().getCertCheckerScheduler(), TimeUnit.MILLISECONDS);
        this.runningOnErrorSchedule = false;
    }

    private void startErrorSchedule() {
        this.cancel(false);
        AcmeCertCheckerTask acmeCertCheckerTask = this;
        AcmeCertCheckerTask acmeCertCheckerTask2 = this;
        this.certChecker = this.service.scheduleAtFixedRate(this, acmeCertCheckerTask.acmeProviderImpl.getAcmeConfig().getCertCheckerErrorScheduler(), acmeCertCheckerTask2.acmeProviderImpl.getAcmeConfig().getCertCheckerErrorScheduler(), TimeUnit.MILLISECONDS);
        this.runningOnErrorSchedule = true;
    }
}

