/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.util.TraversalControl;
import graphql.util.Traverser;
import graphql.util.TraverserContext;
import graphql.util.TraverserResult;
import graphql.util.TraverserVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@PublicApi
public class SchemaTraverser {
    private final Function<? super GraphQLSchemaElement, ? extends List<GraphQLSchemaElement>> getChildren;

    public SchemaTraverser(Function<? super GraphQLSchemaElement, ? extends List<GraphQLSchemaElement>> getChildren) {
        this.getChildren = getChildren;
    }

    public SchemaTraverser() {
        this(GraphQLSchemaElement::getChildren);
    }

    public TraverserResult depthFirstFullSchema(GraphQLTypeVisitor typeVisitor, GraphQLSchema schema) {
        return this.depthFirstFullSchema(Collections.singletonList(typeVisitor), schema, ImmutableKit.emptyMap());
    }

    public TraverserResult depthFirstFullSchema(List<GraphQLTypeVisitor> typeVisitors, GraphQLSchema schema, Map<Class<?>, Object> rootVars) {
        LinkedHashSet<GraphQLSchemaElement> roots = new LinkedHashSet<GraphQLSchemaElement>();
        roots.add(schema.getQueryType());
        if (schema.isSupportingMutations()) {
            roots.add(schema.getMutationType());
        }
        if (schema.isSupportingSubscriptions()) {
            roots.add(schema.getSubscriptionType());
        }
        roots.addAll(schema.getAdditionalTypes());
        roots.addAll(schema.getDirectives());
        roots.addAll(schema.getSchemaDirectives());
        roots.add(schema.getIntrospectionSchemaType());
        TraverserDelegateListVisitor traverserDelegateListVisitor = new TraverserDelegateListVisitor(typeVisitors);
        return this.initTraverser().rootVars(rootVars).traverse(roots, (TraverserVisitor<GraphQLSchemaElement>)traverserDelegateListVisitor);
    }

    public TraverserResult depthFirst(GraphQLTypeVisitor graphQLTypeVisitor, GraphQLSchemaElement root) {
        return this.depthFirst(graphQLTypeVisitor, Collections.singletonList(root));
    }

    public TraverserResult depthFirst(GraphQLTypeVisitor graphQLTypeVisitor, Collection<? extends GraphQLSchemaElement> roots) {
        return this.depthFirst(this.initTraverser(), new TraverserDelegateVisitor(graphQLTypeVisitor), roots);
    }

    public TraverserResult depthFirst(Traverser<GraphQLSchemaElement> traverser, TraverserDelegateVisitor traverserDelegateVisitor, Collection<? extends GraphQLSchemaElement> roots) {
        return this.doTraverse(traverser, roots, traverserDelegateVisitor);
    }

    private Traverser<GraphQLSchemaElement> initTraverser() {
        return Traverser.depthFirst(this.getChildren);
    }

    private TraverserResult doTraverse(Traverser<GraphQLSchemaElement> traverser, Collection<? extends GraphQLSchemaElement> roots, TraverserDelegateVisitor traverserDelegateVisitor) {
        return traverser.traverse(roots, (TraverserVisitor<GraphQLSchemaElement>)traverserDelegateVisitor);
    }

    private static class TraverserDelegateListVisitor
    implements TraverserVisitor<GraphQLSchemaElement> {
        private final List<GraphQLTypeVisitor> typeVisitors;

        TraverserDelegateListVisitor(List<GraphQLTypeVisitor> typeVisitors) {
            this.typeVisitors = typeVisitors;
        }

        @Override
        public TraversalControl enter(TraverserContext<GraphQLSchemaElement> context) {
            for (GraphQLTypeVisitor graphQLTypeVisitor : this.typeVisitors) {
                context.thisNode().accept(context, graphQLTypeVisitor);
            }
            return TraversalControl.CONTINUE;
        }

        @Override
        public TraversalControl leave(TraverserContext<GraphQLSchemaElement> context) {
            return TraversalControl.CONTINUE;
        }

        @Override
        public TraversalControl backRef(TraverserContext<GraphQLSchemaElement> context) {
            for (GraphQLTypeVisitor graphQLTypeVisitor : this.typeVisitors) {
                graphQLTypeVisitor.visitBackRef(context);
            }
            return TraversalControl.CONTINUE;
        }
    }

    private static class TraverserDelegateVisitor
    implements TraverserVisitor<GraphQLSchemaElement> {
        private final GraphQLTypeVisitor delegate;

        TraverserDelegateVisitor(GraphQLTypeVisitor delegate) {
            this.delegate = delegate;
        }

        @Override
        public TraversalControl enter(TraverserContext<GraphQLSchemaElement> context) {
            return context.thisNode().accept(context, this.delegate);
        }

        @Override
        public TraversalControl leave(TraverserContext<GraphQLSchemaElement> context) {
            return TraversalControl.CONTINUE;
        }

        @Override
        public TraversalControl backRef(TraverserContext<GraphQLSchemaElement> context) {
            return this.delegate.visitBackRef(context);
        }
    }
}

