/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.scim20.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.wim.scim20.exceptions.InvalidVersionException;
import com.ibm.websphere.security.wim.scim20.exceptions.NotFoundException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RESTUtil {
    public static final String SCIM_VERSION_1_0 = "v1";
    public static final String SCIM_VERSION_2_0 = "v2";
    private static final Pattern URL_PATH_PATTERN;
    static final long serialVersionUID = -1549102348578950113L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String getApiVersion(String requestPath) throws InvalidVersionException {
        String version = null;
        Matcher m = URL_PATH_PATTERN.matcher(requestPath);
        if (m.matches()) {
            version = m.group(1);
        }
        if (version != null && !SCIM_VERSION_2_0.equals(version)) {
            throw new InvalidVersionException("The URL contained an invalid SCIM version (" + version + ")");
        }
        version = SCIM_VERSION_2_0;
        return version;
    }

    public static String getEnpoint(String requestPath) throws NotFoundException {
        String endpoint = null;
        Matcher m = URL_PATH_PATTERN.matcher(requestPath);
        if (m.matches()) {
            endpoint = m.group(2);
        }
        return endpoint;
    }

    public static String getResourceId(String requestPath) {
        String resourceId = null;
        Matcher m = URL_PATH_PATTERN.matcher(requestPath);
        if (m.matches()) {
            resourceId = m.group(3);
        }
        return resourceId;
    }

    public static Set<String> getExcludedAttributes(RESTRequest request) {
        String[] attributes = request.getParameterValues("excludedAttributes");
        if (attributes == null || attributes.length == 0) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(attributes));
    }

    public static Set<String> getAttributes(RESTRequest request) {
        String[] attributes = request.getParameterValues("attributes");
        if (attributes == null || attributes.length == 0) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(attributes));
    }

    public static String getFilter(RESTRequest request) {
        String[] filter = request.getParameterValues("filter");
        if (filter == null || filter.length == 0 || filter[0] == null || filter[0].trim().isEmpty()) {
            return null;
        }
        return filter[0];
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.wim.scim20.rest.RESTUtil", RESTUtil.class, (String)"SCIM20", (String)"com.ibm.ws.security.wim.scim20.resources.SCIMUtilMessages");
        URL_PATH_PATTERN = Pattern.compile("/scim/?(v[^/]+)?/?([^/]+)/?(.+)?");
    }
}

