/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.graphql.authorization.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.graphql.authorization.component.AuthorizationFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.util.RoleMethodAuthUtil;
import com.ibm.ws.security.authorization.util.UnauthenticatedException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.graphql.GraphQLApi;
import org.eclipse.microprofile.graphql.GraphQLException;

@Dependent
@GraphQLApi
@Interceptor
@Priority(value=0)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthorizationInterceptor {
    private static final TraceComponent tc = Tr.register(AuthorizationInterceptor.class, (String)"GraphQL", null);
    private static final AuthorizationFilter AUTH_FILTER = AuthorizationFilter.getInstance();
    private static final Supplier<Principal> AUTH_FILTER_PRINCIPAL = new Supplier<Principal>(){
        static final long serialVersionUID = 1189940229752762096L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public Principal get() {
            return AUTH_FILTER.getUserPrincipal();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.graphql.authorization.component.AuthorizationInterceptor$1", 1.class, (String)"GraphQL", null);
        }
    };
    static final long serialVersionUID = 8633130029121305110L;

    @AroundInvoke
    public Object checkAuthorized(InvocationContext ctx) throws Exception {
        Method m = ctx.getMethod();
        if (this.isAuthorized(m)) {
            return ctx.proceed();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Unauthorized", (Object[])new Object[0]);
        }
        throw new GraphQLException("Unauthorized");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FFDCIgnore(value={UnauthenticatedException.class})
    private boolean isAuthorized(Method m) {
        try {
            return RoleMethodAuthUtil.parseMethodSecurity((Method)m, AUTH_FILTER_PRINCIPAL, AUTH_FILTER::isUserInRole);
        }
        catch (UnauthenticatedException ex) {
            try {
                if (!AUTH_FILTER.authenticate()) return false;
                if (!RoleMethodAuthUtil.parseMethodSecurity((Method)m, AUTH_FILTER_PRINCIPAL, AUTH_FILTER::isUserInRole)) return false;
                return true;
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.graphql.authorization.component.AuthorizationInterceptor", (String)"74", (Object)this, (Object[])new Object[]{m});
                if (!TraceComponent.isAnyTracingEnabled()) return false;
                if (!tc.isDebugEnabled()) return false;
                Tr.debug((TraceComponent)tc, (String)"Failed to authenticate or failed auth check", (Object[])new Object[]{t});
                return false;
            }
        }
    }
}

