/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.annotations.Tool;
import io.openliberty.mcp.annotations.ToolArg;
import io.openliberty.mcp.internal.SpecialArgumentType;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public record ToolMetadata(Tool annotation, Bean<?> bean, AnnotatedMethod<?> method, Map<String, ArgumentMetadata> arguments, List<SpecialArgumentMetadata> specialArguments, String name, String title, String description) {
    static final long serialVersionUID = 6456485077183935457L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ToolMetadata {
        arguments = arguments == null ? Collections.emptyMap() : arguments;
        specialArguments = specialArguments == null ? Collections.emptyList() : specialArguments;
    }

    public static ToolMetadata createFrom(Tool annotation, Bean<?> bean, AnnotatedMethod<?> method) {
        String name = annotation.name().equals("<<element name>>") ? method.getJavaMember().getName() : annotation.name();
        String title = annotation.title().isEmpty() ? null : annotation.title();
        String description = annotation.description().isEmpty() ? null : annotation.description();
        return new ToolMetadata(annotation, bean, method, ToolMetadata.getArgumentMap(method), ToolMetadata.getSpecialArgumentList(method), name, title, description);
    }

    private static Map<String, ArgumentMetadata> getArgumentMap(AnnotatedMethod<?> method) {
        HashMap<String, ArgumentMetadata> result = new HashMap<String, ArgumentMetadata>();
        for (AnnotatedParameter p : method.getParameters()) {
            ToolArg pInfo = (ToolArg)p.getAnnotation(ToolArg.class);
            if (pInfo == null) continue;
            ArgumentMetadata pData = new ArgumentMetadata(p.getBaseType(), p.getPosition(), pInfo.description(), pInfo.required());
            if (pInfo.name().equals("<<element name>>")) {
                result.put(method.getJavaMember().getName(), pData);
                continue;
            }
            result.put(pInfo.name(), pData);
        }
        return result.isEmpty() ? Collections.emptyMap() : result;
    }

    private static List<SpecialArgumentMetadata> getSpecialArgumentList(AnnotatedMethod<?> method) {
        ArrayList<SpecialArgumentMetadata> result = new ArrayList<SpecialArgumentMetadata>();
        for (AnnotatedParameter p : method.getParameters()) {
            ToolArg pInfo = (ToolArg)p.getAnnotation(ToolArg.class);
            if (pInfo != null) continue;
            SpecialArgumentMetadata pData = new SpecialArgumentMetadata(SpecialArgumentType.fromClass(p.getBaseType()), p.getPosition());
            result.add(pData);
        }
        return Collections.unmodifiableList(result);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.ToolMetadata", ToolMetadata.class, (String)"MCP", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public record ArgumentMetadata(Type type, int index, String description, boolean required) {
        static final long serialVersionUID = 349654338531560878L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.ToolMetadata$ArgumentMetadata", ArgumentMetadata.class, (String)"MCP", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public record SpecialArgumentMetadata(SpecialArgumentType type, int index) {
        static final long serialVersionUID = -3468671423932474943L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.ToolMetadata$SpecialArgumentMetadata", SpecialArgumentMetadata.class, (String)"MCP", null);
        }
    }
}

