/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCErrorCode;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public enum RequestMethod {
    TOOLS_CALL("tools/call"),
    TOOLS_LIST("tools/list"),
    INITIALIZE("initialize"),
    INITIALIZED("notifications/initialized"),
    CANCELLED("notifications/cancelled"),
    PING("ping");

    private static final Map<String, RequestMethod> METHODS_BY_NAME;
    private final String methodName;

    private RequestMethod(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public static RequestMethod getForMethodName(String methodName) throws NoSuchElementException {
        RequestMethod result = METHODS_BY_NAME.get(methodName);
        if (result == null) {
            throw new JSONRPCException(JSONRPCErrorCode.METHOD_NOT_FOUND, List.of(methodName + " not found"));
        }
        return result;
    }

    static {
        METHODS_BY_NAME = new HashMap<String, RequestMethod>();
        for (RequestMethod m : RequestMethod.values()) {
            METHODS_BY_NAME.put(m.getMethodName(), m);
        }
    }
}

