/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.annotations.Tool;
import io.openliberty.mcp.internal.ToolMetadata;
import io.openliberty.mcp.internal.ToolRegistry;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpCdiExtension
implements Extension {
    private ToolRegistry tools = new ToolRegistry();
    private ConcurrentHashMap<String, LinkedList<String>> duplicateToolsMap = new ConcurrentHashMap();
    static final long serialVersionUID = -3886719924273797612L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    void registerTools(@Observes ProcessManagedBean<?> pmb) {
        AnnotatedType type = pmb.getAnnotatedBeanClass();
        Class javaClass = type.getJavaClass();
        for (AnnotatedMethod m : type.getMethods()) {
            Tool toolAnnotation = (Tool)m.getAnnotation(Tool.class);
            if (toolAnnotation == null) continue;
            this.registerTool(toolAnnotation, pmb.getBean(), m, javaClass.getName());
        }
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager manager) {
        this.duplicateToolsMap.entrySet().removeIf(e -> ((LinkedList)e.getValue()).size() == 1);
        StringBuilder sb = new StringBuilder("More than one MCP tool has the same name: \n");
        for (String toolName : this.duplicateToolsMap.keySet()) {
            LinkedList<String> qualifiedNames = this.duplicateToolsMap.get(toolName);
            sb.append("Tool: ").append(toolName);
            sb.append(" -- Methods found:\n");
            for (String qualifiedName : qualifiedNames) {
                sb.append("    - ").append(qualifiedName + "\n");
            }
        }
        if (this.duplicateToolsMap.size() != 0) {
            afterDeploymentValidation.addDeploymentProblem((Throwable)new Exception(sb.toString()));
        }
    }

    private void registerTool(Tool tool, Bean<?> bean, AnnotatedMethod<?> method, String qualifiedName) {
        ToolMetadata toolmd = ToolMetadata.createFrom(tool, bean, method);
        this.duplicateToolsMap.computeIfAbsent(toolmd.name(), key -> new LinkedList()).add(qualifiedName + "." + method.getJavaMember().getName() + "()");
        this.tools.addTool(toolmd);
    }

    public ToolRegistry getToolRegistry() {
        return this.tools;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.McpCdiExtension", McpCdiExtension.class, (String)"MCP", null);
    }
}

