/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import javax.faces.context.ExternalContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.myfaces.config.ConfigFilesXmlValidationUtils;
import org.apache.myfaces.config.element.facelets.FaceletTagLibrary;
import org.apache.myfaces.config.impl.digester.elements.facelets.FaceletBehaviorTagImpl;
import org.apache.myfaces.config.impl.digester.elements.facelets.FaceletComponentTagImpl;
import org.apache.myfaces.config.impl.digester.elements.facelets.FaceletConverterTagImpl;
import org.apache.myfaces.config.impl.digester.elements.facelets.FaceletFunctionImpl;
import org.apache.myfaces.config.impl.digester.elements.facelets.FaceletHandlerTagImpl;
import org.apache.myfaces.config.impl.digester.elements.facelets.FaceletSourceTagImpl;
import org.apache.myfaces.config.impl.digester.elements.facelets.FaceletTagImpl;
import org.apache.myfaces.config.impl.digester.elements.facelets.FaceletTagLibraryImpl;
import org.apache.myfaces.config.impl.digester.elements.facelets.FaceletValidatorTagImpl;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.view.facelets.util.ReflectionUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TagLibraryConfigUnmarshallerImpl {
    public static FaceletTagLibrary create(ExternalContext externalContext, URL url) throws IOException {
        InputStream is = null;
        FaceletTagLibrary t = null;
        URLConnection conn = null;
        try {
            String version;
            boolean schemaValidating = false;
            if (MyfacesConfig.getCurrentInstance((ExternalContext)externalContext).isValidateXML() && (schemaValidating = "2.0".equals(version = ConfigFilesXmlValidationUtils.getFaceletTagLibVersion(url)))) {
                ConfigFilesXmlValidationUtils.validateFaceletTagLibFile(url, externalContext, version);
            }
            LibraryHandler handler = new LibraryHandler(url);
            SAXParser parser = TagLibraryConfigUnmarshallerImpl.createSAXParser(handler, externalContext, schemaValidating);
            conn = url.openConnection();
            conn.setUseCaches(false);
            is = conn.getInputStream();
            parser.parse(is, (DefaultHandler)handler);
            t = handler.getLibrary();
        }
        catch (SAXException e) {
            IOException ioe = new IOException("Error parsing [" + url + "]: ");
            ioe.initCause(e);
            throw ioe;
        }
        catch (ParserConfigurationException e) {
            IOException ioe = new IOException("Error parsing [" + url + "]: ");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return t;
    }

    private static final SAXParser createSAXParser(LibraryHandler handler, ExternalContext externalContext, boolean schemaValidating) throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        if (MyfacesConfig.getCurrentInstance((ExternalContext)externalContext).isValidateXML() && !schemaValidating) {
            factory.setNamespaceAware(false);
            factory.setFeature("http://xml.org/sax/features/validation", true);
            factory.setValidating(true);
        } else {
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setValidating(false);
        }
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setErrorHandler(handler);
        reader.setEntityResolver(handler);
        return parser;
    }

    private static class LibraryHandler
    extends DefaultHandler {
        private final URL source;
        private FaceletTagLibraryImpl library;
        private final StringBuffer buffer;
        private Locator locator;
        private String tagName;
        private String converterId;
        private String validatorId;
        private String behaviorId;
        private String componentType;
        private String rendererType;
        private String functionName;
        private String handlerClass;
        private String functionClass;
        private String functionSignature;
        private String resourceId;

        public LibraryHandler(URL source) {
            this.source = source;
            this.buffer = new StringBuffer(64);
        }

        public FaceletTagLibrary getLibrary() {
            return this.library;
        }

        private FaceletTagLibraryImpl getLibraryImpl() {
            if (this.library == null) {
                this.library = new FaceletTagLibraryImpl();
            }
            return this.library;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                if (!"facelet-taglib".equals(qName)) {
                    if ("library-class".equals(qName)) {
                        this.getLibraryImpl().setLibraryClass(this.captureBuffer());
                    } else if ("short-name".equals(qName)) {
                        this.getLibraryImpl().setShortName(this.captureBuffer());
                    } else if ("namespace".equals(qName)) {
                        this.getLibraryImpl().setNamespace(this.captureBuffer());
                    } else if ("composite-library-name".equals(qName)) {
                        this.getLibraryImpl().setCompositeLibraryName(this.captureBuffer());
                    } else if ("component-type".equals(qName)) {
                        this.componentType = this.captureBuffer();
                    } else if ("renderer-type".equals(qName)) {
                        this.rendererType = this.captureBufferEmptyNull();
                    } else if ("tag-name".equals(qName)) {
                        this.tagName = this.captureBuffer();
                    } else if ("function-name".equals(qName)) {
                        this.functionName = this.captureBuffer();
                    } else if ("function-class".equals(qName)) {
                        this.functionClass = this.captureBuffer();
                    } else if (!("description".equals(qName) || "display-name".equals(qName) || "icon".equals(qName))) {
                        if ("resource-id".equals(qName)) {
                            this.resourceId = this.captureBuffer();
                        } else {
                            if (this.library == null) {
                                throw new IllegalStateException("No <namespace> element");
                            }
                            if (this.library.getNamespace() == null) {
                                throw new IllegalStateException("No <namespace> element");
                            }
                            if ("tag".equals(qName)) {
                                if (this.handlerClass != null) {
                                    this.getLibraryImpl().addTag(new FaceletTagImpl(this.tagName, new FaceletHandlerTagImpl(this.handlerClass)));
                                    this.handlerClass = null;
                                }
                            } else if ("handler-class".equals(qName)) {
                                this.handlerClass = this.captureBufferEmptyNull();
                            } else if ("component".equals(qName)) {
                                if (this.handlerClass != null) {
                                    this.getLibraryImpl().addTag(new FaceletTagImpl(this.tagName, new FaceletComponentTagImpl(this.componentType, this.rendererType, this.handlerClass, null)));
                                    this.handlerClass = null;
                                } else if (this.resourceId != null) {
                                    this.getLibraryImpl().addTag(new FaceletTagImpl(this.tagName, new FaceletComponentTagImpl(null, null, null, this.resourceId)));
                                    this.resourceId = null;
                                    this.handlerClass = null;
                                } else {
                                    this.getLibraryImpl().addTag(new FaceletTagImpl(this.tagName, new FaceletComponentTagImpl(this.componentType, this.rendererType, null, null)));
                                    this.handlerClass = null;
                                }
                            } else if ("converter-id".equals(qName)) {
                                this.converterId = this.captureBuffer();
                            } else if ("converter".equals(qName)) {
                                if (this.handlerClass != null) {
                                    this.getLibraryImpl().addTag(new FaceletTagImpl(this.tagName, new FaceletConverterTagImpl(this.converterId, this.handlerClass)));
                                    this.handlerClass = null;
                                } else {
                                    this.getLibraryImpl().addTag(new FaceletTagImpl(this.tagName, new FaceletConverterTagImpl(this.converterId)));
                                }
                                this.converterId = null;
                            } else if ("validator-id".equals(qName)) {
                                this.validatorId = this.captureBuffer();
                            } else if ("validator".equals(qName)) {
                                if (this.handlerClass != null) {
                                    this.getLibraryImpl().addTag(new FaceletTagImpl(this.tagName, new FaceletValidatorTagImpl(this.validatorId, this.handlerClass)));
                                    this.handlerClass = null;
                                } else {
                                    this.getLibraryImpl().addTag(new FaceletTagImpl(this.tagName, new FaceletValidatorTagImpl(this.validatorId)));
                                }
                                this.validatorId = null;
                            } else if ("behavior-id".equals(qName)) {
                                this.behaviorId = this.captureBuffer();
                            } else if ("behavior".equals(qName)) {
                                if (this.handlerClass != null) {
                                    this.getLibraryImpl().addTag(new FaceletTagImpl(this.tagName, new FaceletBehaviorTagImpl(this.behaviorId, this.handlerClass)));
                                    this.handlerClass = null;
                                } else {
                                    this.getLibraryImpl().addTag(new FaceletTagImpl(this.tagName, new FaceletBehaviorTagImpl(this.behaviorId)));
                                }
                                this.behaviorId = null;
                            } else if ("source".equals(qName)) {
                                String path = this.captureBuffer();
                                URL url = new URL(this.source, path);
                                this.getLibraryImpl().addTag(new FaceletTagImpl(this.tagName, new FaceletSourceTagImpl(url.toString())));
                            } else if ("function-signature".equals(qName)) {
                                this.functionSignature = this.captureBuffer();
                                this.getLibraryImpl().addFunction(new FaceletFunctionImpl(this.functionName, this.functionClass, this.functionSignature));
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new SAXParseException("Error Handling [" + this.source + "@" + this.locator.getLineNumber() + "," + this.locator.getColumnNumber() + "] <" + qName + ">", this.locator, e);
            }
        }

        private String captureBuffer() throws Exception {
            String s = this.buffer.toString().trim();
            if (s.length() == 0) {
                throw new Exception("Value Cannot be Empty");
            }
            this.buffer.setLength(0);
            return s;
        }

        private String captureBufferEmptyNull() throws Exception {
            String s = this.buffer.toString().trim();
            if (s.length() == 0) {
                s = null;
            }
            this.buffer.setLength(0);
            return s;
        }

        private static <T> Class<? extends T> createClass(Class<T> type, String name) throws Exception {
            Class<?> factory = ReflectionUtil.forName(name);
            if (!type.isAssignableFrom(factory)) {
                throw new Exception(name + " must be an instance of " + type.getName());
            }
            return factory;
        }

        private static Method createMethod(Class<?> type, String s) throws Exception {
            Class[] pc;
            int pos = s.indexOf(32);
            if (pos == -1) {
                throw new Exception("Must Provide Return Type: " + s);
            }
            int pos2 = s.indexOf(40, pos + 1);
            if (pos2 == -1) {
                throw new Exception("Must provide a method name, followed by '(': " + s);
            }
            String mn = s.substring(pos + 1, pos2).trim();
            pos = s.indexOf(41, pos2 + 1);
            if (pos == -1) {
                throw new Exception("Must close parentheses, ')' missing: " + s);
            }
            String[] ps = s.substring(pos2 + 1, pos).trim().split(",");
            if (ps.length == 1 && "".equals(ps[0])) {
                pc = new Class[]{};
            } else {
                pc = new Class[ps.length];
                for (int i = 0; i < pc.length; ++i) {
                    pc[i] = ReflectionUtil.forName(ps[i].trim());
                }
            }
            try {
                return type.getMethod(mn, pc);
            }
            catch (NoSuchMethodException e) {
                throw new Exception("No Function Found on type: " + type.getName() + " with signature: " + s);
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if ("-//Sun Microsystems, Inc.//DTD Facelet Taglib 1.0//EN".equals(publicId)) {
                URL url = ClassUtils.getResource("org/apache/myfaces/resource/facelet-taglib_1_0.dtd");
                return new InputSource(url.toExternalForm());
            }
            return null;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.buffer.setLength(0);
            if ("tag".equals(qName)) {
                this.handlerClass = null;
                this.componentType = null;
                this.rendererType = null;
                this.tagName = null;
            } else if ("function".equals(qName)) {
                this.functionName = null;
                this.functionClass = null;
                this.functionSignature = null;
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw new SAXException("Error Handling [" + this.source + "@" + e.getLineNumber() + "," + e.getColumnNumber() + "]", e);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

