/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.pojo;

import com.ibm.websphere.jsonsupport.JSONMarshallException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.v1.ICatalog;
import com.ibm.ws.ui.internal.v1.ITool;
import com.ibm.ws.ui.internal.v1.IToolbox;
import com.ibm.ws.ui.internal.v1.pojo.Bookmark;
import com.ibm.ws.ui.internal.v1.pojo.DuplicateException;
import com.ibm.ws.ui.internal.v1.pojo.FeatureTool;
import com.ibm.ws.ui.internal.v1.pojo.NoSuchToolException;
import com.ibm.ws.ui.internal.v1.pojo.ToolEntry;
import com.ibm.ws.ui.internal.validation.InvalidToolException;
import com.ibm.ws.ui.internal.validation.InvalidToolboxException;
import com.ibm.ws.ui.persistence.IPersistenceProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Toolbox
implements IToolbox {
    private static final transient TraceComponent tc = Tr.register(Toolbox.class);
    public static final transient String PERSIST_NAME = "toolbox";
    private transient ICatalog catalog;
    private transient IPersistenceProvider persist;
    private transient String persistedName;
    private String ownerId = null;
    private String ownerDisplayName = null;
    private Map<String, Object> _metadata = null;
    private Map<String, Object> preferences = null;
    private List<ToolEntry> toolEntries = null;
    private Map<String, Bookmark> bookmarks = null;

    private Toolbox() {
    }

    private void initializeDefaultToolbox() {
        ArrayList<ToolEntry> toolEntries = new ArrayList<ToolEntry>();
        for (FeatureTool featureTool : this.catalog.getFeatureTools()) {
            toolEntries.add(new ToolEntry(featureTool.getId(), featureTool.getType()));
        }
        for (Bookmark bookmark : this.catalog.getBookmarks()) {
            toolEntries.add(new ToolEntry(bookmark.getId(), bookmark.getType()));
        }
        this.setToolEntries(toolEntries);
        this.setBookmarks(new ArrayList<Bookmark>());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isDefault", true);
        map.put("lastModified", new Date().getTime());
        this.set_metadata(map);
        this.setPreferences(Collections.emptyMap());
    }

    public Toolbox(ICatalog catalog, IPersistenceProvider persist, String userId, String userDisplayName) {
        this.setCatalog(catalog);
        this.setPersistenceProvider(persist);
        this.setOwnerId(userId);
        this.setOwnerDisplayName(userDisplayName);
        this.initializeDefaultToolbox();
    }

    public static String getEncodedUserId(String userId) {
        String encodedUserId = userId;
        if (userId != null) {
            encodedUserId = Base64.getUrlEncoder().encodeToString(userId.getBytes());
        }
        return encodedUserId;
    }

    public synchronized void setCatalog(ICatalog catalog) {
        this.catalog = catalog;
    }

    public synchronized void setPersistenceProvider(IPersistenceProvider persist) {
        this.persist = persist;
    }

    @Trivial
    private synchronized void setOwnerId(String userId) {
        this.ownerId = userId;
        this.persistedName = "toolbox-" + Toolbox.getEncodedUserId(userId);
    }

    @Override
    @Trivial
    public String getOwnerId() {
        return this.ownerId;
    }

    @Trivial
    private synchronized void setOwnerDisplayName(String userDisplayName) {
        this.ownerDisplayName = userDisplayName;
    }

    @Override
    @Trivial
    public synchronized String getOwnerDisplayName() {
        return this.ownerDisplayName;
    }

    @Trivial
    private synchronized void set_metadata(Map<String, Object> _metadata) {
        this._metadata = _metadata;
    }

    @Override
    @Trivial
    public synchronized Map<String, Object> get_metadata() {
        if (this._metadata == null) {
            return null;
        }
        HashMap<String, Object> returnedMap = new HashMap<String, Object>();
        returnedMap.putAll(this._metadata);
        return Collections.unmodifiableMap(returnedMap);
    }

    @Trivial
    private synchronized void setPreferences(Map<String, Object> preferences) {
        this.preferences = preferences;
    }

    @Override
    @Trivial
    public synchronized Map<String, Object> getPreferences() {
        return Collections.unmodifiableMap(this.preferences);
    }

    private boolean containsXSS(Object field) {
        if (field instanceof String) {
            String toValidate = (String)field;
            String lower = toValidate.toLowerCase();
            return lower.indexOf("<script") != -1 || lower.indexOf("<img") != -1 || lower.indexOf("<iframe") != -1;
        }
        return false;
    }

    private void validatePreferences(Map<String, Object> preferences) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : preferences.entrySet()) {
            boolean useDefaultValue;
            Object prefValueObject;
            String prefKey = entry.getKey();
            if (prefKey.equals("bidiEnabled")) {
                prefValueObject = entry.getValue();
                useDefaultValue = false;
                if (prefValueObject instanceof String) {
                    if (((String)prefValueObject).equals("true")) {
                        entry.setValue(true);
                    } else {
                        useDefaultValue = true;
                    }
                } else if (!(prefValueObject instanceof Boolean)) {
                    useDefaultValue = true;
                }
                if (!useDefaultValue) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Map perfereneces bidiEnabled to its default false value", (Object[])new Object[0]);
                }
                entry.setValue(false);
                continue;
            }
            if (prefKey.equals("bidiTextDirection")) {
                prefValueObject = entry.getValue();
                useDefaultValue = false;
                if (prefValueObject instanceof String) {
                    String prefValue = (String)prefValueObject;
                    if (!(prefValue.equals("ltr") || prefValue.equals("rtl") || prefValue.equals("contextual"))) {
                        useDefaultValue = true;
                    }
                } else {
                    useDefaultValue = true;
                }
                if (!useDefaultValue) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Map perfereneces bidiTextDirection to its default ltr value", (Object[])new Object[0]);
                }
                entry.setValue("ltr");
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The preferences entry '" + entry.getKey() + "' is invalid. Removing this entry from preferences."), (Object[])new Object[0]);
            }
            keysToRemove.add(entry.getKey());
        }
        for (String key : keysToRemove) {
            preferences.remove(key);
        }
    }

    @Override
    public synchronized Map<String, Object> updatePreferences(Map<String, Object> preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("updatePreferences requires a non-null map");
        }
        this.validatePreferences(preferences);
        Map<String, Object> oldPrefs = this.preferences;
        this.preferences = preferences;
        this.updateMetadataOnChange();
        this.storeToolbox();
        return oldPrefs;
    }

    @Trivial
    private synchronized void setToolEntries(List<ToolEntry> toolEntries) {
        this.toolEntries = toolEntries;
    }

    @Override
    @Trivial
    public synchronized List<ToolEntry> getToolEntries() {
        if (this.toolEntries == null) {
            return null;
        }
        ArrayList<ToolEntry> returnedList = new ArrayList<ToolEntry>();
        returnedList.addAll(this.toolEntries);
        return Collections.unmodifiableList(returnedList);
    }

    @Override
    public synchronized void updateToolEntries(List<ToolEntry> newToolEntries) throws IllegalArgumentException, NoSuchToolException {
        if (this.toolEntries == null || newToolEntries == null || this.toolEntries.size() != newToolEntries.size()) {
            throw new IllegalArgumentException(RequestNLS.formatMessage(tc, "TOOL_LIST_NOT_MATCH_TOOLBOX", newToolEntries != null ? newToolEntries.size() : 0, this.toolEntries != null ? this.toolEntries.size() : 0));
        }
        HashMap<ToolEntry, Integer> occurrencies = new HashMap<ToolEntry, Integer>();
        for (ToolEntry toolEntry : newToolEntries) {
            boolean found = this.toolEntries.contains(toolEntry);
            occurrencies.put(toolEntry, occurrencies.containsKey(toolEntry) ? (Integer)occurrencies.get(toolEntry) + 1 : 1);
            if (found) continue;
            throw new NoSuchToolException(RequestNLS.formatMessage(tc, "TOOL_NOT_FOUND_FROM_TOOLBOX", toolEntry.getId(), toolEntry.getType()));
        }
        for (Map.Entry entry : occurrencies.entrySet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ToolEntry: ", (Object[])new Object[]{entry.getKey() + ", occurences: " + entry.getValue()});
            }
            if ((Integer)entry.getValue() <= 1) continue;
            throw new IllegalArgumentException(RequestNLS.formatMessage(tc, "TOOL_LIST_DUPLICATE_TOOL", ((ToolEntry)entry.getKey()).getId()));
        }
        this.toolEntries = newToolEntries;
        this.updateMetadataOnChange();
        this.storeToolbox();
    }

    private synchronized void setBookmarks(List<Bookmark> bookmarks) {
        HashMap<String, Bookmark> newBookmarks = null;
        if (bookmarks != null) {
            newBookmarks = new HashMap<String, Bookmark>();
            for (Bookmark tool : bookmarks) {
                newBookmarks.put(tool.getId(), tool);
            }
        }
        this.bookmarks = newBookmarks;
    }

    @Override
    public synchronized List<Bookmark> getBookmarks() {
        if (this.bookmarks == null) {
            return null;
        }
        ArrayList<Bookmark> ret = new ArrayList<Bookmark>();
        ret.addAll(this.bookmarks.values());
        return Collections.unmodifiableList(ret);
    }

    @Override
    public synchronized ITool getToolEntry(String id) {
        ITool tool = this.bookmarks.get(id);
        if (tool != null) {
            return tool;
        }
        for (ToolEntry e : this.toolEntries) {
            if (!e.getId().equals(id)) continue;
            return this.catalog.getTool(id);
        }
        return null;
    }

    @Override
    public Bookmark getBookmark(String id) {
        return this.bookmarks.get(id);
    }

    private synchronized void updateMetadataOnChange() {
        this._metadata.put("lastModified", new Date().getTime());
        this._metadata.put("isDefault", false);
    }

    synchronized void storeToolbox() {
        try {
            this.persist.store(this.persistedName, this);
        }
        catch (JSONMarshallException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_PROMOTE_TOOL_JSON_DATA_CONTENT", (Object[])new Object[]{this.ownerId, e.getMessage()});
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"STORE_TOOLBOX_TO_PERSISTENCE_ERROR", (Object[])new Object[]{this.ownerId, e.getMessage()});
        }
    }

    @Override
    public synchronized ToolEntry addToolEntry(ToolEntry tool) throws NoSuchToolException, DuplicateException, InvalidToolException {
        ToolEntry toAdd = tool;
        try {
            toAdd.validateSelf();
        }
        catch (InvalidToolException e) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "TOOL_OBJECT_NOT_VALID_TOOLBOX", e.getMessage()));
        }
        for (ToolEntry toolEntry : this.toolEntries) {
            if (!toolEntry.getId().equals(toAdd.getId())) continue;
            throw new DuplicateException(RequestNLS.formatMessage(tc, "TOOL_ALREADY_EXIST_TOOLBOX", toAdd.getId()));
        }
        ITool catalogEntry = this.catalog.getTool(toAdd.getId());
        if (catalogEntry == null) {
            throw new NoSuchToolException(RequestNLS.formatMessage(tc, "TOOL_NOT_FOUND", toAdd.getId()));
        }
        if (!catalogEntry.getType().equals(toAdd.getType())) {
            throw new NoSuchToolException(RequestNLS.formatMessage(tc, "TOOL_AND_TYPE_NOT_FOUND", toAdd.getId(), toAdd.getType()));
        }
        this.toolEntries.add(toAdd);
        this.updateMetadataOnChange();
        this.storeToolbox();
        return toAdd;
    }

    @Override
    public synchronized Bookmark addBookmark(Bookmark tool) throws DuplicateException, InvalidToolException {
        Bookmark toAdd = tool;
        if (tool.getId() == null && tool.getType() == null) {
            toAdd = new Bookmark(tool.getName(), tool.getURL(), tool.getIcon(), tool.getDescription());
        }
        try {
            toAdd.validateSelf();
        }
        catch (InvalidToolException e) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "TOOL_OBJECT_NOT_VALID_TOOLBOX", e.getMessage()));
        }
        if (this.bookmarks.get(toAdd.getId()) != null) {
            throw new DuplicateException(RequestNLS.formatMessage(tc, "TOOL_ALREADY_EXIST_TOOLBOX", toAdd.getId()));
        }
        this.bookmarks.put(toAdd.getId(), toAdd);
        this.toolEntries.add(new ToolEntry(toAdd.getId(), toAdd.getType()));
        this.updateMetadataOnChange();
        this.storeToolbox();
        return toAdd;
    }

    @Override
    public synchronized void reset() {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(this.toString() + " reset request received. Resetting toolbox to initial state."), (Object[])new Object[0]);
        }
        this.initializeDefaultToolbox();
        this.storeToolbox();
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(this.toString() + " reset completed."), (Object[])new Object[0]);
        }
    }

    @Override
    public synchronized ITool deleteToolEntry(String id) {
        ToolEntry deletedTool = null;
        Iterator<ToolEntry> iterator = this.toolEntries.iterator();
        while (iterator.hasNext() && deletedTool == null) {
            ToolEntry tool = iterator.next();
            if (!tool.getId().equals(id)) continue;
            if ("bookmark".equals(tool.getType())) {
                this.bookmarks.remove(id);
            }
            deletedTool = tool;
            iterator.remove();
            this.updateMetadataOnChange();
            this.storeToolbox();
            break;
        }
        return deletedTool;
    }

    @Override
    public synchronized Bookmark deleteBookmark(String id) {
        Bookmark deletedBookmark = this.bookmarks.remove(id);
        if (deletedBookmark != null) {
            Iterator<ToolEntry> iterator = this.toolEntries.iterator();
            while (iterator.hasNext()) {
                ToolEntry tool = iterator.next();
                if (!tool.getId().equals(id)) continue;
                iterator.remove();
                this.updateMetadataOnChange();
                this.storeToolbox();
                break;
            }
        }
        return deletedBookmark;
    }

    private void checkCatalog(List<ToolEntry> toolsToBeRemoved, ToolEntry tool) {
        if (this.catalog.getTool(tool.getId()) == null) {
            Tr.warning((TraceComponent)tc, (String)"TOOLBOX_TOOL_NO_LONGER_AVAILABLE", (Object[])new Object[]{tool.getId(), this.ownerId});
            toolsToBeRemoved.add(tool);
        }
    }

    @Override
    public synchronized void validateSelf() throws InvalidToolboxException {
        if (this.ownerId == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The Toolbox is not considered valid because it is missing its required 'ownerId' field.", (Object[])new Object[0]);
            }
            throw new InvalidToolboxException("The Toolbox is not valid, the 'ownerId' field is null");
        }
        if (this.ownerDisplayName == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The Toolbox is not considered valid because it is missing its required 'ownerDisplayName' field.", (Object[])new Object[0]);
            }
            throw new InvalidToolboxException("The Toolbox is not valid, the 'ownerDisplayName' field is null");
        }
        if (this.toolEntries == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The Toolbox is not considered valid because it is missing its required 'toolEntries' field.", (Object[])new Object[0]);
            }
            throw new InvalidToolboxException("The Toolbox is not valid, the 'toolEntries' field is null");
        }
        if (this.bookmarks == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The Toolbox is not considered valid because it is missing its required 'bookmarks' field.", (Object[])new Object[0]);
            }
            throw new InvalidToolboxException("The Toolbox is not valid, the 'bookmarks' field is null");
        }
        if (this.preferences == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The Toolbox is not considered valid because it is missing its required 'preferences' field.", (Object[])new Object[0]);
            }
            throw new InvalidToolboxException("The Toolbox is not valid, the 'preferences' field is null");
        }
        if (this._metadata == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The Toolbox is not considered valid because it is missing its required '_metadata' field.", (Object[])new Object[0]);
            }
            throw new InvalidToolboxException("The Toolbox is not valid, the '_metadata' field is null");
        }
        if (!this._metadata.containsKey("lastModified")) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The Toolbox is not considered valid because it is missing its required metadata 'lastModified'.", (Object[])new Object[]{this._metadata});
            }
            throw new InvalidToolboxException("The Toolbox is not valid, the metadata 'lastModified' is not defined");
        }
        if (!this._metadata.containsKey("isDefault")) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The Toolbox is not considered valid because it is missing its required metadata 'isDefault'.", (Object[])new Object[]{this._metadata});
            }
            throw new InvalidToolboxException("The Toolbox is not valid, the metadata 'isDefault' is not defined");
        }
        this.validatePreferences(this.preferences);
        ArrayList<String> bookmarksToBeRemoved = new ArrayList<String>();
        for (Map.Entry<String, Bookmark> entry : this.bookmarks.entrySet()) {
            String key = entry.getKey();
            Bookmark url = entry.getValue();
            try {
                url.validateSelf();
                boolean found = false;
                for (ToolEntry tool : this.toolEntries) {
                    if (!tool.getId().equals(key)) continue;
                    found = true;
                }
                if (found) continue;
                bookmarksToBeRemoved.add(key);
            }
            catch (InvalidToolException e) {
                bookmarksToBeRemoved.add(key);
            }
        }
        for (String key : bookmarksToBeRemoved) {
            this.bookmarks.remove(key);
        }
        ArrayList<ToolEntry> toolsToBeRemoved = new ArrayList<ToolEntry>();
        for (ToolEntry tool : this.toolEntries) {
            try {
                tool.validateSelf();
                if (bookmarksToBeRemoved.contains(tool.getId())) {
                    toolsToBeRemoved.add(tool);
                    continue;
                }
                if ("bookmark".equalsIgnoreCase(tool.getType())) {
                    if (this.bookmarks.get(tool.getId()) != null) continue;
                    this.checkCatalog(toolsToBeRemoved, tool);
                    continue;
                }
                this.checkCatalog(toolsToBeRemoved, tool);
            }
            catch (InvalidToolException invalidToolException) {
                Tr.warning((TraceComponent)tc, (String)"INVALID_TOOL_CONTENT_WARNING_TOOLBOX", (Object[])new Object[]{tool.getId(), this.ownerId, invalidToolException.getMessage()});
                toolsToBeRemoved.add(tool);
            }
        }
        if (toolsToBeRemoved.size() > 0) {
            this.toolEntries.removeAll(toolsToBeRemoved);
        }
        if (toolsToBeRemoved.size() > 0 || bookmarksToBeRemoved.size() > 0) {
            this.updateMetadataOnChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean equalsMetadata(Toolbox that) {
        Toolbox toolbox = this;
        synchronized (toolbox) {
            Toolbox toolbox2 = that;
            synchronized (toolbox2) {
                if (this._metadata == that._metadata) {
                    return true;
                }
                boolean matches = true;
                if (this._metadata != null && that._metadata != null) {
                    for (Map.Entry<String, Object> thisEntry : this._metadata.entrySet()) {
                        String key = thisEntry.getKey();
                        Object value = thisEntry.getValue();
                        if (value == null && that._metadata.get(key) != null) {
                            return false;
                        }
                        if (key.equals("lastModified")) continue;
                        matches &= that._metadata.get(key).equals(value);
                    }
                }
                return matches;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Toolbox) {
            Toolbox that = (Toolbox)o;
            Toolbox toolbox = this;
            synchronized (toolbox) {
                Toolbox toolbox2 = that;
                synchronized (toolbox2) {
                    boolean sameFields = true;
                    sameFields &= this.ownerId == that.ownerId || this.ownerId != null && this.ownerId.equals(that.ownerId);
                    sameFields &= this.ownerDisplayName == that.ownerDisplayName || this.ownerDisplayName != null && this.ownerDisplayName.equals(that.ownerDisplayName);
                    sameFields &= this.preferences == that.preferences || this.preferences != null && this.preferences.equals(that.preferences);
                    sameFields &= this.toolEntries == that.toolEntries || this.toolEntries != null && this.toolEntries.equals(that.toolEntries);
                    boolean bl = (sameFields &= this.bookmarks == that.bookmarks || this.bookmarks != null && this.bookmarks.equals(that.bookmarks)) && this.equalsMetadata(that);
                    return bl;
                }
            }
        }
        return false;
    }

    public synchronized int hashCode() {
        return this.toolEntries == null ? 0 : this.toolEntries.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Toolbox");
        if (this.ownerId != null) {
            sb.append('(');
            sb.append(this.ownerId);
            sb.append(')');
        }
        return sb.toString();
    }
}

