/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.webapp;

import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIOutput;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.webapp.FacetTag;
import jakarta.faces.webapp.UIComponentTagBase;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.jstl.core.LoopTag;
import jakarta.servlet.jsp.tagext.BodyContent;
import jakarta.servlet.jsp.tagext.BodyTag;
import jakarta.servlet.jsp.tagext.JspIdConsumer;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public abstract class UIComponentClassicTagBase
extends UIComponentTagBase
implements BodyTag,
JspIdConsumer {
    private static final String COMPONENT_STACK_ATTR = "org.apache.myfaces.COMPONENT_STACK";
    private static final String REQUEST_FACES_CONTEXT = "org.apache.myfaces.REQUEST_FACES_CONTEXT";
    private static final String VIEW_IDS = "org.apache.myfaces.VIEW_IDS";
    private static final String FORMER_CHILD_IDS_SET_ATTR = "org.apache.myfaces.FORMER_CHILD_IDS";
    private static final String FORMER_FACET_NAMES_SET_ATTR = "org.apache.myfaces.FORMER_FACET_NAMES";
    private static final String PREVIOUS_JSP_IDS_SET = "org.apache.myfaces.PREVIOUS_JSP_IDS_SET";
    private static final String BOUND_VIEW_ROOT = "org.apache.myfaces.BOUND_VIEW_ROOT";
    private static final String LOGICAL_PAGE_ID = "org.apache.myfaces.LOGICAL_PAGE_ID";
    private static final String LOGICAL_PAGE_COUNTER = "org.apache.myfaces.LOGICAL_PAGE_COUNTER";
    protected static final String UNIQUE_ID_PREFIX = "j_id_";
    protected PageContext pageContext = null;
    protected BodyContent bodyContent = null;
    private boolean _created = false;
    private String _jspId = null;
    private String _facesJspId = null;
    private List<String> _childrenAdded = null;
    private List<String> _facetsAdded = null;
    private UIComponent _componentInstance = null;
    private String _id = null;
    private boolean isInAnIterator;
    private Tag _parent = null;
    private UIComponentClassicTagBase _parentClassicTag = null;
    private FacesContext _facesContext = null;

    protected abstract void setProperties(UIComponent var1);

    protected abstract UIComponent createComponent(FacesContext var1, String var2) throws JspException;

    public void release() {
        this.internalRelease();
        this.pageContext = null;
        this._parent = null;
        this._jspId = null;
        this._id = null;
        this._facesJspId = null;
        this.bodyContent = null;
    }

    private void internalRelease() {
        this._facesContext = null;
        this._componentInstance = null;
        this._created = false;
        this._childrenAdded = null;
        this._facetsAdded = null;
    }

    @Override
    public boolean getCreated() {
        return this._created;
    }

    protected List<String> getCreatedComponents() {
        return this._childrenAdded;
    }

    public static UIComponentClassicTagBase getParentUIComponentClassicTagBase(PageContext pageContext) {
        Stack<UIComponentClassicTagBase> stack = UIComponentClassicTagBase.getStack(pageContext);
        int size = stack.size();
        return size > 0 ? (UIComponentClassicTagBase)stack.get(size - 1) : null;
    }

    public String getJspId() {
        return this._jspId;
    }

    public void setJspId(String jspId) {
        Integer logicalPageId = (Integer)this.pageContext.getAttribute(LOGICAL_PAGE_ID);
        if (logicalPageId != null) {
            this._jspId = logicalPageId == 1 ? jspId : jspId + "pc" + logicalPageId;
        } else {
            Map<Object, Object> attributeMap = this.getFacesContext().getAttributes();
            AtomicInteger logicalPageCounter = (AtomicInteger)attributeMap.get(LOGICAL_PAGE_COUNTER);
            if (logicalPageCounter == null) {
                logicalPageCounter = new AtomicInteger(1);
                logicalPageId = 1;
                attributeMap.put(LOGICAL_PAGE_COUNTER, logicalPageCounter);
                this.pageContext.setAttribute(LOGICAL_PAGE_ID, (Object)logicalPageId);
            } else {
                logicalPageId = logicalPageCounter.incrementAndGet();
                this.pageContext.setAttribute(LOGICAL_PAGE_ID, (Object)logicalPageId);
                this._jspId = jspId + "pc" + logicalPageId;
            }
        }
        this._facesJspId = null;
        this.checkIfItIsInAnIterator(this._jspId);
    }

    @Override
    protected void addChild(UIComponent child) {
        if (this._childrenAdded == null) {
            this._childrenAdded = new ArrayList<String>();
        }
        this._childrenAdded.add(child.getId());
    }

    @Override
    protected void addFacet(String name) {
        if (this._facetsAdded == null) {
            this._facetsAdded = new ArrayList<String>();
        }
        this._facetsAdded.add(name);
    }

    @Override
    public UIComponent getComponentInstance() {
        return this._componentInstance;
    }

    @Override
    protected FacesContext getFacesContext() {
        if (this._facesContext != null) {
            return this._facesContext;
        }
        FacesContext facesContext = this._facesContext = this.pageContext == null ? null : (FacesContext)this.pageContext.getAttribute(REQUEST_FACES_CONTEXT);
        if (this._facesContext != null) {
            return this._facesContext;
        }
        this._facesContext = FacesContext.getCurrentInstance();
        if (this._facesContext != null) {
            if (this.pageContext != null) {
                this.pageContext.setAttribute(REQUEST_FACES_CONTEXT, (Object)this._facesContext);
            }
            return this._facesContext;
        }
        throw new RuntimeException("FacesContext not found");
    }

    @Override
    protected int getIndexOfNextChildTag() {
        if (this._childrenAdded == null) {
            return 0;
        }
        return this._childrenAdded.size();
    }

    @Override
    public void setId(String id) {
        if (id != null && id.startsWith("j_id")) {
            throw new IllegalArgumentException("Id is non-null and starts with UIViewRoot.UNIQUE_ID_PREFIX: " + id);
        }
        this._id = id;
    }

    protected String getId() {
        return this._id;
    }

    protected String getFacesJspId() {
        if (this._facesJspId == null) {
            if (this._jspId != null) {
                this._facesJspId = UNIQUE_ID_PREFIX + this._jspId;
                if (this.isIdDuplicated(this._facesJspId)) {
                    this._facesJspId = this.createNextId(this._facesJspId);
                }
            } else {
                this._facesJspId = this._facesContext.getViewRoot().createUniqueId();
            }
        }
        return this._facesJspId;
    }

    public void setBodyContent(BodyContent bodyContent) {
        this.bodyContent = bodyContent;
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        UIComponent verbatimComp;
        UIComponentClassicTagBase parentTag = UIComponentClassicTagBase.getParentUIComponentClassicTagBase(this.pageContext);
        if ((this.isRootTag(parentTag) || this.isInRenderedChildrenComponent(parentTag)) && (verbatimComp = this.createVerbatimComponentFromBodyContent()) != null) {
            List childrenAddedIds = (List)this._componentInstance.getAttributes().get(FORMER_CHILD_IDS_SET_ATTR);
            if (childrenAddedIds == null) {
                this._componentInstance.getChildren().add(verbatimComp);
            } else {
                int index = this._componentInstance.getChildCount();
                if (childrenAddedIds.size() == index) {
                    this._componentInstance.getChildren().add(index - 1, verbatimComp);
                } else {
                    this._componentInstance.getChildren().add(verbatimComp);
                }
            }
            if (parentTag != null) {
                parentTag.addChild(verbatimComp);
            }
        }
        return this.getDoAfterBodyValue();
    }

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public Tag getParent() {
        return this._parent;
    }

    public void setParent(Tag tag) {
        this._parent = tag;
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public int doStartTag() throws JspException {
        this._facesContext = this.getFacesContext();
        if (this._facesContext == null) {
            throw new JspException("FacesContext not found");
        }
        this._childrenAdded = null;
        this._facetsAdded = null;
        this._parentClassicTag = UIComponentClassicTagBase.getParentUIComponentClassicTagBase(this.pageContext);
        UIComponent verbatimComp = null;
        if (!this.isFacet()) {
            JspWriter outWriter;
            boolean insideJspTag;
            Tag parent = this.getParent();
            if (parent != null && parent instanceof LoopTag && !(insideJspTag = (outWriter = this.pageContext.getOut()) instanceof BodyContent)) {
                try {
                    outWriter.flush();
                }
                catch (IOException e) {
                    throw new JspException("Exception flushing when creating verbatim _componentInstance", (Throwable)e);
                }
            }
            if (this._parentClassicTag != null) {
                verbatimComp = this._parentClassicTag.createVerbatimComponentFromBodyContent();
            }
        }
        this._componentInstance = this.findComponent(this._facesContext);
        if (verbatimComp != null && this._parentClassicTag != null) {
            this.addVerbatimBeforeComponent(this._parentClassicTag, verbatimComp, this._componentInstance);
        }
        Map<String, Object> viewComponentIds = this.getViewComponentIds();
        UIComponentClassicTagBase tagInstance = null;
        String clientId = null;
        if (this._id != null) {
            clientId = this._componentInstance.getClientId(this._facesContext);
            UIComponentClassicTagBase uIComponentClassicTagBase = tagInstance = viewComponentIds.get(clientId) == this ? this : null;
        }
        if (tagInstance == null) {
            if (this._id != null && clientId != null) {
                if (viewComponentIds.containsKey(clientId)) {
                    throw new JspException("Duplicated component Id: '" + clientId + "' for component: '" + this.getPathToComponent(this._componentInstance) + "'.");
                }
                viewComponentIds.put(clientId, this);
            }
            if (this._parentClassicTag != null) {
                if (this.isFacet()) {
                    this._parentClassicTag.addFacet(this.getFacetName());
                } else {
                    this._parentClassicTag.addChild(this._componentInstance);
                }
            }
        }
        this.pushTag();
        return this.getDoStartValue();
    }

    public int doEndTag() throws JspException {
        this.popTag();
        UIComponent component = this.getComponentInstance();
        this.removeFormerChildren(component);
        this.removeFormerFacets(component);
        try {
            UIComponentClassicTagBase parentTag = UIComponentClassicTagBase.getParentUIComponentClassicTagBase(this.pageContext);
            UIComponent verbatimComp = this.createVerbatimComponentFromBodyContent();
            if (verbatimComp != null) {
                component.getChildren().add(verbatimComp);
                if (parentTag != null) {
                    parentTag.addChild(verbatimComp);
                }
            }
        }
        catch (Throwable e) {
            throw new JspException(e);
        }
        finally {
            component = null;
        }
        int retValue = this.getDoEndValue();
        this.internalRelease();
        return retValue;
    }

    protected int getDoAfterBodyValue() throws JspException {
        return 0;
    }

    protected int getDoStartValue() throws JspException {
        return 2;
    }

    protected int getDoEndValue() throws JspException {
        return 6;
    }

    protected String getFacetName() {
        return this.isFacet() ? ((FacetTag)this._parent).getName() : null;
    }

    protected UIComponent createVerbatimComponentFromBodyContent() {
        UIOutput verbatimComp = null;
        if (this.bodyContent != null) {
            String trimmedContent;
            String strContent = this.bodyContent.getString();
            if (strContent != null && (trimmedContent = strContent.trim()).length() > 0 && !UIComponentClassicTagBase.isComment(strContent)) {
                verbatimComp = this.createVerbatimComponent();
                verbatimComp.setValue(strContent);
            }
            this.bodyContent.clearBody();
        }
        return verbatimComp;
    }

    private static boolean isComment(String bodyContent) {
        return bodyContent.startsWith("<!--") && bodyContent.endsWith("-->");
    }

    protected UIOutput createVerbatimComponent() {
        UIOutput verbatimComp = (UIOutput)this.getFacesContext().getApplication().createComponent("jakarta.faces.HtmlOutputText");
        verbatimComp.setTransient(true);
        verbatimComp.getAttributes().put("escape", Boolean.FALSE);
        verbatimComp.setId(this.getFacesContext().getViewRoot().createUniqueId());
        return verbatimComp;
    }

    protected void addVerbatimBeforeComponent(UIComponentClassicTagBase parentTag, UIComponent verbatimComp, UIComponent component) {
        UIComponent formerVerbatim;
        UIComponent parent = component.getParent();
        if (parent == null) {
            return;
        }
        List<UIComponent> children = parent.getChildren();
        List childrenAddedIds = (List)parent.getAttributes().get(FORMER_CHILD_IDS_SET_ATTR);
        int parentIndex = children.indexOf(component);
        if (childrenAddedIds != null && parentIndex > 0 && childrenAddedIds.size() == parentIndex && (formerVerbatim = children.get(parentIndex - 1)) instanceof UIOutput && formerVerbatim.isTransient()) {
            children.set(parentIndex - 1, verbatimComp);
        }
        children.add(parentIndex, verbatimComp);
        parentTag.addChild(verbatimComp);
    }

    protected void addVerbatimAfterComponent(UIComponentClassicTagBase parentTag, UIComponent verbatim, UIComponent component) {
        int indexOfComponentInParent = 0;
        UIComponent parent = component.getParent();
        if (null == parent) {
            return;
        }
        List<UIComponent> children = parent.getChildren();
        indexOfComponentInParent = children.indexOf(component);
        if (children.size() - 1 == indexOfComponentInParent) {
            children.add(verbatim);
        } else {
            children.add(indexOfComponentInParent + 1, verbatim);
        }
        parentTag.addChild(verbatim);
    }

    @Deprecated
    protected void setupResponseWriter() {
    }

    @Deprecated
    protected void encodeBegin() throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Entered encodeBegin for client-Id: " + this._componentInstance.getClientId(this.getFacesContext()));
        }
        this._componentInstance.encodeBegin(this.getFacesContext());
        if (log.isLoggable(Level.FINE)) {
            log.fine("Exited encodeBegin");
        }
    }

    @Deprecated
    protected void encodeChildren() throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Entered encodeChildren for client-Id: " + this._componentInstance.getClientId(this.getFacesContext()));
        }
        this._componentInstance.encodeChildren(this.getFacesContext());
        if (log.isLoggable(Level.FINE)) {
            log.fine("Exited encodeChildren for client-Id: " + this._componentInstance.getClientId(this.getFacesContext()));
        }
    }

    @Deprecated
    protected void encodeEnd() throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Entered encodeEnd for client-Id: " + this._componentInstance.getClientId(this.getFacesContext()));
        }
        this._componentInstance.encodeEnd(this.getFacesContext());
        if (log.isLoggable(Level.FINE)) {
            log.fine("Exited encodeEnd for client-Id: " + this._componentInstance.getClientId(this.getFacesContext()));
        }
    }

    private boolean isRootTag(UIComponentClassicTagBase parentTag) {
        return parentTag == this;
    }

    private boolean isInRenderedChildrenComponent(UIComponentClassicTagBase tag) {
        return this._parentClassicTag != null && tag.getComponentInstance().getRendersChildren();
    }

    private boolean isFacet() {
        return this._parent != null && this._parent instanceof FacetTag;
    }

    private Map<String, Object> getViewComponentIds() {
        Map viewComponentIds;
        Map<Object, Object> attributes = this._facesContext.getAttributes();
        if (this._parent == null) {
            viewComponentIds = new HashMap();
            attributes.put(VIEW_IDS, viewComponentIds);
        } else {
            viewComponentIds = (Map)attributes.get(VIEW_IDS);
            if (viewComponentIds == null) {
                viewComponentIds = new HashMap();
                attributes.put(VIEW_IDS, viewComponentIds);
            }
        }
        return viewComponentIds;
    }

    private static final Stack<UIComponentClassicTagBase> getStack(PageContext pageContext) {
        Stack stack = (Stack)pageContext.getAttribute(COMPONENT_STACK_ATTR, 2);
        if (stack == null) {
            stack = new Stack();
            pageContext.setAttribute(COMPONENT_STACK_ATTR, stack, 2);
        }
        return stack;
    }

    private void popTag() {
        Stack<UIComponentClassicTagBase> stack = UIComponentClassicTagBase.getStack(this.pageContext);
        int size = stack.size();
        stack.remove(size - 1);
        if (size <= 1) {
            this.pageContext.removeAttribute(COMPONENT_STACK_ATTR, 2);
        }
    }

    private void pushTag() {
        UIComponentClassicTagBase.getStack(this.pageContext).add(this);
    }

    private String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        UIComponentClassicTagBase.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf);
        UIComponentClassicTagBase.getPathToComponent(component.getParent(), buf);
    }

    private void removeFormerChildren(UIComponent component) {
        List formerChildIds = (List)component.getAttributes().get(FORMER_CHILD_IDS_SET_ATTR);
        if (formerChildIds != null) {
            for (String childId : formerChildIds) {
                UIComponent childToRemove;
                if (this._childrenAdded != null && this._childrenAdded.contains(childId) || (childToRemove = component.findComponent(childId)) == null) continue;
                component.getChildren().remove(childToRemove);
            }
            if (this._childrenAdded == null) {
                component.getAttributes().remove(FORMER_CHILD_IDS_SET_ATTR);
            } else {
                component.getAttributes().put(FORMER_CHILD_IDS_SET_ATTR, this._childrenAdded);
            }
        } else if (this._childrenAdded != null) {
            component.getAttributes().put(FORMER_CHILD_IDS_SET_ATTR, this._childrenAdded);
        }
    }

    private void removeFormerFacets(UIComponent component) {
        List formerFacetNames = (List)component.getAttributes().get(FORMER_FACET_NAMES_SET_ATTR);
        if (formerFacetNames != null) {
            for (String facetName : formerFacetNames) {
                if (this._facetsAdded != null && this._facetsAdded.contains(facetName)) continue;
                component.getFacets().remove(facetName);
            }
            if (this._facetsAdded == null) {
                component.getAttributes().remove(FORMER_FACET_NAMES_SET_ATTR);
            } else {
                component.getAttributes().put(FORMER_FACET_NAMES_SET_ATTR, this._facetsAdded);
            }
        } else if (this._facetsAdded != null) {
            component.getAttributes().put(FORMER_FACET_NAMES_SET_ATTR, this._facetsAdded);
        }
    }

    protected UIComponent findComponent(FacesContext context) throws JspException {
        if (this._componentInstance != null) {
            return this._componentInstance;
        }
        UIComponentClassicTagBase parentTag = UIComponentClassicTagBase.getParentUIComponentClassicTagBase(this.pageContext);
        if (parentTag == null) {
            this._componentInstance = context.getViewRoot();
            Object alreadyBoundViewRootFlag = this._componentInstance.getAttributes().get(BOUND_VIEW_ROOT);
            if (alreadyBoundViewRootFlag == null) {
                try {
                    this.setProperties(this._componentInstance);
                }
                catch (Throwable e) {
                    throw new JspException(e);
                }
                if (this._id != null) {
                    this._componentInstance.setId(this._id);
                } else {
                    this._componentInstance.setId(this.getFacesJspId());
                }
                this._componentInstance.getAttributes().put(BOUND_VIEW_ROOT, true);
                this._created = true;
            } else if (this.hasBinding()) {
                this.setProperties(this._componentInstance);
            }
            return this._componentInstance;
        }
        UIComponent parent = parentTag.getComponentInstance();
        if (parent == null) {
            throw new IllegalStateException("parent is null?");
        }
        String facetName = this.getFacetName();
        if (facetName != null) {
            String id = this.createUniqueId(context, parent);
            this._componentInstance = parent.getFacet(facetName);
            if (this._componentInstance == null) {
                this._componentInstance = this.createComponent(context, id);
                this._created = true;
                parent.getFacets().put(facetName, this._componentInstance);
            } else if (this.checkFacetNameOnParentExists(parentTag, facetName)) {
                throw new IllegalStateException("facet '" + facetName + "' already has a child associated. current associated _componentInstance id: " + this._componentInstance.getClientId(context) + " class: " + this._componentInstance.getClass().getName());
            }
            this.addFacetNameToParentTag(parentTag, facetName);
            return this._componentInstance;
        }
        String id = this.createUniqueId(context, parent);
        if (parentTag._childrenAdded != null && parentTag._childrenAdded.contains(id) && log.isLoggable(Level.WARNING)) {
            log.warning("There is more than one JSF tag with an id : " + id);
        }
        this._componentInstance = this.findComponent(parent, id);
        if (this._componentInstance == null) {
            this._componentInstance = this.createComponent(context, id);
            if (id.equals(this._componentInstance.getId())) {
                this._created = true;
                int index = parentTag.getIndexOfNextChildTag();
                if (index > parent.getChildCount()) {
                    index = parent.getChildCount();
                }
                List<UIComponent> children = parent.getChildren();
                children.add(index, this._componentInstance);
            } else if (null == this.findComponent(parent, this._componentInstance.getId())) {
                this._created = true;
                int index = parentTag.getIndexOfNextChildTag();
                if (index > parent.getChildCount()) {
                    index = parent.getChildCount();
                }
                List<UIComponent> children = parent.getChildren();
                children.add(index, this._componentInstance);
            }
        }
        return this._componentInstance;
    }

    private UIComponent findComponent(UIComponent parent, String id) {
        for (UIComponent child : parent.getChildren()) {
            if (child.getId() == null || !child.getId().equals(id)) continue;
            return child;
        }
        return null;
    }

    private String createUniqueId(FacesContext context, UIComponent parent) throws JspException {
        String id = this.getId();
        if (id == null) {
            id = this.getFacesJspId();
        } else if (this.isIdDuplicated(id)) {
            if (this.isInAnIterator) {
                this.setId(this.createNextId(id));
                id = this.getId();
            } else {
                UIComponent component;
                UIComponent namingContainer;
                if (parent != null && (namingContainer = parent instanceof NamingContainer ? parent : parent.getParent()) != null && ((component = namingContainer.findComponent(id)) == null || this.isPostBack(context))) {
                    return id;
                }
                throw new JspException("Duplicated Id found in the view: " + id);
            }
        }
        return id;
    }

    private String createNextId(String componentId) {
        Integer currentCounter = (Integer)this.getFacesContext().getAttributes().get(componentId);
        int iCurrentCounter = 1;
        if (currentCounter != null) {
            iCurrentCounter = currentCounter;
            ++iCurrentCounter;
        }
        this.getFacesContext().getAttributes().put(componentId, iCurrentCounter);
        componentId = componentId + UNIQUE_ID_PREFIX + iCurrentCounter;
        return componentId;
    }

    private void checkIfItIsInAnIterator(String jspId) {
        Set<String> previousJspIdsSet = this.getPreviousJspIdsSet();
        if (previousJspIdsSet.contains(jspId)) {
            this.isInAnIterator = true;
        } else {
            previousJspIdsSet.add(jspId);
            this.isInAnIterator = false;
        }
    }

    private Set<String> getPreviousJspIdsSet() {
        HashSet previousJspIdsSet = (HashSet)this.getFacesContext().getAttributes().get(PREVIOUS_JSP_IDS_SET);
        if (previousJspIdsSet == null) {
            previousJspIdsSet = new HashSet();
            this.getFacesContext().getAttributes().put(PREVIOUS_JSP_IDS_SET, previousJspIdsSet);
        }
        return previousJspIdsSet;
    }

    private boolean isIdDuplicated(String componentId) {
        boolean result = false;
        if (this._parentClassicTag != null) {
            if (this._parentClassicTag.isInAnIterator) {
                return true;
            }
            List<String> childComponents = this._parentClassicTag.getCreatedComponents();
            if (childComponents != null && (result = childComponents.contains(componentId)) && !this.isInAnIterator) {
                return true;
            }
        }
        return result;
    }

    private boolean isPostBack(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestParameterMap().containsKey("jakarta.faces.ViewState");
    }

    private boolean checkFacetNameOnParentExists(UIComponentClassicTagBase parentTag, String facetName) {
        return parentTag._facetsAdded != null && parentTag._facetsAdded.contains(facetName);
    }

    private void addFacetNameToParentTag(UIComponentClassicTagBase parentTag, String facetName) {
        if (parentTag._facetsAdded == null) {
            parentTag._facetsAdded = new ArrayList<String>();
        }
        parentTag._facetsAdded.add(facetName);
    }

    protected abstract boolean hasBinding();

    public JspWriter getPreviousOut() {
        return this.bodyContent.getEnclosingWriter();
    }
}

