/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.certificate.creator.acme;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.crypto.certificateutil.DefaultSSLCertificateCreator;
import com.ibm.ws.security.acme.AcmeProvider;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class AcmeSSLCertificateCreator
implements DefaultSSLCertificateCreator {
    private static final TraceComponent tc = Tr.register(AcmeSSLCertificateCreator.class);
    private static final AtomicReference<AcmeProvider> acmeProviderRef = new AtomicReference();

    public File createDefaultSSLCertificate(String filePath, @Sensitive String password, String keyStoreType, String keyStoreProvider, int validity, String subjectDN, int keySize, String sigAlg, List<String> extInfo) throws CertificateException {
        return this.getAcmeProvider().createDefaultSSLCertificate(filePath, password, keyStoreType, keyStoreProvider);
    }

    public void updateDefaultSSLCertificate(KeyStore keyStore, File keyStoreFile, @Sensitive String password) throws CertificateException {
        this.getAcmeProvider().updateDefaultSSLCertificate(keyStore, keyStoreFile, password);
    }

    public String getType() {
        return "ACME";
    }

    @Trivial
    private AcmeProvider getAcmeProvider() throws CertificateException {
        if (acmeProviderRef.get() == null) {
            throw new CertificateException("Internal error. AcmeProvider was not registered.");
        }
        return acmeProviderRef.get();
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC)
    protected void setAcmeProvider(AcmeProvider acmeProvider) {
        acmeProviderRef.set(acmeProvider);
    }

    protected void unsetAcmeProvider(AcmeProvider acmeProvider) {
        acmeProviderRef.compareAndSet(acmeProvider, null);
    }
}

