/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1Choice;
import com.ibm.ws.transport.iiop.asn1.ASN1Encodable;
import com.ibm.ws.transport.iiop.asn1.ASN1OctetString;
import com.ibm.ws.transport.iiop.asn1.ASN1Sequence;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DEREncodable;
import com.ibm.ws.transport.iiop.asn1.DERIA5String;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DERObjectIdentifier;
import com.ibm.ws.transport.iiop.asn1.DERTaggedObject;
import com.ibm.ws.transport.iiop.asn1.x509.X509Name;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class GeneralName
extends ASN1Encodable
implements ASN1Choice {
    public static final int otherName = 0;
    public static final int rfc822Name = 1;
    public static final int dNSName = 2;
    public static final int x400Address = 3;
    public static final int directoryName = 4;
    public static final int ediPartyName = 5;
    public static final int uniformResourceIdentifier = 6;
    public static final int iPAddress = 7;
    public static final int registeredID = 8;
    DEREncodable obj;
    int tag;
    static final long serialVersionUID = 588131617663808472L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public GeneralName(X509Name dirName) {
        this.obj = dirName;
        this.tag = 4;
    }

    public GeneralName(DERObject name, int tag) {
        this.obj = name;
        this.tag = tag;
    }

    public GeneralName(int tag, ASN1Encodable name) {
        this.obj = name;
        this.tag = tag;
    }

    public GeneralName(int tag, String name) {
        if (tag == 1 || tag == 2 || tag == 6) {
            this.tag = tag;
            this.obj = new DERIA5String(name);
        } else if (tag == 8) {
            this.tag = tag;
            this.obj = new DERObjectIdentifier(name);
        } else {
            throw new IllegalArgumentException("can't process String for tag: " + tag);
        }
    }

    public static GeneralName getInstance(Object obj) {
        if (obj == null || obj instanceof GeneralName) {
            return (GeneralName)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)obj;
            int tag = tagObj.getTagNo();
            switch (tag) {
                case 0: {
                    return new GeneralName(ASN1Sequence.getInstance(tagObj, false), tag);
                }
                case 1: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 2: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 3: {
                    throw new IllegalArgumentException("unknown tag: " + tag);
                }
                case 4: {
                    return new GeneralName(ASN1Sequence.getInstance(tagObj, true), tag);
                }
                case 5: {
                    return new GeneralName(ASN1Sequence.getInstance(tagObj, false), tag);
                }
                case 6: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 7: {
                    return new GeneralName(ASN1OctetString.getInstance(tagObj, false), tag);
                }
                case 8: {
                    return new GeneralName(DERObjectIdentifier.getInstance(tagObj, false), tag);
                }
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static GeneralName getInstance(ASN1TaggedObject tagObj, boolean explicit) {
        return GeneralName.getInstance(ASN1TaggedObject.getInstance(tagObj, true));
    }

    public int getTagNo() {
        return this.tag;
    }

    public DEREncodable getName() {
        return this.obj;
    }

    @Override
    public DERObject toASN1Object() {
        if (this.tag == 4) {
            return new DERTaggedObject(true, this.tag, this.obj);
        }
        return new DERTaggedObject(false, this.tag, this.obj);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.asn1.x509.GeneralName", GeneralName.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    }
}

