/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.v32.cdi.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.JPAAccessor;
import com.ibm.ws.jpa.JPAComponent;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.persistence.Cache;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.SchemaManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.transaction.TransactionScoped;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JPACDIExtension
implements Extension {
    private static final TraceComponent tc = Tr.register(JPACDIExtension.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private final JPAComponent jpaComponent = JPAAccessor.getJPAComponent();
    static final long serialVersionUID = 3299830894892150132L;

    /*
     * WARNING - void declaration
     */
    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        J2EEName j2EEName = this.getCurrentAppJ2EEName();
        List persistenceUnits = this.jpaComponent.getPersistenceUnits(j2EEName);
        for (PersistenceUnitInfo pui : persistenceUnits) {
            try {
                this.createBeanForPersistenceUnit(abd, pui, j2EEName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                void e;
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jpa.container.v32.cdi.internal.JPACDIExtension", (String)"60", (Object)this, (Object[])new Object[]{abd, bm});
                Tr.warning((TraceComponent)tc, (String)"FAILED_TO_CREATE_PU_BEAN_CWWJP9994W", (Object[])new Object[]{pui.getPersistenceUnitName(), e});
            }
        }
    }

    private void createBeanForPersistenceUnit(AfterBeanDiscovery abd, PersistenceUnitInfo pui, J2EEName j2eeName) throws ClassNotFoundException {
        Set<Annotation> qualifiers = this.getQualifiers(pui);
        Class<? extends Annotation> scopeForEntityManager = this.getScope(pui, TransactionScoped.class);
        Class<ApplicationScoped> scopeForEntityManagerFactory = ApplicationScoped.class;
        Class<Dependent> scopeForOthers = Dependent.class;
        abd.addBean().types(new Type[]{EntityManager.class}).addQualifiers(qualifiers).scope(scopeForEntityManager).produceWith(instance -> this.jpaComponent.getEntityManager(j2eeName, pui));
        abd.addBean().types(new Type[]{EntityManagerFactory.class}).addQualifiers(qualifiers).scope(scopeForEntityManagerFactory).produceWith(instance -> this.jpaComponent.getEntityManagerFactory(j2eeName, pui));
        abd.addBean().types(new Type[]{PersistenceUnitUtil.class}).addQualifiers(qualifiers).scope(scopeForOthers).produceWith(instance -> this.jpaComponent.getEntityManagerFactory(j2eeName, pui).getPersistenceUnitUtil());
        abd.addBean().types(new Type[]{CriteriaBuilder.class}).addQualifiers(qualifiers).scope(scopeForOthers).produceWith(instance -> this.jpaComponent.getEntityManagerFactory(j2eeName, pui).getCriteriaBuilder());
        abd.addBean().types(new Type[]{Cache.class}).addQualifiers(qualifiers).scope(scopeForOthers).produceWith(instance -> this.jpaComponent.getEntityManagerFactory(j2eeName, pui).getCache());
        abd.addBean().types(new Type[]{Metamodel.class}).addQualifiers(qualifiers).scope(scopeForOthers).produceWith(instance -> this.jpaComponent.getEntityManagerFactory(j2eeName, pui).getMetamodel());
        abd.addBean().types(new Type[]{SchemaManager.class}).addQualifiers(qualifiers).scope(scopeForOthers).produceWith(instance -> this.jpaComponent.getEntityManagerFactory(j2eeName, pui).getSchemaManager());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String qualifiersString = qualifiers.stream().map(Annotation::annotationType).map(Class::getName).collect(Collectors.joining(", "));
            Tr.debug((TraceComponent)tc, (String)("Creating beans for a persistence unit (and related) with scope " + scopeForEntityManager + " and qualifiers: " + qualifiersString), (Object[])new Object[0]);
        }
    }

    private J2EEName getCurrentAppJ2EEName() {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cmd != null) {
            J2EEName j2eeName = cmd.getJ2EEName();
            return new AppOnlyJ2EEName(j2eeName.getApplication());
        }
        return null;
    }

    private Class<? extends Annotation> getScope(PersistenceUnitInfo pui, Class<? extends Annotation> defaultScope) throws ClassNotFoundException {
        String scopeName = pui.getScopeAnnotationName();
        Class<? extends Annotation> scope = scopeName == null || scopeName.equals("") ? defaultScope : Class.forName(scopeName, false, pui.getClassLoader()).asSubclass(Annotation.class);
        return scope;
    }

    private Set<Annotation> getQualifiers(PersistenceUnitInfo pui) throws ClassNotFoundException {
        List qualifierNames = pui.getQualifierAnnotationNames();
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (String qualifierName : qualifierNames) {
            final Class<Annotation> qualifierClass = Class.forName(qualifierName, false, pui.getClassLoader()).asSubclass(Annotation.class);
            AnnotationLiteral qualifierAnnotationLiteral = new AnnotationLiteral(){
                static final long serialVersionUID = -1762574615597027612L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Class<? extends Annotation> annotationType() {
                    return qualifierClass;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jpa.container.v32.cdi.internal.JPACDIExtension$1", 1.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
                }
            };
            qualifiers.add((Annotation)qualifierAnnotationLiteral);
        }
        return qualifiers;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class AppOnlyJ2EEName
    implements J2EEName {
        private final String appName;
        static final long serialVersionUID = 7747940484779623114L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AppOnlyJ2EEName(String appName) {
            this.appName = appName;
        }

        public String getApplication() {
            return this.appName;
        }

        public byte[] getBytes() {
            return null;
        }

        public String getComponent() {
            return null;
        }

        public String getModule() {
            return null;
        }

        public String toString() {
            return "AppOnlyJ2EEName[" + this.appName + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jpa.container.v32.cdi.internal.JPACDIExtension$AppOnlyJ2EEName", AppOnlyJ2EEName.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
        }
    }
}

