/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server;

import java.io.IOException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;

public class ServerLog
extends AbstractSessionLog {
    @Override
    public void log(SessionLogEntry entry) {
        if (!this.shouldLog(entry.getLevel())) {
            return;
        }
        Object message = this.getSupplementDetailString(entry);
        if (entry.hasException()) {
            if (entry.getLevel() == 7) {
                message = (String)message + Helper.printStackTraceToString(entry.getException());
            } else if (entry.getLevel() <= 6) {
                message = this.shouldLogExceptionStackTrace() ? (String)message + Helper.printStackTraceToString(entry.getException()) : (String)message + String.valueOf(entry.getException());
            }
        } else {
            message = (String)message + this.formatMessage(entry);
        }
        this.basicLog(entry.getLevel(), entry.getNameSpace(), (String)message);
    }

    protected void basicLog(int level, String category, String message) {
        try {
            this.printPrefixString(level, null);
            this.getWriter().write(message);
            this.getWriter().write(System.lineSeparator());
            this.getWriter().flush();
        }
        catch (IOException exception) {
            throw ValidationException.logIOError(exception);
        }
    }
}

