/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.webapp;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.srt.ISRTServletRequest;
import com.ibm.ws.webcontainer.srt.SRTRequestContext;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.util.UnsynchronizedStack;
import com.ibm.ws.webcontainer.util.WebContainerSystemProps;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import com.ibm.wsspi.webcontainer.webapp.IWebAppDispatcherContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class WebAppDispatcherContext
implements Cloneable,
IWebAppDispatcherContext {
    protected static TraceNLS nls = TraceNLS.getTraceNLS(WebAppDispatcherContext.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.webapp");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext";
    protected UnsynchronizedStack<IServletWrapper> _servletReferenceStack = new UnsynchronizedStack();
    private UnsynchronizedStack _exceptionStack = new UnsynchronizedStack();
    protected IExtendedRequest _request;
    protected SRTRequestContext reqContext = null;
    protected WebAppDispatcherContext parentContext = null;
    private String relativeUri;
    protected String _servletPath;
    protected String _pathInfo;
    private String _requestUri;
    private String _contextPath = null;
    private String queryString = null;
    protected boolean _useParent = false;
    private boolean enforceSecurity = true;
    private String decodedReqUri;
    private static final boolean redirectWithPathInfo = WCCustomProperties.REDIRECT_WITH_PATH_INFO;
    private static final boolean removeServletPathSlash = WCCustomProperties.REMOVE_TRAILING_SERVLET_PATH_SLASH;
    private boolean possibleSlashStarMapping = true;
    private WebApp _webApp;
    private DispatcherType dispatcherType = DispatcherType.REQUEST;
    private boolean isNamedDispatcher = false;

    public void setNamedDispatcher(boolean b) {
        this.isNamedDispatcher = b;
    }

    public boolean isNamedDispatcher() {
        return this.isNamedDispatcher;
    }

    public void setParentContext(WebAppDispatcherContext parent) {
        this.parentContext = parent;
    }

    public void finish() {
        this.resetObject();
    }

    public void setUseParent(boolean useParent) {
        this._useParent = useParent;
    }

    @Override
    public WebApp getWebApp() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getWebApp", "webapp -> " + this._webApp + " ,this -> " + this);
        }
        return this._webApp;
    }

    public void initForNextDispatch(IExtendedRequest req) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "initForNextDispatch", "req -> " + req + " ,this -> " + this);
        }
        this._request = req;
        if (req != null) {
            this.reqContext = ((ISRTServletRequest)((Object)this._request)).getRequestContext();
        }
    }

    public void pushServletReference(IServletWrapper wrapper) {
        this._servletReferenceStack.push(wrapper);
    }

    public void popServletReference() {
        if (this._servletReferenceStack.size() > 1) {
            this._servletReferenceStack.pop();
        }
    }

    @Override
    public IServletWrapper getCurrentServletReference() {
        return this._servletReferenceStack.peek();
    }

    public Throwable getCurrentException() {
        if (this._exceptionStack.size() == 0) {
            return null;
        }
        return (Throwable)this._exceptionStack.peek();
    }

    public ServletRequest getRequest() {
        return this._request;
    }

    public IExtendedResponse getResponse() {
        return this._request.getResponse();
    }

    void resetObject() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "resetObject", "this ->" + this);
        }
        this._servletReferenceStack.clear();
        this._exceptionStack.clear();
        this._pathInfo = null;
        this._servletPath = null;
        this._webApp = null;
        this.relativeUri = null;
        this.queryString = null;
        this._requestUri = null;
        this.enforceSecurity = true;
        this.dispatcherType = DispatcherType.REQUEST;
        this._contextPath = null;
    }

    private IHttpSessionContext getSessionContext() {
        return this._webApp.getSessionContext();
    }

    public String getRequestedSessionId() {
        return this.getSessionContext().getRequestedSessionId(this._request);
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getSessionContext().isRequestedSessionIdFromCookie(this._request);
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.getSessionContext().isRequestedSessionIdFromUrl(this._request);
    }

    @Override
    public void sessionPreInvoke() {
        this.reqContext.sessionPreInvoke(this._webApp);
    }

    @Override
    public void sessionPostInvoke() {
        try {
            this.reqContext.sessionPostInvoke();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String encodeURL(String arg0) {
        return this.reqContext.encodeURL(this._webApp, this._request, arg0);
    }

    @Override
    public String getRelativeUri() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getRelativeUri();
        }
        return this.relativeUri;
    }

    public void setRelativeUri(String relativeUri) {
        this.relativeUri = relativeUri;
    }

    public String getRealPath(String path) {
        return this.getWebApp().getRealPath(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        String newPath;
        String pathInfo;
        String servletPath;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "getRequestDispatcher", " path [" + path + "]");
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.getWebApp().getFacade().getRequestDispatcher(path);
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
        }
        if ((servletPath = (String)this._request.getAttribute("jakarta.servlet.include.servlet_path")) == null) {
            pathInfo = this.getPathInfo();
            newPath = this.getServletPath();
            if (pathInfo != null) {
                newPath = newPath + pathInfo;
            }
        } else {
            pathInfo = (String)this._request.getAttribute("jakarta.servlet.include.path_info");
            newPath = servletPath;
            if (pathInfo != null) {
                newPath = newPath + pathInfo;
            }
        }
        if (newPath != null) {
            int pathElementIndex = newPath.indexOf(59);
            newPath = pathElementIndex == -1 ? newPath.substring(0, newPath.lastIndexOf("/")) : newPath.substring(0, newPath.lastIndexOf("/", pathElementIndex));
            path = newPath + '/' + path;
        } else {
            path = '/' + path;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequestDispatcher", "calling webApp getRequestDispatcher, path [" + path + "]");
        }
        return this.getWebApp().getFacade().getRequestDispatcher(path);
    }

    public abstract Principal getUserPrincipal();

    public abstract boolean isUserInRole(String var1, HttpServletRequest var2);

    public String getPathInfo() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getPathInfo();
        }
        return this._pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this._pathInfo = pathInfo;
    }

    public String getMappingValue() {
        return null;
    }

    public String getRequestURI() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getRequestURI();
        }
        return this._requestUri;
    }

    @Override
    public String getOriginalRelativeURI() {
        WebAppDispatcherContext currentContext = this;
        for (WebAppDispatcherContext tempParentContext = this.parentContext; tempParentContext != null; tempParentContext = tempParentContext.getParentContext()) {
            currentContext = tempParentContext;
        }
        return currentContext.getRelativeUri();
    }

    protected WebAppDispatcherContext getParentContext() {
        return this.parentContext;
    }

    public String getContextPath() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getContextPath();
        }
        String cp = null;
        cp = this._contextPath != null ? this._contextPath : this.getWebApp().getContextPath();
        if (cp.equals("/")) {
            return "";
        }
        return cp;
    }

    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        return this.getWebApp().getRealPath(pathInfo);
    }

    public String getServletPath() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getServletPath();
        }
        return this._servletPath;
    }

    public void setServletPath(String servletPath) {
        this._servletPath = servletPath;
    }

    public void sendRedirect303(String location) throws IOException {
        this.sendRedirectWithStatusCode(location, 303);
    }

    public void sendRedirect(String location) throws IOException {
        this.sendRedirectWithStatusCode(location, 302);
    }

    private void sendRedirectWithStatusCode(String location, int statusCode) throws IOException {
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (!response.isCommitted()) {
            if (location == null) {
                throw new IllegalArgumentException("Location cannot be null in jakarta.servlet.http.HttpServletResponse.sendRedirect(location)");
            }
            response.resetBuffer();
            if (!WCCustomProperties.REDIRECT_TO_RELATIVE_URL) {
                location = this.convertRelativeURIToURL(location);
            }
        } else {
            throw new IllegalStateException();
        }
        response.setHeader("Location", location);
        response.setStatus(statusCode);
    }

    public void sendError(int sc) throws IOException {
        IServletWrapper ref = this.getCurrentServletReference();
        if (ref != null) {
            this.sendError(sc, MessageFormat.format(nls.getString("[{0}].reported.an.error", "[{0}] reported an error"), ref.getName()));
        } else {
            this.sendError(sc, MessageFormat.format(nls.getString("[{0}].reported.an.error", "[{0}] reported an error"), this.getWebApp().getConfiguration().getDisplayName()));
        }
    }

    @Override
    public void sendError(int sc, String message, boolean ignoreCommittedException) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "sendError", "ENTER ; sc [" + sc + "] : message [" + message + "] : ignoreCommittedException [", ignoreCommittedException + "]");
        }
        if (this.getResponse().isCommitted()) {
            if (!ignoreCommittedException) {
                throw new IllegalStateException("Response already committed.");
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendError", "response is committed, but not throwing ISE");
            }
        } else {
            this.getResponse().resetBuffer();
            try {
                ((HttpServletResponse)this.getResponse()).setStatus(sc);
            }
            catch (IllegalStateException e) {
                FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.sendError", "112", this);
            }
        }
        WebApp webapp = this.getWebApp();
        Object fileNotFound = this.getRequest().getAttribute("com.ibm.ws.webcontainer.filter.filterproxyservletfilenotfound");
        if (fileNotFound != null) {
            this.getRequest().removeAttribute("com.ibm.ws.webcontainer.filter.filterproxyservletfilenotfound");
            webapp.sendError(this._request, (HttpServletResponse)this.getResponse(), (ServletErrorReport)((Object)fileNotFound));
        } else {
            WebAppErrorReport error = null;
            error = new WebAppErrorReport(message);
            error.setErrorCode(sc);
            IServletWrapper ref = this.getCurrentServletReference();
            if (ref != null) {
                error.setTargetServletName(ref.getName());
            }
            this.getWebApp().sendError(this._request, (HttpServletResponse)this.getResponse(), error);
        }
        this.getResponse().flushBuffer();
    }

    public void sendError(int sc, String message) throws IOException {
        this.sendError(sc, message, false);
    }

    protected String convertRelativeURIToURL(String relativeURI) {
        String location;
        block22: {
            int indexOfQueryString;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "convertRelativeURIToURL", "relativeURI [" + relativeURI + "] ,this -> " + this);
            }
            location = null;
            if (relativeURI == null) {
                throw new IllegalStateException();
            }
            location = relativeURI;
            int indexOfSchemeDelimiter = (relativeURI = relativeURI.trim()).indexOf("://");
            if (indexOfSchemeDelimiter != -1 && ((indexOfQueryString = relativeURI.indexOf(63)) == -1 || indexOfSchemeDelimiter < indexOfQueryString)) {
                return relativeURI;
            }
            String urlScheme = this._request.getScheme();
            if (WebContainer.getServletContainerSpecLevel() >= 31 && relativeURI.startsWith("//")) {
                StringBuffer url = new StringBuffer(urlScheme);
                url.append(":");
                url.append(relativeURI);
                return url.toString();
            }
            String webAppRootURI = null;
            boolean relativeToRootURI = false;
            try {
                webAppRootURI = this.getWebApp().getContextPath().trim();
                if (!webAppRootURI.startsWith("/")) {
                    webAppRootURI = "/" + webAppRootURI;
                }
            }
            catch (Exception ex) {
                FFDCWrapper.processException(ex, "com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.convertRelativeURIToURL", "184", this);
                webAppRootURI = "/";
            }
            try {
                relativeToRootURI = relativeURI.startsWith("/");
                if (relativeURI.startsWith("./")) {
                    relativeURI = relativeURI.substring(2);
                }
                IExtendedRequest request = this._request;
                int urlPort = request.getServerPort();
                StringBuffer url = new StringBuffer(urlScheme);
                url.append("://");
                url.append(request.getServerName());
                if (urlScheme.equals("http") && urlPort != 80 || urlScheme.equals("https") && urlPort != 443) {
                    url.append(":");
                    url.append(urlPort);
                }
                String redirectURL = null;
                if (relativeToRootURI) {
                    if (WebContainerSystemProps.getSendRedirectCompatibilty()) {
                        url.append(webAppRootURI);
                        url.append(relativeURI);
                    } else {
                        url.append(relativeURI);
                    }
                    redirectURL = url.toString();
                } else {
                    String requestString = request.getRequestURL().toString();
                    String pathInfo = request.getPathInfo();
                    if (!webAppRootURI.equals("/") && request.getRequestURI().equals(webAppRootURI)) {
                        requestString = requestString + "/";
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "convertRelativeURIToURL", "appended / to requestString --> " + requestString);
                        }
                    }
                    if (pathInfo != null && pathInfo.length() > 0) {
                        if (!pathInfo.startsWith("/")) {
                            pathInfo = "/" + pathInfo;
                        }
                        requestString = redirectWithPathInfo || WebContainer.getServletContainerSpecLevel() >= 31 ? requestString.substring(0, requestString.lastIndexOf("/")) : requestString.substring(0, requestString.lastIndexOf(pathInfo));
                        redirectURL = requestString + "/" + relativeURI;
                    } else {
                        redirectURL = requestString.substring(0, requestString.lastIndexOf(47) + 1) + relativeURI;
                    }
                }
                if (redirectURL.indexOf("..") > -1) {
                    int skip = new String(urlScheme + "://").length();
                    int split = redirectURL.indexOf("/", skip);
                    String serverString = redirectURL.substring(0, split);
                    String uri = redirectURL.substring(split);
                    this.getWebApp();
                    uri = WebApp.normalize(uri);
                    if (uri != null) {
                        return serverString + uri;
                    }
                    break block22;
                }
                return redirectURL;
            }
            catch (Exception ex) {
                FFDCWrapper.processException(ex, "com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.convertRelativeURIToURL", "256", this);
            }
        }
        logger.logp(Level.FINE, CLASS_NAME, "convertRelativeURIToURL", "could not convert [" + location + "]");
        return location;
    }

    public void callPage(String fileName, HttpServletRequest hreq) throws IOException, ServletException {
        ServletContext sc = this.getWebApp().getContext(fileName);
        WebApp webapp = (WebApp)sc;
        String relativePath = fileName.substring(webapp.getContextPath().length());
        RequestDispatcher rd = sc.getRequestDispatcher(relativePath);
        rd.forward((ServletRequest)hreq, (ServletResponse)this.getResponse());
    }

    public void _include(String fileName, HttpServletRequest request) throws IOException, ServletException {
        WebApp webApp = this.getWebApp();
        RequestDispatcher requestDispatcher = webApp.getRequestDispatcher(fileName);
        requestDispatcher.include((ServletRequest)request, (ServletResponse)this.getResponse());
    }

    public void _forward(String fileName, HttpServletRequest request) throws IOException, ServletException {
        WebApp webApp = this.getWebApp();
        RequestDispatcher requestDispatcher = webApp.getRequestDispatcher(fileName);
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)this.getResponse());
    }

    public boolean isAutoRequestEncoding() {
        return this.getWebApp().getConfiguration().isAutoResponseEncoding();
    }

    public void setRequestURI(String path) {
        this.setRequestURI(path, false);
    }

    public void setRequestURI(String path, boolean encodeURI) {
        if (path == null) {
            this._requestUri = path;
            return;
        }
        int qMark = path.indexOf("?");
        if (qMark != -1) {
            this.queryString = path.substring(qMark + 1);
            this._requestUri = path.substring(0, qMark);
        } else {
            this._requestUri = path;
        }
        if (encodeURI) {
            block7: {
                try {
                    this._requestUri = new URI(null, this._requestUri, null).toASCIIString();
                }
                catch (URISyntaxException use) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block7;
                    logger.logp(Level.FINE, CLASS_NAME, "setRequestURI", "An URISyntaxException was thrown during URI encoding");
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setRequestURI", "encoding request URI, path -> " + path + ", encoded URI -> " + this._requestUri);
            }
        }
    }

    public void setPathElements(String servletPath, String pathInfo) {
        ((ISRTServletRequest)((Object)this._request)).resetPathElements();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setPathElements", "servletPath = " + servletPath + ", pathInfo = " + pathInfo + " : this = " + this);
        }
        if (removeServletPathSlash) {
            boolean hasSlashStar = false;
            boolean isPossible = this.isPossibleSlashStarMapping();
            if (isPossible) {
                hasSlashStar = this.hasSlashStarMapping();
            }
            if (hasSlashStar) {
                this._servletPath = "";
                this._pathInfo = servletPath == null ? pathInfo : (pathInfo == null ? servletPath : servletPath + pathInfo);
            } else if (isPossible) {
                if (servletPath == null || servletPath.equals("")) {
                    this._servletPath = pathInfo;
                    this._pathInfo = null;
                } else {
                    this._servletPath = servletPath;
                    this._pathInfo = pathInfo;
                }
            } else {
                this._servletPath = servletPath;
                this._pathInfo = pathInfo;
            }
            if (this._servletPath != null && this._servletPath.length() > 1 && this._servletPath.endsWith("/")) {
                this._servletPath = this._servletPath.substring(0, this._servletPath.length() - 1);
                this._pathInfo = this._pathInfo == null ? "/" : "/" + this._pathInfo;
            }
        } else if (servletPath.length() == 1 && servletPath.charAt(0) == '/' && !Boolean.valueOf(WCCustomProperties.SERVLET_PATH_FOR_DEFAULT_MAPPING).booleanValue()) {
            this._servletPath = "";
            this._pathInfo = pathInfo == null ? "/" : "/" + pathInfo;
        } else {
            this._servletPath = servletPath;
            this._pathInfo = pathInfo;
        }
        this.relativeUri = this._servletPath;
        if (this._pathInfo != null) {
            this.relativeUri = this.relativeUri + this._pathInfo;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setPathElements", "returns with servletPath = " + this._servletPath + ", pathInfo = " + this._pathInfo + " : this = " + this);
        }
    }

    @Override
    public boolean isForward() {
        return this.dispatcherType == DispatcherType.FORWARD;
    }

    @Override
    public boolean isInclude() {
        return this.dispatcherType == DispatcherType.INCLUDE;
    }

    public boolean isAsync() {
        return this.dispatcherType == DispatcherType.ASYNC;
    }

    public String getQueryString() {
        if (this.parentContext != null && this._useParent) {
            return this.parentContext.getQueryString();
        }
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    @Override
    public void pushException(Throwable th) {
        this._exceptionStack.push(th);
    }

    public void setWebApp(WebApp app) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setWebApp", "webapp -> " + app + " ,this -> " + this);
        }
        this._webApp = app;
        if (this.reqContext != null) {
            this.reqContext.setCurrWebAppBoundary(app);
        }
    }

    public void setContextPath(String _contextPath) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setContextPath", "contextPath -> " + _contextPath + " ,this -> " + this);
        }
        this._contextPath = _contextPath;
    }

    @Override
    public boolean isEnforceSecurity() {
        return this.enforceSecurity;
    }

    public void setEnforceSecurity(boolean enforceSecurity) {
        this.enforceSecurity = enforceSecurity;
    }

    public void setDecodedReqUri(String decodedURI) {
        this.decodedReqUri = decodedURI;
    }

    public String getDecodedReqUri() {
        return this.decodedReqUri;
    }

    public boolean isSecurityEnabledForApplication() {
        return this._webApp.isSecurityEnabledForApplication();
    }

    public void dumpDispatchContextHierarchy() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "dumpDispatchContextHierarchy", "current context -->" + this);
            WebAppDispatcherContext tmpParentContext = this.parentContext;
            while (tmpParentContext != null) {
                logger.logp(Level.FINE, CLASS_NAME, "dumpDispatchContextHierarchy", "parent context -->" + tmpParentContext);
                tmpParentContext = tmpParentContext.parentContext;
            }
        }
    }

    public Object clone(SRTServletRequest clonedRequest, SRTRequestContext clonedReqContext) throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", "clone entry");
        }
        WebAppDispatcherContext _cloneDispatchContext = (WebAppDispatcherContext)super.clone();
        _cloneDispatchContext._request = clonedRequest;
        _cloneDispatchContext.reqContext = clonedReqContext;
        if (this._servletReferenceStack != null) {
            _cloneDispatchContext._servletReferenceStack = (UnsynchronizedStack)this._servletReferenceStack.clone();
        }
        if (this._exceptionStack != null) {
            _cloneDispatchContext._exceptionStack = (UnsynchronizedStack)this._exceptionStack.clone();
        }
        if (this.parentContext != null) {
            _cloneDispatchContext.parentContext = (WebAppDispatcherContext)this.parentContext.clone(clonedRequest, clonedReqContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", "clone exit original -->" + this + " cloned -->" + _cloneDispatchContext);
        }
        return _cloneDispatchContext;
    }

    public boolean hasSlashStarMapping() {
        WebApp webApp;
        boolean hasSlashStarMapping;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "hasSlashStarMapping");
        }
        boolean bl = hasSlashStarMapping = (webApp = this._webApp) == null ? false : webApp.hasSlashStarMapping();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "hasSlashStarMapping: " + hasSlashStarMapping);
        }
        return hasSlashStarMapping;
    }

    public void setPossibleSlashStarMapping(boolean isPossible) {
        this.possibleSlashStarMapping = isPossible;
    }

    public boolean isPossibleSlashStarMapping() {
        return this.possibleSlashStarMapping;
    }

    public void clearAndPushServletReference(IServletWrapper servletWrapper) {
        this._servletReferenceStack.clear();
        this.pushServletReference(servletWrapper);
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setDispatcherType", "dispatcherType->" + dispatcherType);
        }
        this.dispatcherType = dispatcherType;
    }

    @Override
    public DispatcherType getDispatcherType() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getDispatcherType", "dispatcherType->" + this.dispatcherType);
        }
        return this.dispatcherType;
    }
}

