/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.server.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.api.JaxRsModuleInfoBuilder;
import com.ibm.ws.jaxrs20.metadata.EndpointInfo;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleInfo;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleMetaData;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleType;
import com.ibm.ws.jaxrs20.utils.UriEncoder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.jaxrs20.module.info.builder", immediate=true, property={"service.vendor=IBM"}, configurationPolicy=ConfigurationPolicy.OPTIONAL)
public class JaxRsWebModuleInfoBuilder
implements JaxRsModuleInfoBuilder {
    private static final TraceComponent tc = Tr.register(JaxRsWebModuleInfoBuilder.class, (String)"JaxRsServer", (String)"com.ibm.ws.jaxrs20.server.internal.resources.JaxRsServerMessages");
    static final long serialVersionUID = 6845839107088740932L;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={ClassNotFoundException.class})
    public ExtendedModuleInfo build(ModuleMetaData moduleMetaData, Container containerToAdapt, JaxRsModuleInfo jaxRsModuleInfo) throws UnableToAdaptException {
        if (jaxRsModuleInfo.getModuleType() == JaxRsModuleType.EJB) {
            return null;
        }
        WebAnnotations webAnnotations = AnnotationsBetaHelper.getWebAnnotations((Container)containerToAdapt);
        try {
            WebAppConfig webAppConfig = (WebAppConfig)containerToAdapt.adapt(WebAppConfig.class);
            AnnotationTargets_Targets annotationTargets = webAnnotations.getAnnotationTargets();
            HashSet allAppPathClassNames = new HashSet();
            HashSet<String> allProviderAndPathClassNames = new HashSet<String>();
            allProviderAndPathClassNames.addAll(annotationTargets.getAnnotatedClasses(Provider.class.getName()));
            allProviderAndPathClassNames.addAll(annotationTargets.getAnnotatedClasses(Path.class.getName()));
            allAppPathClassNames.addAll(annotationTargets.getAnnotatedClasses(ApplicationPath.class.getName()));
            LinkedHashMap<String, EndpointInfo> endpointInfoMap = new LinkedHashMap<String, EndpointInfo>();
            Iterator cfgIter = webAppConfig.getServletInfos();
            while (cfgIter.hasNext()) {
                HashSet<String> thisAppProviderAndPathClassNames2;
                String appPath;
                String appClassName;
                String servletMappingUrl;
                String servletClassName;
                String string;
                block22: {
                    block23: {
                        IServletConfig servletCfg = (IServletConfig)cfgIter.next();
                        string = servletCfg.getServletName();
                        servletClassName = servletCfg.getClassName();
                        servletMappingUrl = null;
                        appClassName = null;
                        appPath = null;
                        thisAppProviderAndPathClassNames2 = null;
                        if (servletClassName != null) break block23;
                        if (string.equals("javax.ws.rs.core.Application")) {
                            appClassName = string;
                            servletMappingUrl = JaxRsWebModuleInfoBuilder.getServletMappingUrl(webAppConfig, string);
                            thisAppProviderAndPathClassNames2 = allProviderAndPathClassNames;
                            break block22;
                        } else {
                            appClassName = string;
                            Class<?> appClass = null;
                            Class<?> appBaseClass = null;
                            try {
                                appClass = JaxRsModuleMetaData.getJaxRsModuleMetaData((ModuleMetaData)moduleMetaData).getAppContextClassLoader().loadClass(appClassName);
                                appBaseClass = JaxRsModuleMetaData.getJaxRsModuleMetaData((ModuleMetaData)moduleMetaData).getAppContextClassLoader().loadClass(Application.class.getName());
                            }
                            catch (ClassNotFoundException e) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)"ServletName could not be loaded.  This may be expected.", (Object[])new Object[]{e});
                                continue;
                            }
                            if (!appBaseClass.isAssignableFrom(appClass)) continue;
                            try {
                                servletMappingUrl = JaxRsWebModuleInfoBuilder.getServletMappingUrl(webAppConfig, string);
                                appPath = JaxRsWebModuleInfoBuilder.getApplicationPathValue(appClass);
                                thisAppProviderAndPathClassNames2 = allProviderAndPathClassNames;
                                break block22;
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebModuleInfoBuilder", (String)"180", (Object)this, (Object[])new Object[]{moduleMetaData, containerToAdapt, jaxRsModuleInfo});
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("Exception when collect metadata from class " + appClass.getName()), (Object[])new Object[]{e});
                                continue;
                            }
                        }
                    }
                    if (!servletClassName.equals("com.ibm.websphere.jaxrs.server.IBMRestServlet")) continue;
                    IServletConfig sconfig = webAppConfig.getServletInfo(string);
                    appClassName = sconfig.getInitParameter("javax.ws.rs.Application");
                    if (appClassName == null) {
                        Tr.warning((TraceComponent)tc, (String)"warn.servlet.specified.without.application", (Object[])new Object[]{moduleMetaData.getName(), string, servletClassName});
                        continue;
                    }
                    Class<?> appClass = JaxRsModuleMetaData.getJaxRsModuleMetaData((ModuleMetaData)moduleMetaData).getAppContextClassLoader().loadClass(appClassName);
                    Class<?> appBaseClass = JaxRsModuleMetaData.getJaxRsModuleMetaData((ModuleMetaData)moduleMetaData).getAppContextClassLoader().loadClass(Application.class.getName());
                    if (appBaseClass.isAssignableFrom(appClass)) {
                        try {
                            servletMappingUrl = JaxRsWebModuleInfoBuilder.getServletMappingUrl(webAppConfig, string);
                            appPath = JaxRsWebModuleInfoBuilder.getApplicationPathValue(appClass);
                            thisAppProviderAndPathClassNames2 = allProviderAndPathClassNames;
                            break block22;
                        }
                        catch (Exception exception) {
                            void e;
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebModuleInfoBuilder", (String)"230", (Object)this, (Object[])new Object[]{moduleMetaData, containerToAdapt, jaxRsModuleInfo});
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Exception when collect metadata from class " + appClass.getName()), (Object[])new Object[]{e});
                            continue;
                        }
                    }
                    Tr.warning((TraceComponent)tc, (String)"warn.servlet.specified.with.invalid.application", (Object[])new Object[]{moduleMetaData.getName(), string, appClassName});
                    continue;
                }
                try {
                    JaxRsWebModuleInfoBuilder.registerEndpointInfo(endpointInfoMap, string, servletClassName, servletMappingUrl, appClassName, appPath, thisAppProviderAndPathClassNames2);
                    if (!allAppPathClassNames.contains(appClassName)) continue;
                    allAppPathClassNames.remove(appClassName);
                }
                catch (Exception sconfig) {
                    void e;
                    FFDCFilter.processException((Throwable)sconfig, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebModuleInfoBuilder", (String)"255", (Object)this, (Object[])new Object[]{moduleMetaData, containerToAdapt, jaxRsModuleInfo});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Exception when register endpoint " + string), (Object[])new Object[]{e});
                }
            }
            for (String string : allAppPathClassNames) {
                Class<?> appClass = JaxRsModuleMetaData.getJaxRsModuleMetaData((ModuleMetaData)moduleMetaData).getAppContextClassLoader().loadClass(string);
                Class<?> appBaseClass = JaxRsModuleMetaData.getJaxRsModuleMetaData((ModuleMetaData)moduleMetaData).getAppContextClassLoader().loadClass(Application.class.getName());
                if (!appBaseClass.isAssignableFrom(appClass)) continue;
                String appPath = null;
                HashSet<String> thisAppProviderAndPathClassNames = null;
                try {
                    appPath = JaxRsWebModuleInfoBuilder.getApplicationPathValue(appClass);
                    thisAppProviderAndPathClassNames = allProviderAndPathClassNames;
                }
                catch (Exception thisAppProviderAndPathClassNames2) {
                    void e;
                    FFDCFilter.processException((Throwable)thisAppProviderAndPathClassNames2, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebModuleInfoBuilder", (String)"283", (Object)this, (Object[])new Object[]{moduleMetaData, containerToAdapt, jaxRsModuleInfo});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Exception when collect metadata from class " + appClass.getName()), (Object[])new Object[]{e});
                    continue;
                }
                try {
                    JaxRsWebModuleInfoBuilder.registerEndpointInfo(endpointInfoMap, string, null, null, string, appPath, thisAppProviderAndPathClassNames);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebModuleInfoBuilder", (String)"294", (Object)this, (Object[])new Object[]{moduleMetaData, containerToAdapt, jaxRsModuleInfo});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Exception when register endpoint " + string), (Object[])new Object[]{e});
                }
            }
            for (Map.Entry entry : endpointInfoMap.entrySet()) {
                EndpointInfo endpointInfo = (EndpointInfo)entry.getValue();
                jaxRsModuleInfo.addEndpointInfo(endpointInfo.getAppClassName(), endpointInfo);
            }
            return null;
        }
        catch (Exception webAppConfig) {
            void e;
            FFDCFilter.processException((Throwable)webAppConfig, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsWebModuleInfoBuilder", (String)"316", (Object)this, (Object[])new Object[]{moduleMetaData, containerToAdapt, jaxRsModuleInfo});
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return null;
            Tr.debug((TraceComponent)tc, (String)"Exception when build jaxrs web module info: ", (Object[])new Object[]{e});
        }
        return null;
    }

    private static void registerEndpointInfo(LinkedHashMap<String, EndpointInfo> endpointInfoMap, String servletName, String servletClassName, String servletMappingUrl, String appClassName, String appPath, Set<String> providerAndPathClassNames) throws Exception {
        String key = servletMappingUrl;
        appPath = UriEncoder.decodeString((String)appPath);
        if (key == null) {
            key = appPath;
        }
        if (key == null) {
            throw new Exception("Both servlet mapping url and application path are null.");
        }
        EndpointInfo endpointInfo = new EndpointInfo(servletName, servletClassName, servletMappingUrl, appClassName, appPath, providerAndPathClassNames);
        EndpointInfo existingInfo = endpointInfoMap.get(key);
        if (existingInfo != null) {
            throw new Exception("Found duplicated servlet mapping url, " + key + ", with endpoint infos " + existingInfo + " and " + endpointInfo + ", throw exception to fail application starting.");
        }
        if (servletName == null || appClassName == null || providerAndPathClassNames == null) {
            throw new Exception("invalid values for servletName or appClassName or providerAndPathClassNames");
        }
        endpointInfoMap.put(key, endpointInfo);
    }

    private static String getServletMappingUrl(WebAppConfig webAppConfig, String servletName) {
        String url = null;
        IServletConfig sconfig = webAppConfig.getServletInfo(servletName);
        if (sconfig != null && sconfig.getMappings() != null && sconfig.getMappings().size() > 0) {
            for (String map : sconfig.getMappings()) {
                if (map == null || map.length() <= 0) continue;
                url = map.endsWith("*") ? map.substring(0, map.length() - 1) : map;
                break;
            }
        }
        return url;
    }

    private static String getApplicationPathValue(Class<?> applicationClassClass) {
        if (applicationClassClass == null) {
            return null;
        }
        ApplicationPath appPath = applicationClassClass.getAnnotation(ApplicationPath.class);
        if (appPath == null) {
            return null;
        }
        String value = appPath.value();
        if (!(value = UriEncoder.encodePath((String)value, (boolean)true)).endsWith("/*")) {
            if (!value.endsWith("/")) {
                value = value + "/";
            }
            if (!value.endsWith("*")) {
                value = value + "*";
            }
        }
        return value;
    }

    @Activate
    protected void activate(ComponentContext cc) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
    }

    public JaxRsModuleType getSupportType() {
        return JaxRsModuleType.WEB;
    }
}

