/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.io;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.CachedOutputStreamCleaner;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public final class DelayedCachedOutputStreamCleaner
implements CachedOutputStreamCleaner,
BusLifeCycleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(DelayedCachedOutputStreamCleaner.class);
    private static final long MIN_DELAY = 2000L;
    private static final DelayedCleaner NOOP_CLEANER = new DelayedCleaner(){
        static final long serialVersionUID = 8816545258106142119L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.io.DelayedCachedOutputStreamCleaner$1", 1.class, null, null);
        }
    };
    private DelayedCleaner cleaner;
    private boolean cleanupOnShutdown;
    static final long serialVersionUID = -2460193203624740065L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DelayedCachedOutputStreamCleaner() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "<init>", new Object[0]);
        }
        this.cleaner = NOOP_CLEANER;
        this.cleanupOnShutdown = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "<init>", this);
        }
    }

    @Resource
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setBus(Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "setBus", new Object[]{bus});
        }
        Number delayValue = null;
        BusLifeCycleManager busLifeCycleManager = null;
        Boolean cleanupOnShutdownValue = null;
        if (bus != null) {
            delayValue = (Number)bus.getProperty("bus.io.CachedOutputStreamCleaner.Delay");
            cleanupOnShutdownValue = (Boolean)bus.getProperty("bus.io.CachedOutputStreamCleaner.CleanOnShutdown");
            busLifeCycleManager = bus.getExtension(BusLifeCycleManager.class);
        }
        if (this.cleaner != null) {
            this.cleaner.close();
        }
        this.cleanupOnShutdown = cleanupOnShutdownValue != null ? cleanupOnShutdownValue : true;
        if (delayValue == null) {
            this.cleaner = new DelayedCleanerImpl(TimeUnit.MILLISECONDS.convert(30L, TimeUnit.MINUTES));
        } else {
            long value = delayValue.longValue();
            if (value > 0L && value >= 2000L) {
                this.cleaner = new DelayedCleanerImpl(value);
            } else {
                this.cleaner = NOOP_CLEANER;
                if (value != 0L) {
                    throw new IllegalArgumentException("The value of bus.io.CachedOutputStreamCleaner.Delay property is invalid: " + value + " (should be >= " + 2000L + ", 0 to deactivate)");
                }
            }
        }
        if (busLifeCycleManager != null) {
            busLifeCycleManager.registerLifeCycleListener(this);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "setBus");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void register(Closeable closeable) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "register", new Object[]{closeable});
        }
        this.cleaner.register(closeable);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "register");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void unregister(Closeable closeable) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "unregister", new Object[]{closeable});
        }
        this.cleaner.unregister(closeable);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "unregister");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int size() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "size", new Object[0]);
        }
        int n = this.cleaner.size();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "size", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void clean() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "clean", new Object[0]);
        }
        this.cleaner.clean();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "clean");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void initComplete() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "initComplete", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "initComplete");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void postShutdown() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "postShutdown", new Object[0]);
        }
        if (this.cleanupOnShutdown) {
            this.forceClean();
            this.cleaner.close();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "postShutdown");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void preShutdown() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "preShutdown", new Object[0]);
        }
        if (!this.cleanupOnShutdown) {
            this.cleaner.close();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "preShutdown");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void forceClean() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "forceClean", new Object[0]);
        }
        this.cleaner.forceClean();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.io.DelayedCachedOutputStreamCleaner", "forceClean");
        }
    }

    private static interface DelayedCleaner
    extends CachedOutputStreamCleaner,
    Closeable {
        @Override
        default public void register(Closeable closeable) {
        }

        @Override
        default public void unregister(Closeable closeable) {
        }

        @Override
        default public void close() {
        }

        @Override
        default public void clean() {
        }

        @Override
        default public int size() {
            return 0;
        }

        default public void forceClean() {
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static final class DelayedCleanerImpl
    implements DelayedCleaner {
        private final long delay;
        private final DelayQueue<DelayedCloseable> queue = new DelayQueue();
        private final Timer timer;
        static final long serialVersionUID = -3071513036207716524L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DelayedCleanerImpl(long delay) {
            this.delay = delay;
            this.timer = new Timer("DelayedCachedOutputStreamCleaner", true);
            this.timer.scheduleAtFixedRate(new TimerTask(){
                static final long serialVersionUID = 7134786997432377638L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    this.clean();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.io.DelayedCachedOutputStreamCleaner$DelayedCleanerImpl$1", 1.class, null, null);
                }
            }, 0L, Math.max(2000L, delay >> 1));
        }

        @Override
        public void register(Closeable closeable) {
            this.queue.put(new DelayedCloseable(closeable, this.delay));
        }

        @Override
        public void unregister(Closeable closeable) {
            this.queue.remove(new DelayedCloseable(closeable, this.delay));
        }

        @Override
        public void clean() {
            ArrayList<DelayedCloseable> closeables = new ArrayList<DelayedCloseable>();
            this.queue.drainTo(closeables);
            this.clean(closeables);
        }

        @Override
        public void forceClean() {
            this.clean(this.queue);
        }

        @Override
        public void close() {
            this.timer.cancel();
            this.queue.clear();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        private void clean(Collection<DelayedCloseable> closeables) {
            Iterator<DelayedCloseable> iterator = closeables.iterator();
            while (iterator.hasNext()) {
                DelayedCloseable next = iterator.next();
                try {
                    iterator.remove();
                    LOG.warning("Unclosed (leaked?) stream detected: " + next.closeable.hashCode());
                    next.closeable.close();
                }
                catch (IOException | RuntimeException ex) {
                    LOG.warning("Unable to close (leaked?) stream: " + ex.getMessage());
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.io.DelayedCachedOutputStreamCleaner$DelayedCleanerImpl", DelayedCleanerImpl.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static final class DelayedCloseable
    implements Delayed {
        private final Closeable closeable;
        private final long expireAt;
        static final long serialVersionUID = -5311905228968517190L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DelayedCloseable(Closeable closeable, long delay) {
            this.closeable = closeable;
            this.expireAt = System.nanoTime() + delay;
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.expireAt, ((DelayedCloseable)o).expireAt);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expireAt - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        public int hashCode() {
            return Objects.hash(this.closeable);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DelayedCloseable other = (DelayedCloseable)obj;
            return Objects.equals(this.closeable, other.closeable);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.io.DelayedCachedOutputStreamCleaner$DelayedCloseable", DelayedCloseable.class, null, null);
        }
    }
}

