/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.persistence.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.data.AuthData;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.jdbc.WSDataSource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.wsspi.persistence.DatabaseStore;
import com.ibm.wsspi.persistence.InMemoryMappingFile;
import com.ibm.wsspi.persistence.PersistenceService;
import com.ibm.wsspi.persistence.PersistenceServiceUnit;
import com.ibm.wsspi.persistence.PersistenceServiceUnitConfig;
import com.ibm.wsspi.persistence.internal.PersistenceServiceUnitImpl;
import com.ibm.wsspi.resource.ResourceConfig;
import com.ibm.wsspi.resource.ResourceConfigFactory;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.persistence.databaseStore", service={DatabaseStore.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class DatabaseStoreImpl
implements DatabaseStore {
    private static final TraceComponent tc = Tr.register(DatabaseStoreImpl.class, (String)"persistenceService", (String)"com.ibm.wsspi.persistence.internal.PersistenceServiceMessages");
    private static final String EOLN = String.format("%n", new Object[0]);
    private static final String BATCH_PKG_PREFIX = "com.ibm.jbatch.container.persistence.jpa.";
    private static final String PERSISTENT_EXECUTOR_PKG_PREFIX = "com.ibm.ws.concurrent.persistent.";
    private final ServiceReference<?> authDataRef;
    private final ResourceFactory dataSourceFactory;
    private volatile boolean deactivated;
    private final LocalTransactionCurrent localTranCurrent;
    private final ResourceFactory nonJTADataSourceFactory;
    private final PersistenceService persistenceService;
    private final Map<String, ?> properties;
    private final String schema;
    private final String tablePrefix;
    private final String strategyConfig;
    final int schemaLength;
    final int tablePrefixLength;
    private final ResourceConfigFactory resourceConfigFactory;
    private final EmbeddableWebSphereTransactionManager tranMgr;
    static final long serialVersionUID = -5186737470846804979L;

    private SpecialEntitySet recognizeSpecialEntityPackage(String className) {
        if (className.startsWith(BATCH_PKG_PREFIX)) {
            return SpecialEntitySet.BATCH;
        }
        if (className.startsWith(PERSISTENT_EXECUTOR_PKG_PREFIX)) {
            return SpecialEntitySet.PERSISTENT_EXECUTOR;
        }
        return SpecialEntitySet.NONE;
    }

    @Activate
    public DatabaseStoreImpl(Map<String, ?> properties, @Reference(name="DataSourceFactory", target="(id=unbound)") ResourceFactory dataSourceFactory, @Reference LocalTransactionCurrent localTranCurrent, @Reference PersistenceService persistenceService, @Reference ResourceConfigFactory resourceConfigFactory, @Reference EmbeddableWebSphereTransactionManager tranMgr, @Reference(name="AuthData", service=AuthData.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC, target="(id=unbound)", policyOption=ReferencePolicyOption.GREEDY) ServiceReference<AuthData> authDataRef, @Reference(name="NonJTADataSourceFactory", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY, target="(id=unbound)") ResourceFactory nonJTADataSourceFactory) throws Exception {
        this.properties = properties;
        this.dataSourceFactory = dataSourceFactory;
        this.localTranCurrent = localTranCurrent;
        this.persistenceService = persistenceService;
        this.resourceConfigFactory = resourceConfigFactory;
        this.tranMgr = tranMgr;
        this.authDataRef = authDataRef;
        this.nonJTADataSourceFactory = nonJTADataSourceFactory;
        this.schema = (String)this.properties.get("schema");
        this.schemaLength = this.schema == null ? -1 : this.schema.length();
        this.tablePrefix = (String)this.properties.get("tablePrefix");
        this.tablePrefixLength = this.tablePrefix.length();
        this.strategyConfig = (String)this.properties.get("keyGenerationStrategy");
    }

    @Override
    public PersistenceServiceUnit createPersistenceServiceUnit(ClassLoader loader, String ... entityClassNames) throws Exception {
        return this.createPersistenceServiceUnit(loader, new HashMap(), entityClassNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public PersistenceServiceUnit createPersistenceServiceUnit(ClassLoader loader, Map properties, String ... entityClassNames) throws Exception {
        List<InMemoryMappingFile> inMemoryFiles;
        String ormFileContents;
        DataSource nonJTADataSource;
        Object configIsolationLevel;
        int codepoint;
        int i;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createPersistenceServiceUnit", (Object[])new Object[]{loader, Arrays.asList(entityClassNames)});
        }
        HashMap<String, Object> puProps = new HashMap<String, Object>();
        for (i = 0; i < this.tablePrefixLength; ++i) {
            codepoint = this.tablePrefix.codePointAt(i);
            if (Character.isLetterOrDigit(codepoint) || codepoint == 95) continue;
            Tr.error((TraceComponent)tc, (String)"ILLEGAL_IDENTIFIER_CWWKD0200E", (Object[])new Object[]{this.tablePrefix});
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"ILLEGAL_IDENTIFIER_CWWKD0200E", (Object[])new Object[]{this.tablePrefix}));
        }
        for (i = 0; i < this.schemaLength; ++i) {
            codepoint = this.schema.codePointAt(i);
            if (Character.isLetterOrDigit(codepoint) || codepoint == 95) continue;
            Tr.error((TraceComponent)tc, (String)"ILLEGAL_IDENTIFIER_CWWKD0201E", (Object[])new Object[]{this.schema});
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"ILLEGAL_IDENTIFIER_CWWKD0201E", (Object[])new Object[]{this.schema}));
        }
        if (this.properties.get("persistenceProperties.0.config.referenceType") != null) {
            for (String key : this.properties.keySet()) {
                if (!key.startsWith("persistenceProperties.0") || key.equals("persistenceProperties.0.config.referenceType")) continue;
                Object value = this.properties.get(key);
                key = key.substring(24);
                puProps.put(key, value);
            }
        }
        int isolationLevel = 2;
        if (properties.get("transactionIsolationLevel") != null && (configIsolationLevel = properties.get("transactionIsolationLevel")) instanceof Number) {
            int newisolationLevel = ((Number)configIsolationLevel).intValue();
            if (this.supportsIsolationLevel(newisolationLevel)) {
                isolationLevel = newisolationLevel;
            } else {
                throw new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"UNSUPPORTED_ISOLATION_LEVEL_CWWKD0293E", (Object[])new Object[]{isolationLevel}));
            }
        }
        ResourceConfig resourceInfo = this.resourceConfigFactory.createResourceConfig(DataSource.class.getName());
        resourceInfo.setSharingScope(0);
        resourceInfo.setIsolationLevel(isolationLevel);
        resourceInfo.setResAuthType(0);
        if (this.authDataRef != null) {
            String authDataId = (String)this.authDataRef.getProperty("id");
            resourceInfo.addLoginProperty("DefaultPrincipalMapping", authDataId.matches(".*(\\]/).*(\\[default-\\d*\\])") ? (String)this.authDataRef.getProperty("config.displayId") : authDataId);
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("DefaultPrincipalMapping " + resourceInfo), (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)("AuthData id = " + authDataId), (Object[])new Object[0]);
            }
        }
        SpecialEntitySet entitySet = entityClassNames.length == 0 ? SpecialEntitySet.NONE : this.recognizeSpecialEntityPackage(entityClassNames[0]);
        DataSource dataSource = (DataSource)this.dataSourceFactory.createResource((ResourceInfo)resourceInfo);
        String strategy = this.checkSupportedDBProductComputeStrategy(dataSource, entitySet);
        if (this.nonJTADataSourceFactory == null) {
            nonJTADataSource = null;
        } else {
            resourceInfo.setSharingScope(1);
            nonJTADataSource = (DataSource)this.nonJTADataSourceFactory.createResource((ResourceInfo)resourceInfo);
        }
        if (this.deactivated) {
            Tr.error((TraceComponent)tc, (String)"DEACTIVATED_CWWKD0202E", (Object[])new Object[0]);
            String errMsg = Tr.formatMessage((TraceComponent)tc, (String)"DEACTIVATED_CWWKD0202E", (Object[])new Object[0]);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createPersistenceServiceUnit", (Object)"deactivated");
            }
            throw new IllegalStateException(errMsg);
        }
        if (entitySet.equals((Object)SpecialEntitySet.PERSISTENT_EXECUTOR)) {
            ormFileContents = this.createOrmFileContentsForPersistentExecutor(strategy);
            inMemoryFiles = Collections.singletonList(new InMemoryMappingFile(ormFileContents.getBytes(StandardCharsets.UTF_8)));
        } else if (entitySet.equals((Object)SpecialEntitySet.BATCH)) {
            ormFileContents = this.createOrmFileContentsForBatch(entityClassNames, strategy);
            inMemoryFiles = Collections.singletonList(new InMemoryMappingFile(ormFileContents.getBytes(StandardCharsets.UTF_8)));
        } else {
            LinkedHashSet tableNames = (LinkedHashSet)properties.get("io.openliberty.persistence.internal.tableNames");
            String[] entityClassEntries = (String[])properties.get("io.openliberty.persistence.internal.entityClassInfo");
            InMemoryMappingFile ormFile = this.createOrmFile(this.schema, this.tablePrefix, tableNames, entityClassNames, entityClassEntries);
            inMemoryFiles = (List<InMemoryMappingFile>)properties.get("io.openliberty.persistence.internal.generatedEntities");
            if (ormFile != null) {
                if (inMemoryFiles == null) {
                    inMemoryFiles = Collections.singletonList(ormFile);
                } else {
                    inMemoryFiles = new ArrayList<InMemoryMappingFile>(inMemoryFiles);
                    inMemoryFiles.add(ormFile);
                }
            }
        }
        PersistenceServiceUnitConfig config = new PersistenceServiceUnitConfig();
        config.setClasses(Arrays.asList(entityClassNames));
        config.setConsumerLoader(loader);
        config.setProperties(puProps);
        if (inMemoryFiles != null) {
            config.setInMemoryMappingFiles(inMemoryFiles);
        }
        config.setJtaDataSource(dataSource);
        if (nonJTADataSource != null) {
            config.setNonJtaDataSource(nonJTADataSource);
        }
        if (this.deactivated) {
            Tr.error((TraceComponent)tc, (String)"DEACTIVATED_CWWKD0202E", (Object[])new Object[0]);
            String errMsg = Tr.formatMessage((TraceComponent)tc, (String)"DEACTIVATED_CWWKD0202E", (Object[])new Object[0]);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createPersistenceServiceUnit", (Object)"deactivated");
            }
            throw new IllegalStateException(errMsg);
        }
        PersistenceServiceUnit persistenceServiceUnit = this.persistenceService.createPersistenceServiceUnit(config);
        boolean successful = false;
        try {
            if (this.deactivated) {
                if (trace && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"createPersistenceServiceUnit", (Object)"deactivated");
                }
                String errMsg = Tr.formatMessage((TraceComponent)tc, (String)"DEACTIVATED_CWWKD0202E", (Object[])new Object[0]);
                throw new IllegalStateException(errMsg);
            }
            if (!entitySet.equals((Object)SpecialEntitySet.PERSISTENT_EXECUTOR) || entityClassNames.length != 1) {
                boolean createTables = (Boolean)this.properties.get("createTables");
                boolean dropTables = (Boolean)this.properties.get("dropTables");
                if (createTables || dropTables) {
                    CheckpointPhase.onRestore(() -> this.dropAndOrCreateTables(persistenceServiceUnit, createTables, dropTables));
                }
            }
            if (this.deactivated) {
                if (trace && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"createPersistenceServiceUnit", (Object)"deactivated");
                }
                String errMsg = Tr.formatMessage((TraceComponent)tc, (String)"DEACTIVATED_CWWKD0202E", (Object[])new Object[0]);
                throw new IllegalStateException(errMsg);
            }
            successful = true;
        }
        finally {
            if (!successful) {
                persistenceServiceUnit.close();
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createPersistenceServiceUnit", (Object)persistenceServiceUnit);
        }
        return persistenceServiceUnit;
    }

    private String checkSupportedDBProductComputeStrategy(DataSource dataSource, SpecialEntitySet entitySet) throws Exception {
        boolean isAutoStrategy = "AUTO".equals(this.strategyConfig);
        AtomicReference<String> strategy = new AtomicReference<String>(isAutoStrategy ? "CHECKPOINT" : this.strategyConfig);
        CheckpointPhase.onRestore(() -> {
            String dbProductName = this.getDatabaseProductName((WSDataSource)dataSource).toLowerCase();
            if (dbProductName.contains("informix") || dbProductName.startsWith("ids/")) {
                throw new UnsupportedOperationException(dbProductName);
            }
            if (isAutoStrategy) {
                String autoStrategy = dbProductName.contains("oracle") ? "SEQUENCE" : (dbProductName.contains("adaptive server") || dbProductName.contains("sybase") ? "TABLE" : "IDENTITY");
                strategy.set(autoStrategy);
            }
        });
        String result = strategy.get();
        if ((entitySet == SpecialEntitySet.BATCH || entitySet == SpecialEntitySet.PERSISTENT_EXECUTOR) && "CHECKPOINT".equals(result)) {
            throw new UnsupportedOperationException();
        }
        return result;
    }

    @ManualTrace
    protected String createOrmFileContentsForPersistentExecutor(String strategy) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createOrmFileContentsForPersistentExecutor", (Object[])new Object[0]);
        }
        StringBuilder orm = new StringBuilder(4 * this.tablePrefixLength + this.schemaLength + 703).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(EOLN).append("<entity-mappings xmlns=\"http://xmlns.jcp.org/xml/ns/persistence/orm\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/persistence/orm http://xmlns.jcp.org/xml/ns/persistence/orm_2_1.xsd\" version=\"2.1\">").append(EOLN);
        if (this.schemaLength >= 0) {
            orm.append(" <schema>").append(this.schema).append("</schema>").append(EOLN);
        }
        orm.append(" <entity class=\"com.ibm.ws.concurrent.persistent.db.Partition\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("PART\">").append(EOLN).append("   <unique-constraint>").append(EOLN).append("    <column-name>EXECUTOR</column-name>").append(EOLN).append("    <column-name>HOSTNAME</column-name>").append(EOLN).append("    <column-name>LSERVER</column-name>").append(EOLN).append("    <column-name>USERDIR</column-name>").append(EOLN).append("   </unique-constraint>").append(EOLN).append("  </table>").append(EOLN);
        if (!"IDENTITY".equals(strategy)) {
            orm.append("  <attributes>").append(EOLN).append("   <id name=\"ID\">").append(EOLN).append("    <column name=\"ID\" nullable=\"false\"/>").append(EOLN).append("    <generated-value generator=\"IDGEN\" strategy=\"").append(strategy).append("\"/>").append(EOLN);
            if ("TABLE".equals(strategy)) {
                orm.append("    <table-generator name=\"IDGEN\" table=\"").append(this.tablePrefix).append("GEN\"");
                if (this.schema != null) {
                    orm.append(" schema=\"").append(this.schema).append('\"');
                }
                orm.append("/>").append(EOLN);
            } else {
                orm.append("    <sequence-generator name=\"IDGEN\" sequence-name=\"").append(this.tablePrefix).append("SEQ\"/>").append(EOLN);
            }
            orm.append("   </id>").append(EOLN).append("  </attributes>").append(EOLN);
        }
        orm.append(" </entity>").append(EOLN).append(" <entity class=\"com.ibm.ws.concurrent.persistent.db.Property\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("PROP\"/>").append(EOLN).append(" </entity>").append(EOLN).append(" <entity class=\"com.ibm.ws.concurrent.persistent.db.Task\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("TASK\"/>").append(EOLN);
        if (!"IDENTITY".equals(strategy)) {
            orm.append("  <attributes>").append(EOLN).append("   <id name=\"ID\">").append(EOLN).append("    <column name=\"ID\" nullable=\"false\"/>").append(EOLN).append("    <generated-value generator=\"IDGEN\" strategy=\"").append(strategy).append("\"/>").append(EOLN);
            if ("TABLE".equals(strategy)) {
                orm.append("    <table-generator name=\"IDGEN\" table=\"").append(this.tablePrefix).append("GEN\"");
                if (this.schema != null) {
                    orm.append(" schema=\"").append(this.schema).append('\"');
                }
                orm.append("/>").append(EOLN);
            } else {
                orm.append("    <sequence-generator name=\"IDGEN\" sequence-name=\"").append(this.tablePrefix).append("SEQ\"/>").append(EOLN);
            }
            orm.append("   </id>").append(EOLN).append("  </attributes>").append(EOLN);
        }
        orm.append(" </entity>").append(EOLN).append("</entity-mappings>").append(EOLN);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"orm.xml generated for persistent executor", (Object[])new Object[]{orm});
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createOrmFileContentsForPersistentExecutor");
        }
        return orm.toString();
    }

    @ManualTrace
    protected String createOrmFileContentsForBatch(String[] entityClassNames, String strategy) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createOrmFileContentsForBatch", (Object[])new Object[0]);
        }
        StringBuilder orm = new StringBuilder(4 * this.tablePrefixLength + this.schemaLength + 2000).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(EOLN).append("<entity-mappings xmlns=\"http://xmlns.jcp.org/xml/ns/persistence/orm\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/persistence/orm http://xmlns.jcp.org/xml/ns/persistence/orm_2_1.xsd\" version=\"2.1\">").append(EOLN);
        if (this.schemaLength >= 0) {
            orm.append(" <schema>").append(this.schema).append("</schema>").append(EOLN);
        }
        orm.append(" <entity class=\"com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("JOBEXECUTION\">").append(EOLN).append("    <index name=\"").append(this.tablePrefix).append("JE_FKINSTANCEID_IX\" column-list=\"FK_JOBINSTANCEID\" unique=\"false\"/>").append(EOLN).append("  </table>").append(EOLN).append("  <inheritance strategy=\"SINGLE_TABLE\"/>").append(EOLN).append("  <class-extractor class=\"com.ibm.jbatch.container.persistence.jpa.JobExecutionEntityExtractor\"/>").append(EOLN);
        if (!"IDENTITY".equals(strategy)) {
            orm.append("  <attributes>").append(EOLN).append("   <id name=\"jobExecId\">").append(EOLN).append("    <column name=\"JOBEXECID\" nullable=\"false\"/>").append(EOLN).append("    <generated-value generator=\"JOBEXECIDGEN\" strategy=\"").append(strategy).append("\"/>").append(EOLN);
            if ("TABLE".equals(strategy)) {
                orm.append("    <table-generator name=\"JOBEXECIDGEN\" table=\"").append(this.tablePrefix).append("GEN\"");
                if (this.schema != null) {
                    orm.append(" schema=\"").append(this.schema).append('\"');
                }
                orm.append("/>").append(EOLN);
            } else {
                orm.append("    <sequence-generator name=\"JOBEXECIDGEN\" sequence-name=\"").append(this.tablePrefix).append("SEQ\"/>").append(EOLN);
            }
            orm.append("   </id>").append(EOLN).append("  </attributes>").append(EOLN);
        }
        orm.append(" </entity>").append(EOLN);
        if (Arrays.asList(entityClassNames).contains("com.ibm.jbatch.container.persistence.jpa.JobExecutionEntityV2") || Arrays.asList(entityClassNames).contains("com.ibm.jbatch.container.persistence.jpa.JobExecutionEntityV3")) {
            orm.append(" <entity class=\"com.ibm.jbatch.container.persistence.jpa.JobExecutionEntityV2\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("JOBEXECUTION\">").append(EOLN).append("  <index name=\"").append(this.tablePrefix).append("JE_FKINSTANCEID_IX\" column-list=\"FK_JOBINSTANCEID\" unique=\"false\"/>").append(EOLN).append("  </table>").append(EOLN).append("  <attributes>").append(EOLN).append("   <element-collection name=\"jobParameterElements\" target-class=\"com.ibm.jbatch.container.persistence.jpa.JobParameter\">").append(EOLN).append("    <collection-table name=\"").append(this.tablePrefix).append("JOBPARAMETER\">").append(EOLN).append("     <join-column name=\"FK_JOBEXECID\"/>").append(EOLN).append("     <index name=\"").append(this.tablePrefix).append("JP_FKJOBEXECID_IX\" column-list=\"FK_JOBEXECID\" unique=\"false\"/>").append(EOLN).append("    </collection-table>").append(EOLN).append("   </element-collection>").append(EOLN).append("  </attributes>").append(EOLN).append(" </entity>").append(EOLN);
        }
        if (Arrays.asList(entityClassNames).contains("com.ibm.jbatch.container.persistence.jpa.JobExecutionEntityV3")) {
            orm.append(" <entity class=\"com.ibm.jbatch.container.persistence.jpa.JobExecutionEntityV3\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("JOBEXECUTION\">").append(EOLN).append("  </table>").append(EOLN).append(" </entity>").append(EOLN);
        }
        orm.append(" <entity class=\"com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("JOBINSTANCE\"/>").append(EOLN).append("  <inheritance strategy=\"SINGLE_TABLE\"/>").append(EOLN).append("  <class-extractor class=\"com.ibm.jbatch.container.persistence.jpa.JobInstanceEntityExtractor\"/>").append(EOLN);
        if (!"IDENTITY".equals(strategy)) {
            orm.append("  <attributes>").append(EOLN).append("   <id name=\"instanceId\">").append(EOLN).append("    <column name=\"JOBINSTANCEID\" nullable=\"false\"/>").append(EOLN).append("    <generated-value generator=\"JOBINSTANCEIDGEN\" strategy=\"").append(strategy).append("\"/>").append(EOLN);
            if ("TABLE".equals(strategy)) {
                orm.append("    <table-generator name=\"JOBINSTANCEIDGEN\" table=\"").append(this.tablePrefix).append("GEN\"");
                if (this.schema != null) {
                    orm.append(" schema=\"").append(this.schema).append('\"');
                }
                orm.append("/>").append(EOLN);
            } else {
                orm.append("    <sequence-generator name=\"JOBINSTANCEIDGEN\" sequence-name=\"").append(this.tablePrefix).append("SEQ\"/>").append(EOLN);
            }
            orm.append("   </id>").append(EOLN).append("  </attributes>").append(EOLN);
        }
        orm.append(" </entity>").append(EOLN);
        if (Arrays.asList(entityClassNames).contains("com.ibm.jbatch.container.persistence.jpa.JobInstanceEntityV2")) {
            orm.append(" <entity class=\"com.ibm.jbatch.container.persistence.jpa.JobInstanceEntityV2\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("JOBINSTANCE\"/>").append(EOLN).append(" </entity>").append(EOLN);
        }
        if (Arrays.asList(entityClassNames).contains("com.ibm.jbatch.container.persistence.jpa.JobInstanceEntityV3")) {
            orm.append(" <entity class=\"com.ibm.jbatch.container.persistence.jpa.JobInstanceEntityV2\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("JOBINSTANCE\"/>").append(EOLN).append(" </entity>").append(EOLN).append(" <entity class=\"com.ibm.jbatch.container.persistence.jpa.JobInstanceEntityV3\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("JOBINSTANCE\"/>").append(EOLN).append("  <attributes>").append(EOLN).append("   <element-collection name=\"groupNames\" target-class=\"java.lang.String\">").append(EOLN).append("    <collection-table name=\"").append(this.tablePrefix).append("GROUPASSOCIATION\">").append(EOLN).append("     <join-column name=\"FK_JOBINSTANCEID\"/>").append(EOLN).append("     <index name=\"").append(this.tablePrefix).append("GA_FKINSTANCEID_IX\" column-list=\"FK_JOBINSTANCEID\" unique=\"false\"/>").append(EOLN).append("    </collection-table>").append(EOLN).append("   </element-collection>").append(EOLN).append("  </attributes>").append(EOLN).append(" </entity>").append(EOLN);
        }
        orm.append(" <entity class=\"com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("STEPTHREADEXECUTION\">").append(EOLN).append("   <unique-constraint>").append(EOLN).append("    <column-name>FK_JOBEXECID</column-name>").append(EOLN).append("    <column-name>STEPNAME</column-name>").append(EOLN).append("    <column-name>PARTNUM</column-name>").append(EOLN).append("   </unique-constraint>").append(EOLN).append(" <index name=\"").append(this.tablePrefix).append("STE_FKJOBEXECID_IX\" column-list=\"FK_JOBEXECID\" unique=\"false\"/>").append(EOLN).append(" <index name=\"").append(this.tablePrefix).append("STE_FKTLSTEPEID_IX\" column-list=\"FK_TOPLVL_STEPEXECID\" unique=\"false\"/>").append(EOLN).append("  </table>").append(EOLN);
        if (!"IDENTITY".equals(strategy)) {
            orm.append("  <attributes>").append(EOLN).append("   <id name=\"stepExecutionId\">").append(EOLN).append("    <column name=\"STEPEXECID\" nullable=\"false\"/>").append(EOLN).append("    <generated-value generator=\"STEPEXECIDGEN\" strategy=\"").append(strategy).append("\"/>").append(EOLN);
            if ("TABLE".equals(strategy)) {
                orm.append("    <table-generator name=\"STEPEXECIDGEN\" table=\"").append(this.tablePrefix).append("GEN\"");
                if (this.schema != null) {
                    orm.append(" schema=\"").append(this.schema).append('\"');
                }
                orm.append("/>").append(EOLN);
            } else {
                orm.append("    <sequence-generator name=\"STEPEXECIDGEN\" sequence-name=\"").append(this.tablePrefix).append("SEQ\"/>").append(EOLN);
            }
            orm.append("   </id>").append(EOLN).append("  </attributes>").append(EOLN);
        }
        orm.append(" </entity>").append(EOLN);
        if (Arrays.asList(entityClassNames).contains("com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntityV2")) {
            orm.append(" <entity class=\"com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntityV2\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("STEPTHREADEXECUTION\">").append(EOLN).append("  </table>").append(EOLN).append(" </entity>").append(EOLN);
        }
        orm.append(" <entity class=\"com.ibm.jbatch.container.persistence.jpa.StepThreadInstanceEntity\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("STEPTHREADINSTANCE\">").append(EOLN).append("   <index name=\"").append(this.tablePrefix).append("STI_FKINSTANCEID_IX\" column-list=\"FK_JOBINSTANCEID\" unique=\"false\"/>").append(EOLN).append("   <index name=\"").append(this.tablePrefix).append("STI_FKLATEST_SEI_IX\" column-list=\"FK_LATEST_STEPEXECID\" unique=\"false\"/>").append(EOLN).append("  </table>").append(EOLN).append(" </entity>").append(EOLN);
        if (Arrays.asList(entityClassNames).contains("com.ibm.jbatch.container.persistence.jpa.RemotablePartitionEntity")) {
            orm.append(" <entity class=\"com.ibm.jbatch.container.persistence.jpa.RemotablePartitionEntity\">").append(EOLN).append("  <table name=\"").append(this.tablePrefix).append("REMOTABLEPARTITION\">").append(EOLN).append("  </table>").append(EOLN).append(" </entity>").append(EOLN);
        }
        orm.append("</entity-mappings>").append(EOLN);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"orm.xml generated for batch", (Object[])new Object[]{orm});
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createOrmFileContentsForBatch");
        }
        return orm.toString();
    }

    protected InMemoryMappingFile createOrmFile(String schemaName, String tablePrefix, LinkedHashSet<String> tableNames, String[] entityClassNames, String[] entityClassEntries) {
        return !(entityClassNames != null && entityClassNames.length != 0 || entityClassEntries != null && entityClassEntries.length != 0) ? null : new InMemoryMappingFile(this.createOrm(schemaName, tablePrefix, tableNames, entityClassNames, entityClassEntries).getBytes(StandardCharsets.UTF_8));
    }

    protected String createOrm(String schemaName, String tablePrefix, LinkedHashSet<String> tableNames, String[] entityClassNames, String[] entityClassEntries) {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + EOLN).append("<entity-mappings xmlns=\"http://xmlns.jcp.org/xml/ns/persistence/orm\"").append("                 xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append("                 xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/persistence/orm http://xmlns.jcp.org/xml/ns/persistence/orm_2_1.xsd\"").append("                 version=\"2.1\">").append(EOLN);
        if (schemaName != null && !schemaName.trim().isEmpty()) {
            builder.append(" <schema>" + schemaName + "</schema>" + EOLN);
        }
        String string = tablePrefix = tablePrefix == null ? "" : tablePrefix.trim();
        if (entityClassNames != null) {
            int i = 0;
            for (String tableName : tableNames) {
                builder.append(" <entity class=" + this.enquote(entityClassNames[i++]) + ">" + EOLN).append("  <table name=" + this.enquote(tablePrefix + tableName) + "/>" + EOLN).append(" </entity>" + EOLN);
            }
        }
        if (entityClassEntries != null) {
            for (String entityClassEntry : entityClassEntries) {
                builder.append(entityClassEntry);
            }
        }
        builder.append("</entity-mappings>" + EOLN);
        return builder.toString();
    }

    protected String parseSimpleName(String entityClassName) {
        return entityClassName.substring(entityClassName.lastIndexOf(".") + 1);
    }

    protected String enquote(String s) {
        return "\"" + s + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropAndOrCreateTables(PersistenceServiceUnit persistenceServiceUnit, boolean createTables, boolean dropTables) throws Exception {
        LocalTransactionCurrent localTranCurrent = this.localTranCurrent;
        LocalTransactionCoordinator suspendedLTC = localTranCurrent.suspend();
        EmbeddableWebSphereTransactionManager tranMgr = this.tranMgr;
        Transaction suspendedTran = suspendedLTC == null ? tranMgr.suspend() : null;
        boolean psuIsPUSI = persistenceServiceUnit instanceof PersistenceServiceUnitImpl;
        PersistenceServiceUnit persistenceServiceUnit2 = persistenceServiceUnit;
        synchronized (persistenceServiceUnit2) {
            try {
                if (psuIsPUSI) {
                    ((PersistenceServiceUnitImpl)persistenceServiceUnit).setTransactionManager((TransactionManager)tranMgr);
                }
                if (createTables) {
                    if (dropTables) {
                        persistenceServiceUnit.dropAndCreateTables();
                    } else {
                        persistenceServiceUnit.createTables();
                    }
                } else if (dropTables) {
                    persistenceServiceUnit.dropTables();
                }
            }
            finally {
                if (psuIsPUSI) {
                    ((PersistenceServiceUnitImpl)persistenceServiceUnit).setTransactionManager(null);
                }
                if (suspendedTran != null) {
                    tranMgr.resume(suspendedTran);
                } else if (suspendedLTC != null) {
                    localTranCurrent.resume(suspendedLTC);
                }
            }
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) throws Exception {
        this.deactivated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseProductName(WSDataSource dataSource) throws Exception {
        Class<DatabaseStoreImpl> clazz = DatabaseStoreImpl.class;
        synchronized (DatabaseStoreImpl.class) {
            String dbProductName = dataSource.getDatabaseProductName();
            if (dbProductName == null) {
                LocalTransactionCurrent localTranCurrent = this.localTranCurrent;
                LocalTransactionCoordinator suspendedLTC = localTranCurrent.suspend();
                EmbeddableWebSphereTransactionManager tranMgr = this.tranMgr;
                Transaction suspendedTran = suspendedLTC == null ? tranMgr.suspend() : null;
                boolean tranStarted = false;
                try {
                    tranMgr.begin();
                    tranStarted = true;
                    try (Connection con = dataSource.getConnection();){
                        dbProductName = con.getMetaData().getDatabaseProductName();
                    }
                }
                finally {
                    try {
                        if (tranStarted) {
                            tranMgr.commit();
                        }
                    }
                    finally {
                        if (suspendedTran != null) {
                            tranMgr.resume(suspendedTran);
                        } else if (suspendedLTC != null) {
                            localTranCurrent.resume(suspendedLTC);
                        }
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return dbProductName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean supportsIsolationLevel(int isolationLevel) throws Exception {
        ResourceConfig tempResourceInfo = this.resourceConfigFactory.createResourceConfig(DataSource.class.getName());
        tempResourceInfo.setSharingScope(0);
        tempResourceInfo.setIsolationLevel(2);
        tempResourceInfo.setResAuthType(0);
        if (this.authDataRef != null) {
            String authDataId = (String)this.authDataRef.getProperty("id");
            tempResourceInfo.addLoginProperty("DefaultPrincipalMapping", authDataId.matches(".*(\\]/).*(\\[default-\\d*\\])") ? (String)this.authDataRef.getProperty("config.displayId") : authDataId);
        }
        DataSource tempDataSource = (DataSource)this.dataSourceFactory.createResource((ResourceInfo)tempResourceInfo);
        LocalTransactionCurrent localTranCurrent = this.localTranCurrent;
        LocalTransactionCoordinator suspendedLTC = localTranCurrent.suspend();
        EmbeddableWebSphereTransactionManager tranMgr = this.tranMgr;
        Transaction suspendedTran = suspendedLTC == null ? tranMgr.suspend() : null;
        boolean tranStarted = false;
        try {
            boolean bl;
            tranMgr.begin();
            tranStarted = true;
            Connection con = tempDataSource.getConnection();
            try {
                bl = con.getMetaData().supportsTransactionIsolationLevel(isolationLevel);
            }
            catch (Throwable throwable) {
                con.close();
                throw throwable;
            }
            con.close();
            return bl;
        }
        finally {
            try {
                if (tranStarted) {
                    tranMgr.rollback();
                }
            }
            finally {
                if (suspendedTran != null) {
                    tranMgr.resume(suspendedTran);
                } else if (suspendedLTC != null) {
                    localTranCurrent.resume(suspendedLTC);
                }
            }
        }
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getTablePrefix() {
        return this.tablePrefix;
    }

    private static enum SpecialEntitySet {
        BATCH,
        PERSISTENT_EXECUTOR,
        NONE;

    }
}

