/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.lifecycle;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.messaging.lifecycle.Singleton;
import com.ibm.ws.messaging.lifecycle.SingletonsReady;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.messaging.lifecycle.singletons"}, property={"service.vendor=IBM"})
public class SingletonMonitor
implements Introspector {
    public static final TraceComponent tc = Tr.register(SingletonMonitor.class);
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final int version = counter.incrementAndGet();
    private final ConfigurationAdmin configAdmin;
    private volatile Set<String> declaredSingletons;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> pendingSingletons = new ArrayList<String>();
    private final List<String> realizedSingletons = new ArrayList<String>();
    private int singletonsReadyBindCount;
    private int singletonsReadyUnbindCount;

    @Activate
    public SingletonMonitor(@Reference(name="configAdmin") ConfigurationAdmin configAdmin, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
        this.configAdmin = configAdmin;
        this.declaredSingletons = Collections.unmodifiableSet(this.findDeclarations(properties));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Modified
    public synchronized void modified(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"modified", (Object[])new Object[0]);
        }
        Set<String> oldSet = this.declaredSingletons;
        Set<String> newSet = this.findDeclarations(properties);
        if (newSet.equals(oldSet)) {
            return;
        }
        this.declaredSingletons = newSet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            TreeSet<String> removed = new TreeSet<String>(oldSet);
            TreeSet<String> added = new TreeSet<String>(newSet);
            TreeSet<String> unmodified = new TreeSet<String>(oldSet);
            removed.removeAll(newSet);
            added.removeAll(oldSet);
            unmodified.removeAll(removed);
            if (unmodified.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Singleton declarations unmodified:", (Object[])new Object[]{unmodified});
            }
            if (removed.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Singleton declarations removed:", (Object[])new Object[]{removed});
            }
            if (added.size() > 0) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Singleton declarations added:", (Object[])new Object[]{added});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"modified");
        }
    }

    @Deactivate
    public void deactivate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[0]);
            Tr.exit((Object)this, (TraceComponent)tc, (String)"deactivate");
        }
    }

    private Set<String> findDeclarations(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"findDeclaredSingletons", (Object[])((Object[])properties.get("singletonDeclarations")));
        }
        Set result = Optional.of(properties).map(props -> props.get("singletonDeclarations")).filter(String[].class::isInstance).map(String[].class::cast).map(Stream::of).orElse(Stream.empty()).map(this::servicePidToConfigId).filter(Objects::nonNull).collect(TreeSet::new, Set::add, Set::addAll);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"findDeclaredSingletons", (Object)result);
        }
        return Collections.unmodifiableSet(result);
    }

    private String servicePidToConfigId(String servicePid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"retrieveId", (Object[])new Object[]{servicePid});
        }
        try {
            Object[] configs = this.configAdmin.listConfigurations("(service.pid=" + servicePid + ")");
            if (configs == null) {
                throw new IllegalStateException("No configs found matching servicePid=" + servicePid);
            }
            if (configs.length > 1) {
                throw new IllegalStateException("Non unique servicePid=" + servicePid + " matched configs=" + Arrays.toString(configs));
            }
            String id = (String)configs[0].getProperties().get("id");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"retrieveId", (Object)id);
            }
            return id;
        }
        catch (Exception e) {
            this.errors.add("" + e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"retrieveId", (Object[])new Object[]{e});
            }
            return null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void addPendingSingleton(ServiceReference<Singleton> ref) {
        String type = (String)ref.getProperty("type");
        this.pendingSingletons.add(type);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Pending Singleton added: %s", type), (Object[])new Object[0]);
        }
    }

    synchronized void removePendingSingleton(ServiceReference<Singleton> ref) {
        String type = (String)ref.getProperty("type");
        this.pendingSingletons.remove(type);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Pending Singleton removed: %s", type), (Object[])new Object[0]);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void addRealizedSingleton(Singleton singleton, Map<String, Object> properties) {
        String type = (String)properties.get("type");
        this.realizedSingletons.add(type);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Realized Singleton added: %s", type), (Object[])new Object[0]);
        }
    }

    synchronized void removeRealizedSingleton(Singleton singleton, Map<String, Object> properties) {
        String type = (String)properties.get("type");
        this.realizedSingletons.remove(type);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)String.format("Realized Singleton removed: %s", type), (Object[])new Object[0]);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void addSingletonsReady(SingletonsReady ready, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"addSingletonsReady", (Object[])new Object[]{ready});
        }
        this.modified(properties);
        ++this.singletonsReadyBindCount;
        TreeSet<String> pending = new TreeSet<String>(this.pendingSingletons);
        TreeSet<String> realized = new TreeSet<String>(this.realizedSingletons);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Declared singletons: " + this.declaredSingletons), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Pending singletons:  " + pending), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Realized singletons: " + realized), (Object[])new Object[0]);
        }
        if (this.declaredSingletons.equals(realized)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"addSingletonsReady");
            }
            return;
        }
        if (this.singletonsReadyBindCount > this.singletonsReadyUnbindCount + 1) {
            this.errors.clear();
        } else {
            TreeSet<String> missing = new TreeSet<String>(this.declaredSingletons);
            TreeSet<String> blocked = pending;
            TreeSet<String> extra = realized;
            blocked.removeAll(realized);
            missing.removeAll(realized);
            extra.removeAll(this.declaredSingletons);
            this.errors.add("addSingletonsReady: singleton mismatch detected\n\tmissing: " + missing + "\n\tblocked: " + blocked + "\n\textra:   " + extra);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"addSingletonsReady");
        }
    }

    synchronized void removeSingletonsReady(SingletonsReady ready) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"removeSingletonsReady", (Object[])new Object[]{ready});
        }
        ++this.singletonsReadyUnbindCount;
        if (this.singletonsReadyBindCount > this.singletonsReadyUnbindCount) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"removeSingletonsReady (out of order)");
            }
            return;
        }
        this.errors.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"removeSingletonsReady (in order)");
        }
    }

    public String toString() {
        return SingletonMonitor.class.getName() + "#" + this.version;
    }

    public String getIntrospectorName() {
        return "Messaging" + this.getClass().getSimpleName();
    }

    public String getIntrospectorDescription() {
        return this.getIntrospectorName().replaceAll(".", "=") + "\nList the declared (D), pending (P), and realized (R) messaging singletons.\nMessaging cannot start until all the declared singletons become available (i.e. are realized).";
    }

    public synchronized void introspect(PrintWriter out) throws Exception {
        out.println();
        out.println("=Detected Singletons=");
        ((Stream)Stream.concat(Stream.concat(this.declaredSingletons.stream(), this.realizedSingletons.stream()), this.pendingSingletons.stream()).sorted().distinct().sequential()).peek(s -> out.print('[')).peek(s -> out.print(this.declaredSingletons.contains(s) ? (char)'D' : (char)' ')).peek(s -> out.print((char)(this.realizedSingletons.contains(s) ? 82 : (this.pendingSingletons.contains(s) ? 80 : 32)))).peek(s -> out.print("] ")).forEach(out::println);
        out.println();
        out.println("=SingletonsReady tracking=");
        out.println("Bind calls:   " + this.singletonsReadyBindCount);
        out.println("Unbind calls: " + this.singletonsReadyUnbindCount);
        out.println();
        out.println("=Errors=");
        this.errors.forEach(out::println);
        if (this.errors.isEmpty()) {
            out.println("No errors recorded.");
        }
    }
}

