/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpStatusConverter;
import javax.annotation.Nullable;

public final class HttpSpanStatusExtractor<REQUEST, RESPONSE>
implements SpanStatusExtractor<REQUEST, RESPONSE> {
    private final HttpCommonAttributesGetter<? super REQUEST, ? super RESPONSE> getter;
    private final HttpStatusConverter statusConverter;

    public static <REQUEST, RESPONSE> SpanStatusExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<? super REQUEST, ? super RESPONSE> getter) {
        return new HttpSpanStatusExtractor<REQUEST, RESPONSE>(getter, HttpStatusConverter.CLIENT);
    }

    public static <REQUEST, RESPONSE> SpanStatusExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<? super REQUEST, ? super RESPONSE> getter) {
        return new HttpSpanStatusExtractor<REQUEST, RESPONSE>(getter, HttpStatusConverter.SERVER);
    }

    private HttpSpanStatusExtractor(HttpCommonAttributesGetter<? super REQUEST, ? super RESPONSE> getter, HttpStatusConverter statusConverter) {
        this.getter = getter;
        this.statusConverter = statusConverter;
    }

    @Override
    public void extract(SpanStatusBuilder spanStatusBuilder, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        StatusCode statusCodeObj;
        Integer statusCode;
        if (response != null && (statusCode = this.getter.statusCode(request, response, error)) != null && (statusCodeObj = this.statusConverter.statusFromHttpStatus(statusCode)) == StatusCode.ERROR) {
            spanStatusBuilder.setStatus(statusCodeObj);
            return;
        }
        SpanStatusExtractor.getDefault().extract(spanStatusBuilder, request, response, error);
    }
}

