/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.tai.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.tai.TAIConfig;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TAIConfigImpl
implements TAIConfig {
    private static final TraceComponent tc = Tr.register(TAIConfigImpl.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.tai.internal.resources.TAIMessages");
    static final String KEY_INVOKE_FOR_UNPROTECTED_URI = "invokeForUnprotectedURI";
    static final String KEY_INVOKE_FOR_FORM_LOGIN = "invokeForFormLogin";
    static final String KEY_FAIL_OVER_TO_APP_AUTH_TYPE = "failOverToAppAuthType";
    public static final String KEY_DISABLE_LTPA_COOKIE = "disableLtpaCookie";
    public static final String KEY_INITIALIZE_AT_FIRST_REQUEST = "initializeAtFirstRequest";
    private boolean failOverToAppAuthType = false;
    private boolean invokeForUnprotectedURI = false;
    private boolean invokeForFormLogin = false;
    private boolean disableLtpaCookie = false;
    private boolean initializeAtFirstRequest = false;
    private String id = null;
    static final String KEY_ID = "id";
    static final long serialVersionUID = -1688343594611297380L;

    public TAIConfigImpl(Map<String, Object> props) {
        this.processConfig(props);
    }

    void processConfig(Map<String, Object> props) {
        if (props == null) {
            return;
        }
        this.id = (String)props.get(KEY_ID);
        this.invokeForUnprotectedURI = (Boolean)props.get(KEY_INVOKE_FOR_UNPROTECTED_URI);
        this.invokeForFormLogin = (Boolean)props.get(KEY_INVOKE_FOR_FORM_LOGIN);
        this.failOverToAppAuthType = (Boolean)props.get(KEY_FAIL_OVER_TO_APP_AUTH_TYPE);
        this.disableLtpaCookie = (Boolean)props.get(KEY_DISABLE_LTPA_COOKIE);
        this.initializeAtFirstRequest = (Boolean)props.get(KEY_INITIALIZE_AT_FIRST_REQUEST);
        this.printTaiConfig();
    }

    public void printTaiConfig() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TAI configuration ID: " + this.id), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("  invokeForUnprotectedURI=" + this.invokeForUnprotectedURI + " invokeForFormLogin=" + this.invokeForFormLogin + " failOverToAppAuthType=" + this.failOverToAppAuthType + " disableLtpaCookie=" + this.disableLtpaCookie), (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isInvokeForFormLogin() {
        return this.invokeForFormLogin;
    }

    @Override
    public boolean isFailOverToAppAuthType() {
        return this.failOverToAppAuthType;
    }

    @Override
    public boolean isInvokeForUnprotectedURI() {
        return this.invokeForUnprotectedURI;
    }

    @Override
    public boolean isDisableLtpaCookie() {
        return this.disableLtpaCookie;
    }

    @Override
    public boolean isInitializeAtFirstRequest() {
        return this.initializeAtFirstRequest;
    }
}

