/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.ltpakeyutil;

import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.crypto.ltpakeyutil.LTPACrypto;
import java.security.MessageDigest;

public class KeyEncryptor {
    private static final boolean fipsEnabled = CryptoUtils.isFips140_3Enabled();
    private static final int size = fipsEnabled ? 32 : 24;
    private static final String CIPHER = CryptoUtils.getCipher();
    private final byte[] key;

    public KeyEncryptor(byte[] password) throws Exception {
        MessageDigest md = MessageDigest.getInstance(CryptoUtils.MESSAGE_DIGEST_ALGORITHM);
        byte[] digest = md.digest(password);
        this.key = new byte[size];
        System.arraycopy(digest, 0, this.key, 0, digest.length);
        if (!fipsEnabled) {
            this.key[20] = 0;
            this.key[21] = 0;
            this.key[22] = 0;
            this.key[23] = 0;
        }
    }

    public byte[] decrypt(byte[] encryptedKey) throws Exception {
        return LTPACrypto.decrypt(encryptedKey, this.key, CIPHER);
    }

    public byte[] encrypt(byte[] key) throws Exception {
        return LTPACrypto.encrypt(key, this.key, CIPHER);
    }
}

