/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.token.auth;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.ssl.SecuritySSLUtils;
import com.ibm.ws.ssl.KeyStoreService;
import io.openliberty.security.oidcclientcore.exceptions.PrivateKeyJwtAuthException;
import io.openliberty.security.oidcclientcore.exceptions.PrivateKeyJwtAuthMissingKeyException;
import io.openliberty.security.oidcclientcore.exceptions.TokenEndpointAuthMethodSettingsException;
import io.openliberty.security.oidcclientcore.token.TokenRequestor;
import io.openliberty.security.oidcclientcore.token.auth.TokenEndpointAuthMethod;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.keys.X509Util;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={PrivateKeyJwtAuthMethod.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE)
public class PrivateKeyJwtAuthMethod
extends TokenEndpointAuthMethod {
    public static final TraceComponent tc = Tr.register(PrivateKeyJwtAuthMethod.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    private static final String KEY_KEYSTORE_SERVICE = "keyStoreService";
    protected static volatile KeyStoreService keyStoreService;
    public static final String AUTH_METHOD = "private_key_jwt";
    private static final float EXP_TIME_IN_MINUTES = 5.0f;
    private String configurationId;
    private String clientId;
    private String tokenEndpoint;
    private String clientAssertionSigningAlgorithm;
    private String trustStoreRef;
    private String sslRef;
    private String keyAliasName;
    private final SecuritySSLUtils sslUtils = new SecuritySSLUtils();
    static final long serialVersionUID = 3825500917159512197L;

    @Reference(name="keyStoreService", policy=ReferencePolicy.DYNAMIC)
    public void setKeyStoreService(KeyStoreService keyStoreServiceSvc) {
        keyStoreService = keyStoreServiceSvc;
    }

    public void unsetKeyStoreService(KeyStoreService keyStoreServiceSvc) {
        keyStoreService = null;
    }

    @Deprecated
    public PrivateKeyJwtAuthMethod() {
    }

    public PrivateKeyJwtAuthMethod(String configurationId, String clientId, String tokenEndpoint, String clientAssertionSigningAlgorithm, String trustStoreRef, String sslRef, String keyAliasName) throws TokenEndpointAuthMethodSettingsException {
        this.configurationId = configurationId;
        this.clientId = clientId;
        this.tokenEndpoint = tokenEndpoint;
        this.clientAssertionSigningAlgorithm = clientAssertionSigningAlgorithm;
        this.trustStoreRef = trustStoreRef;
        this.sslRef = sslRef;
        this.keyAliasName = keyAliasName;
        if (keyAliasName == null || keyAliasName.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"PRIVATE_KEY_JWT_MISSING_KEY_ALIAS_NAME", (Object[])new Object[]{configurationId});
            throw new TokenEndpointAuthMethodSettingsException(configurationId, AUTH_METHOD, errorMsg);
        }
    }

    @Override
    @FFDCIgnore(value={PrivateKeyJwtAuthException.class})
    public void setAuthMethodSpecificSettings(TokenRequestor.Builder tokenRequestBuilder) throws TokenEndpointAuthMethodSettingsException {
        try {
            HashMap<String, String> customParams = this.getPrivateKeyJwtParameters();
            tokenRequestBuilder.customParams(customParams);
        }
        catch (PrivateKeyJwtAuthException e) {
            throw new TokenEndpointAuthMethodSettingsException(this.configurationId, AUTH_METHOD, e.getMessage());
        }
    }

    HashMap<String, String> getPrivateKeyJwtParameters() throws PrivateKeyJwtAuthException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        String clientAssertionJwt = this.createPrivateKeyJwt();
        parameters.put("client_assertion", clientAssertionJwt);
        return parameters;
    }

    @FFDCIgnore(value={Exception.class})
    public String createPrivateKeyJwt() throws PrivateKeyJwtAuthException {
        String jwt = null;
        try {
            JwtClaims claims = this.populateJwtClaims();
            jwt = this.getSignedJwt(claims);
        }
        catch (Exception e) {
            throw new PrivateKeyJwtAuthException(this.configurationId, e.getMessage());
        }
        return jwt;
    }

    private JwtClaims populateJwtClaims() {
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(this.clientId);
        claims.setSubject(this.clientId);
        claims.setAudience(this.tokenEndpoint);
        claims.setExpirationTimeMinutesInTheFuture(5.0f);
        claims.setGeneratedJwtId();
        claims.setIssuedAtToNow();
        return claims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSignedJwt(JwtClaims claims) throws Exception {
        PrivateKey clientAssertionSigningKey = this.getPrivateKeyForClientAuthentication();
        if (clientAssertionSigningKey == null) {
            throw new PrivateKeyJwtAuthMissingKeyException(this.configurationId);
        }
        JsonWebSignature jws = new JsonWebSignature();
        this.setHeaderValues(jws);
        jws.setPayload(claims.toJson());
        jws.setKey((Key)clientAssertionSigningKey);
        jws.setDoKeyValidation(false);
        Object token = ThreadIdentityManager.runAsServer();
        try {
            String string = jws.getCompactSerialization();
            return string;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    PrivateKey getPrivateKeyForClientAuthentication() throws Exception {
        String keyStoreRef = this.sslUtils.getKeyStoreRef(this.sslRef);
        if (keyStoreRef == null || keyStoreRef.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"PRIVATE_KEY_JWT_MISSING_KEYSTORE_REF", (Object[])new Object[]{this.configurationId});
            throw new Exception(errorMsg);
        }
        try {
            return keyStoreService.getPrivateKeyFromKeyStore(keyStoreRef, this.keyAliasName, null);
        }
        catch (Exception errorMsg) {
            void e;
            FFDCFilter.processException((Throwable)errorMsg, (String)"io.openliberty.security.oidcclientcore.token.auth.PrivateKeyJwtAuthMethod", (String)"162", (Object)this, (Object[])new Object[0]);
            String errorMsg2 = Tr.formatMessage((TraceComponent)tc, (String)"PRIVATE_KEY_JWT_ERROR_GETTING_PRIVATE_KEY", (Object[])new Object[]{this.keyAliasName, keyStoreRef, e.getMessage()});
            throw new Exception(errorMsg2, (Throwable)e);
        }
    }

    private void setHeaderValues(JsonWebSignature jws) throws Exception {
        jws.setAlgorithmHeaderValue(this.clientAssertionSigningAlgorithm);
        jws.setHeader("typ", "JWT");
        jws.setHeader(CryptoUtils.isFips140_3EnabledWithBetaGuard() ? "x5t#S256" : "x5t", this.getX5tForPublicKey());
    }

    String getX5tForPublicKey() throws Exception {
        X509Certificate x509Cert = this.getX509CertificateFromTrustStoreRef();
        if (x509Cert == null) {
            x509Cert = this.getX509CertificateFromSslRef();
        }
        return CryptoUtils.isFips140_3EnabledWithBetaGuard() ? X509Util.x5tS256((X509Certificate)x509Cert) : X509Util.x5t((X509Certificate)x509Cert);
    }

    @FFDCIgnore(value={Exception.class})
    X509Certificate getX509CertificateFromTrustStoreRef() throws Exception {
        if (this.trustStoreRef == null || this.trustStoreRef.isEmpty()) {
            return null;
        }
        try {
            return keyStoreService.getX509CertificateFromKeyStore(this.trustStoreRef, this.keyAliasName);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Encountered an error loading the [{0}] key from the [{1}] trustStoreRef: {2}", (Object[])new Object[]{this.keyAliasName, this.trustStoreRef, e.getMessage()});
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    X509Certificate getX509CertificateFromSslRef() throws Exception {
        String storeRef = this.sslUtils.getTrustStoreRef(this.sslRef);
        if (storeRef == null || storeRef.isEmpty()) {
            storeRef = this.sslUtils.getKeyStoreRef(this.sslRef);
        }
        try {
            return keyStoreService.getX509CertificateFromKeyStore(storeRef, this.keyAliasName);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.security.oidcclientcore.token.auth.PrivateKeyJwtAuthMethod", (String)"205", (Object)this, (Object[])new Object[0]);
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"PRIVATE_KEY_JWT_ERROR_GETTING_PUBLIC_KEY", (Object[])new Object[]{this.keyAliasName, storeRef, e.getMessage()});
            throw new Exception(errorMsg, (Throwable)e);
        }
    }
}

