/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.validation;

import com.ibm.jbatch.container.exception.BatchIllegalIDPersistedException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class IdentifierValidator {
    private static final Logger logger = Logger.getLogger(IdentifierValidator.class.getName(), "com.ibm.jbatch.container.internal.resources.JBatchMessages");
    static final long serialVersionUID = 5046138801330133579L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IdentifierValidator() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.validation.IdentifierValidator", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.validation.IdentifierValidator", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void validatePersistedJobInstanceIds(JobInstanceEntity instance) throws PersistenceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.validation.IdentifierValidator", "validatePersistedJobInstanceIds", new Object[]{instance});
        }
        if (instance.getInstanceId() <= 0L) {
            long id = instance.getInstanceId();
            PersistenceException e = new PersistenceException(new BatchIllegalIDPersistedException(Long.toString(id)));
            logger.log(Level.SEVERE, "error.invalid.persisted.job.id", new Object[]{Long.toString(id), e});
            throw e;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.validation.IdentifierValidator", "validatePersistedJobInstanceIds");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void validatePersistedJobExecution(JobExecutionEntity execution) throws PersistenceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.validation.IdentifierValidator", "validatePersistedJobExecution", new Object[]{execution});
        }
        if (execution.getExecutionId() <= 0L) {
            long exId = execution.getExecutionId();
            PersistenceException e = new PersistenceException(new BatchIllegalIDPersistedException(Long.toString(exId)));
            logger.log(Level.SEVERE, "error.invalid.persisted.exe.id", new Object[]{Long.toString(exId), e});
            throw e;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.validation.IdentifierValidator", "validatePersistedJobExecution");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void validatePersistedStepExecution(StepThreadExecutionEntity stepExecution) throws PersistenceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.validation.IdentifierValidator", "validatePersistedStepExecution", new Object[]{stepExecution});
        }
        if (stepExecution.getStepExecutionId() <= 0L) {
            long stepId = stepExecution.getStepExecutionId();
            PersistenceException e = new PersistenceException(new BatchIllegalIDPersistedException(Long.toString(stepId)));
            logger.log(Level.SEVERE, "error.invalid.persisted.step.id", new Object[]{Long.toString(stepId), e});
            throw e;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.validation.IdentifierValidator", "validatePersistedStepExecution");
        }
    }
}

