/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractCollectionView;
import com.ibm.ws.objectManager.AbstractMap;
import com.ibm.ws.objectManager.AbstractMapEntry;
import com.ibm.ws.objectManager.AbstractMapView;
import com.ibm.ws.objectManager.AbstractSetView;
import com.ibm.ws.objectManager.Collection;
import com.ibm.ws.objectManager.Iterator;
import com.ibm.ws.objectManager.Map;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.Set;
import com.ibm.ws.objectManager.SortedMap;
import com.ibm.ws.objectManager.Token;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public abstract class AbstractTreeMap
extends AbstractMap
implements SortedMap {
    long size;
    Token root;
    Comparator comparator;
    int modCount;

    public AbstractTreeMap() {
    }

    public AbstractTreeMap(Comparator comparator) {
        this.comparator = comparator;
    }

    public AbstractTreeMap(Map map) throws ObjectManagerException {
        this();
        this.putAll(map);
    }

    public AbstractTreeMap(SortedMap map) throws ObjectManagerException {
        this(map.comparator());
        Iterator it = map.entrySet().iterator();
        if (it.hasNext()) {
            Entry entry = (Entry)it.next();
            Entry last = this.makeEntry(entry.getKey(), entry.getValue());
            this.setRoot(last);
            this.size = 1L;
            while (it.hasNext()) {
                entry = (Entry)it.next();
                Entry x = this.makeEntry(entry.getKey(), entry.getValue());
                x.setParent(last);
                last.setRight(x);
                ++this.size;
                this.balance(x);
                last = x;
            }
        }
    }

    Entry getRoot() throws ObjectManagerException {
        return this.root == null ? null : (Entry)this.root.getManagedObject();
    }

    void setRoot(Entry root) throws ObjectManagerException {
        this.root = root == null ? null : root.getToken();
    }

    abstract Entry makeEntry(Object var1) throws ObjectManagerException;

    abstract Entry makeEntry(Object var1, Token var2) throws ObjectManagerException;

    abstract Iterator makeTreeMapIterator(AbstractMapEntry.Type var1) throws ObjectManagerException;

    abstract Iterator makeTreeMapIterator(AbstractMapEntry.Type var1, Entry var2, boolean var3, Object var4) throws ObjectManagerException;

    abstract SubMap makeSubMap(Object var1, Object var2);

    void balance(Entry x) throws ObjectManagerException {
        x.setColor(true);
        while (x != this.getRoot() && x.getParent().getColor()) {
            Entry y;
            if (x.getParent() == x.getParent().getParent().getLeft()) {
                y = x.getParent().getParent().getRight();
                if (y != null && y.getColor()) {
                    x.getParent().setColor(false);
                    y.setColor(false);
                    x.getParent().getParent().setColor(true);
                    x = x.getParent().getParent();
                    continue;
                }
                if (x == x.getParent().getRight()) {
                    x = x.getParent();
                    this.leftRotate(x);
                }
                x.getParent().setColor(false);
                x.getParent().getParent().setColor(true);
                this.rightRotate(x.getParent().getParent());
                continue;
            }
            y = x.getParent().getParent().getLeft();
            if (y != null && y.getColor()) {
                x.getParent().setColor(false);
                y.setColor(false);
                x.getParent().getParent().setColor(true);
                x = x.getParent().getParent();
                continue;
            }
            if (x == x.getParent().getLeft()) {
                x = x.getParent();
                this.rightRotate(x);
            }
            x.getParent().setColor(false);
            x.getParent().getParent().setColor(true);
            this.leftRotate(x.getParent().getParent());
        }
        this.getRoot().setColor(false);
    }

    public void clear() {
        this.root = null;
        this.size = 0L;
        ++this.modCount;
    }

    public Object clone() {
        try {
            AbstractTreeMap clone = (AbstractTreeMap)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public Comparator comparator() {
        return this.comparator;
    }

    public boolean containsKey(Object key) throws ObjectManagerException {
        return this.find(key) != null;
    }

    public boolean containsValue(Object value) throws ObjectManagerException {
        if (this.getRoot() != null) {
            return this.containsValue(this.getRoot(), value);
        }
        return false;
    }

    private boolean containsValue(Entry node, Object value) throws ObjectManagerException {
        if (value == null ? node.value == null : value.equals(node.value)) {
            return true;
        }
        if (node.getLeft() != null && this.containsValue(node.getLeft(), value)) {
            return true;
        }
        return node.getRight() != null && this.containsValue(node.getRight(), value);
    }

    @Override
    public Set entrySet() throws ObjectManagerException {
        return new AbstractSetView(){

            @Override
            public long size() {
                return AbstractTreeMap.this.size;
            }

            public boolean contains(Object object) throws ObjectManagerException {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    Object v1 = AbstractTreeMap.this.get(entry.getKey());
                    Token v2 = entry.getValue();
                    return v1 == null ? v2 == null : v1.equals(v2);
                }
                return false;
            }

            @Override
            public Iterator iterator() throws ObjectManagerException {
                return AbstractTreeMap.this.makeTreeMapIterator(new AbstractMapEntry.Type(){

                    @Override
                    public Object get(AbstractMapEntry entry) {
                        return entry;
                    }
                });
            }
        };
    }

    Entry find(Object key) throws ObjectManagerException {
        Comparable object = null;
        if (this.comparator == null) {
            object = (Comparable)key;
        }
        Entry x = this.getRoot();
        while (x != null) {
            int result;
            int n = result = object != null ? object.compareTo(x.key) : this.comparator.compare(key, x.key);
            if (result == 0) {
                return x;
            }
            x = result < 0 ? x.getLeft() : x.getRight();
        }
        return null;
    }

    Entry findAfter(Object key) throws ObjectManagerException {
        Comparable object = null;
        if (this.comparator == null) {
            object = (Comparable)key;
        }
        Entry x = this.getRoot();
        Entry last = null;
        while (x != null) {
            int result;
            int n = result = object != null ? object.compareTo(x.key) : this.comparator.compare(key, x.key);
            if (result == 0) {
                return x;
            }
            if (result < 0) {
                last = x;
                x = x.getLeft();
                continue;
            }
            x = x.getRight();
        }
        return last;
    }

    Entry findBefore(Object key) throws ObjectManagerException {
        Comparable object = null;
        if (this.comparator == null) {
            object = (Comparable)key;
        }
        Entry x = this.getRoot();
        Entry last = null;
        while (x != null) {
            int result;
            int n = result = object != null ? object.compareTo(x.key) : this.comparator.compare(key, x.key);
            if (result <= 0) {
                x = x.getLeft();
                continue;
            }
            last = x;
            x = x.getRight();
        }
        return last;
    }

    public Object firstKey() throws ObjectManagerException {
        if (this.getRoot() != null) {
            return AbstractTreeMap.minimum((Entry)this.getRoot()).key;
        }
        throw new NoSuchElementException();
    }

    void fixup(Entry x) throws ObjectManagerException {
        while (x != this.getRoot() && !x.getColor()) {
            Entry w;
            if (x == x.getParent().getLeft()) {
                w = x.getParent().getRight();
                if (w == null) {
                    x = x.getParent();
                    continue;
                }
                if (w.getColor()) {
                    w.setColor(false);
                    x.getParent().setColor(true);
                    this.leftRotate(x.getParent());
                    w = x.getParent().getRight();
                    if (w == null) {
                        x = x.getParent();
                        continue;
                    }
                }
                if (!(w.getLeft() != null && w.getLeft().getColor() || w.getRight() != null && w.getRight().getColor())) {
                    w.setColor(true);
                    x = x.getParent();
                    continue;
                }
                if (w.getRight() == null || !w.getRight().getColor()) {
                    w.getLeft().setColor(false);
                    w.setColor(true);
                    this.rightRotate(w);
                    w = x.getParent().getRight();
                }
                w.setColor(x.getParent().getColor());
                x.getParent().setColor(false);
                w.getRight().setColor(false);
                this.leftRotate(x.getParent());
                x = this.getRoot();
                continue;
            }
            w = x.getParent().getLeft();
            if (w == null) {
                x = x.getParent();
                continue;
            }
            if (w.getColor()) {
                w.setColor(false);
                x.getParent().setColor(true);
                this.rightRotate(x.getParent());
                w = x.getParent().getLeft();
                if (w == null) {
                    x = x.getParent();
                    continue;
                }
            }
            if (!(w.getLeft() != null && w.getLeft().getColor() || w.getRight() != null && w.getRight().getColor())) {
                w.setColor(true);
                x = x.getParent();
                continue;
            }
            if (w.getLeft() == null || !w.getLeft().getColor()) {
                w.getRight().setColor(false);
                w.setColor(true);
                this.leftRotate(w);
                w = x.getParent().getLeft();
            }
            w.setColor(x.getParent().getColor());
            x.getParent().setColor(false);
            w.getLeft().setColor(false);
            this.rightRotate(x.getParent());
            x = this.getRoot();
        }
        x.setColor(false);
    }

    public Object get(Object key) throws ObjectManagerException {
        Entry node = this.find(key);
        if (node != null) {
            return node.value;
        }
        return null;
    }

    @Override
    public SortedMap headMap(Object endKey) {
        if (this.comparator == null) {
            ((Comparable)endKey).compareTo(endKey);
        } else {
            this.comparator.compare(endKey, endKey);
        }
        return this.makeSubMap(null, endKey);
    }

    @Override
    public Collection keyCollection() {
        if (this.keyCollection == null) {
            this.keyCollection = new AbstractCollectionView(){

                @Override
                public long size() throws ObjectManagerException {
                    return AbstractTreeMap.this.size();
                }

                @Override
                public Iterator iterator() throws ObjectManagerException {
                    return AbstractTreeMap.this.makeTreeMapIterator(new AbstractMapEntry.Type(){

                        @Override
                        public Object get(AbstractMapEntry entry) {
                            return entry.key;
                        }
                    });
                }
            };
        }
        return this.keyCollection;
    }

    public Object lastKey() throws ObjectManagerException {
        if (this.getRoot() != null) {
            return AbstractTreeMap.maximum((Entry)this.getRoot()).key;
        }
        throw new NoSuchElementException();
    }

    private void leftRotate(Entry x) throws ObjectManagerException {
        Entry y = x.getRight();
        x.setRight(y.getLeft());
        if (y.getLeft() != null) {
            y.getLeft().setParent(x);
        }
        y.setParent(x.getParent());
        if (x.getParent() == null) {
            this.setRoot(y);
        } else if (x == x.getParent().getLeft()) {
            x.getParent().setLeft(y);
        } else {
            x.getParent().setRight(y);
        }
        y.setLeft(x);
        x.setParent(y);
    }

    static Entry maximum(Entry x) throws ObjectManagerException {
        while (x.getRight() != null) {
            x = x.getRight();
        }
        return x;
    }

    static Entry minimum(Entry x) throws ObjectManagerException {
        while (x.getLeft() != null) {
            x = x.getLeft();
        }
        return x;
    }

    static Entry predecessor(Entry x) throws ObjectManagerException {
        Entry y;
        if (x.getLeft() != null) {
            return AbstractTreeMap.maximum(x.getLeft());
        }
        for (y = x.getParent(); y != null && x == y.getLeft(); y = y.getParent()) {
            x = y;
        }
        return y;
    }

    public Object put(Object key, Token value) throws ObjectManagerException {
        Entry entry = this.rbInsert(key);
        Token result = entry.value;
        entry.value = value;
        return result;
    }

    public void putAll(Map map) throws ObjectManagerException {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    void rbDelete(Entry z) throws ObjectManagerException {
        Entry x;
        Entry y = z.getLeft() == null || z.getRight() == null ? z : AbstractTreeMap.successor(z);
        Entry entry = x = y.getLeft() != null ? y.getLeft() : y.getRight();
        if (x != null) {
            x.setParent(y.getParent());
        }
        if (y.getParent() == null) {
            this.setRoot(x);
        } else if (y == y.getParent().getLeft()) {
            y.getParent().setLeft(x);
        } else {
            y.getParent().setRight(x);
        }
        ++this.modCount;
        if (y != z) {
            z.key = y.key;
            z.value = y.value;
        }
        if (!y.getColor() && this.getRoot() != null) {
            if (x == null) {
                this.fixup(y.getParent());
            } else {
                this.fixup(x);
            }
        }
        --this.size;
    }

    private Entry rbInsert(Object object) throws ObjectManagerException {
        int result = 0;
        Comparable key = null;
        if (this.comparator == null) {
            key = (Comparable)object;
        }
        Entry y = null;
        Entry x = this.getRoot();
        while (x != null) {
            y = x;
            int n = result = key != null ? key.compareTo(x.key) : this.comparator.compare(object, x.key);
            if (result == 0) {
                return x;
            }
            x = result < 0 ? x.getLeft() : x.getRight();
        }
        ++this.size;
        ++this.modCount;
        Entry z = this.makeEntry(object);
        if (y == null) {
            this.setRoot(z);
            return z;
        }
        z.setParent(y);
        if (result < 0) {
            y.setLeft(z);
        } else {
            y.setRight(z);
        }
        this.balance(z);
        return z;
    }

    public Object remove(Object key) throws ObjectManagerException {
        Entry node = this.find(key);
        if (node == null) {
            return null;
        }
        Token result = node.value;
        this.rbDelete(node);
        return result;
    }

    private void rightRotate(Entry x) throws ObjectManagerException {
        Entry y = x.getLeft();
        x.setLeft(y.getRight());
        if (y.getRight() != null) {
            y.getRight().setParent(x);
        }
        y.setParent(x.getParent());
        if (x.getParent() == null) {
            this.setRoot(y);
        } else if (x == x.getParent().getRight()) {
            x.getParent().setRight(y);
        } else {
            x.getParent().setLeft(y);
        }
        y.setRight(x);
        x.setParent(y);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public SortedMap subMap(Object startKey, Object endKey) {
        if (this.comparator == null ? ((Comparable)startKey).compareTo(endKey) <= 0 : this.comparator.compare(startKey, endKey) <= 0) {
            return this.makeSubMap(startKey, endKey);
        }
        throw new IllegalArgumentException();
    }

    static Entry successor(Entry x) throws ObjectManagerException {
        Entry y;
        if (x.getRight() != null) {
            return AbstractTreeMap.minimum(x.getRight());
        }
        for (y = x.getParent(); y != null && x == y.getRight(); y = y.getParent()) {
            x = y;
        }
        return y;
    }

    @Override
    public SortedMap tailMap(Object startKey) {
        if (this.comparator == null) {
            ((Comparable)startKey).compareTo(startKey);
        } else {
            this.comparator.compare(startKey, startKey);
        }
        return this.makeSubMap(startKey, null);
    }

    @Override
    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollectionView(){

                @Override
                public long size() throws ObjectManagerException {
                    return AbstractTreeMap.this.size();
                }

                @Override
                public Iterator iterator() throws ObjectManagerException {
                    return AbstractTreeMap.this.makeTreeMapIterator(new AbstractMapEntry.Type(){

                        @Override
                        public Object get(AbstractMapEntry entry) {
                            return entry.getValue();
                        }
                    });
                }
            };
        }
        return this.values;
    }

    static abstract class Entry
    extends AbstractMapEntry {
        Token parent;
        Token left;
        Token right;
        boolean color;

        Entry(Object key) {
            super(key);
        }

        Entry(Object key, Token value) {
            super(key, value);
        }

        boolean getColor() throws ObjectManagerException {
            return this.color;
        }

        void setColor(boolean color) throws ObjectManagerException {
            this.color = color;
        }

        Entry getLeft() throws ObjectManagerException {
            return this.left == null ? null : (Entry)this.left.getManagedObject();
        }

        void setLeft(Entry left) throws ObjectManagerException {
            this.left = left == null ? null : left.getToken();
        }

        Entry getParent() throws ObjectManagerException {
            return this.parent == null ? null : (Entry)this.parent.getManagedObject();
        }

        void setParent(Entry parent) throws ObjectManagerException {
            this.parent = parent == null ? null : parent.getToken();
        }

        Entry getRight() throws ObjectManagerException {
            return this.right == null ? null : (Entry)this.right.getManagedObject();
        }

        void setRight(Entry right) throws ObjectManagerException {
            this.right = right == null ? null : right.getToken();
        }
    }

    abstract class SubMap
    extends AbstractMapView
    implements SortedMap {
        final AbstractTreeMap backingMap;
        boolean hasStart;
        boolean hasEnd;
        Object startKey;
        Object endKey;

        SubMap(Object start, AbstractTreeMap map, Object end) {
            this.backingMap = map;
            this.hasStart = start != null;
            this.startKey = start;
            this.hasEnd = end != null;
            this.endKey = end;
        }

        void checkRange(Object key) {
            if (this.backingMap.comparator() == null) {
                Comparable object = (Comparable)key;
                if (this.hasStart && object.compareTo(this.startKey) < 0) {
                    throw new IllegalArgumentException();
                }
                if (this.hasEnd && object.compareTo(this.endKey) >= 0) {
                    throw new IllegalArgumentException();
                }
            } else {
                if (this.hasStart && this.backingMap.comparator().compare(key, this.startKey) < 0) {
                    throw new IllegalArgumentException();
                }
                if (this.hasEnd && this.backingMap.comparator().compare(key, this.endKey) >= 0) {
                    throw new IllegalArgumentException();
                }
            }
        }

        boolean checkRange(Object key, boolean hasStart, boolean hasEnd) {
            if (this.backingMap.comparator() == null) {
                Comparable object = (Comparable)key;
                if (hasStart && object.compareTo(this.startKey) < 0) {
                    return false;
                }
                if (hasEnd && object.compareTo(this.endKey) >= 0) {
                    return false;
                }
            } else {
                if (hasStart && this.backingMap.comparator().compare(key, this.startKey) < 0) {
                    return false;
                }
                if (hasEnd && this.backingMap.comparator().compare(key, this.endKey) >= 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Comparator comparator() {
            return this.backingMap.comparator();
        }

        public boolean containsKey(Object key) throws ObjectManagerException {
            if (this.checkRange(key, this.hasStart, this.hasEnd)) {
                return this.backingMap.containsKey(key);
            }
            return false;
        }

        @Override
        public Set entrySet() throws ObjectManagerException {
            return new SubMapSet(this.hasStart, this.startKey, this.backingMap, this.hasEnd, this.endKey, new AbstractMapEntry.Type(){

                @Override
                public Object get(AbstractMapEntry entry) {
                    return entry;
                }
            }){

                public boolean contains(Object object) throws ObjectManagerException {
                    if (object instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)object;
                        Object v1 = SubMap.this.get(entry.getKey());
                        Token v2 = entry.getValue();
                        return v1 == null ? v2 == null : v1.equals(v2);
                    }
                    return false;
                }
            };
        }

        public Object firstKey() throws ObjectManagerException {
            if (!this.hasStart) {
                return this.backingMap.firstKey();
            }
            Entry node = this.backingMap.findAfter(this.startKey);
            if (node != null && this.checkRange(node.key, false, this.hasEnd)) {
                return node.key;
            }
            throw new NoSuchElementException();
        }

        public Object get(Object key) throws ObjectManagerException {
            if (this.checkRange(key, this.hasStart, this.hasEnd)) {
                return this.backingMap.get(key);
            }
            return null;
        }

        @Override
        public SortedMap headMap(Object endKey) {
            this.checkRange(endKey);
            if (this.hasStart) {
                return AbstractTreeMap.this.makeSubMap(this.startKey, endKey);
            }
            return AbstractTreeMap.this.makeSubMap(null, endKey);
        }

        public boolean isEmpty() throws ObjectManagerException {
            if (this.hasStart) {
                Entry node = this.backingMap.findAfter(this.startKey);
                return node == null || !this.checkRange(node.key, false, this.hasEnd);
            }
            return this.backingMap.findBefore(this.endKey) == null;
        }

        @Override
        public Collection keyCollection() {
            if (this.keyCollection == null) {
                this.keyCollection = new SubMapSet(this.hasStart, this.startKey, this.backingMap, this.hasEnd, this.endKey, new AbstractMapEntry.Type(){

                    @Override
                    public Object get(AbstractMapEntry entry) {
                        return entry.key;
                    }
                }){

                    public boolean contains(Object object) throws ObjectManagerException {
                        return SubMap.this.containsKey(object);
                    }
                };
            }
            return this.keyCollection;
        }

        public Object lastKey() throws ObjectManagerException {
            if (!this.hasEnd) {
                return this.backingMap.lastKey();
            }
            Entry node = this.backingMap.findBefore(this.endKey);
            if (node != null && this.checkRange(node.key, this.hasStart, false)) {
                return node.key;
            }
            throw new NoSuchElementException();
        }

        public Object put(Object key, Token value) throws ObjectManagerException {
            if (this.checkRange(key, this.hasStart, this.hasEnd)) {
                return this.backingMap.put(key, value);
            }
            throw new IllegalArgumentException();
        }

        public Object remove(Object key) throws ObjectManagerException {
            if (this.checkRange(key, this.hasStart, this.hasEnd)) {
                return this.backingMap.remove(key);
            }
            return null;
        }

        @Override
        public SortedMap subMap(Object startKey, Object endKey) {
            this.checkRange(startKey);
            this.checkRange(endKey);
            Comparator c = this.backingMap.comparator();
            if (c == null ? ((Comparable)startKey).compareTo(endKey) <= 0 : c.compare(startKey, endKey) <= 0) {
                return AbstractTreeMap.this.makeSubMap(startKey, endKey);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public SortedMap tailMap(Object startKey) {
            this.checkRange(startKey);
            return AbstractTreeMap.this.makeSubMap(startKey, this.endKey);
        }

        @Override
        public Collection values() {
            return new SubMapSet(this.hasStart, this.startKey, this.backingMap, this.hasEnd, this.endKey, new AbstractMapEntry.Type(){

                @Override
                public Object get(AbstractMapEntry entry) {
                    return entry.value;
                }
            });
        }

        class SubMapSet
        extends AbstractSetView
        implements Set {
            final AbstractTreeMap backingMap;
            boolean hasStart;
            boolean hasEnd;
            Object startKey;
            Object endKey;
            final AbstractMapEntry.Type type;

            SubMapSet(AbstractTreeMap map, AbstractMapEntry.Type theType) {
                this.backingMap = map;
                this.type = theType;
            }

            SubMapSet(boolean starting, Object start, AbstractTreeMap map, boolean ending, Object end, AbstractMapEntry.Type theType) {
                this(map, theType);
                this.hasStart = starting;
                this.startKey = start;
                this.hasEnd = ending;
                this.endKey = end;
            }

            void checkRange(Object key) {
                if (this.backingMap.comparator() == null) {
                    Comparable object = (Comparable)key;
                    if (this.hasStart && object.compareTo(this.startKey) < 0) {
                        throw new IllegalArgumentException();
                    }
                    if (this.hasEnd && object.compareTo(this.endKey) >= 0) {
                        throw new IllegalArgumentException();
                    }
                } else {
                    if (this.hasStart && this.backingMap.comparator().compare(key, this.startKey) < 0) {
                        throw new IllegalArgumentException();
                    }
                    if (this.hasEnd && this.backingMap.comparator().compare(key, this.endKey) >= 0) {
                        throw new IllegalArgumentException();
                    }
                }
            }

            boolean checkRange(Object key, boolean hasStart, boolean hasEnd) {
                if (this.backingMap.comparator() == null) {
                    Comparable object = (Comparable)key;
                    if (hasStart && object.compareTo(this.startKey) < 0) {
                        return false;
                    }
                    if (hasEnd && object.compareTo(this.endKey) >= 0) {
                        return false;
                    }
                } else {
                    if (hasStart && this.backingMap.comparator().compare(key, this.startKey) < 0) {
                        return false;
                    }
                    if (hasEnd && this.backingMap.comparator().compare(key, this.endKey) >= 0) {
                        return false;
                    }
                }
                return true;
            }

            public boolean isEmpty() throws ObjectManagerException {
                if (this.hasStart) {
                    Entry node = this.backingMap.findAfter(this.startKey);
                    return node == null || !this.checkRange(node.key, false, this.hasEnd);
                }
                return this.backingMap.findBefore(this.endKey) == null;
            }

            @Override
            public Iterator iterator() throws ObjectManagerException {
                Entry startNode;
                if (this.hasStart) {
                    startNode = this.backingMap.findAfter(this.startKey);
                    if (startNode != null && !this.checkRange(startNode.key, false, this.hasEnd)) {
                        startNode = null;
                    }
                } else {
                    startNode = this.backingMap.findBefore(this.endKey);
                    if (startNode != null) {
                        startNode = AbstractTreeMap.minimum(this.backingMap.getRoot());
                    }
                }
                return AbstractTreeMap.this.makeTreeMapIterator(this.type, startNode, this.hasEnd, this.endKey);
            }

            @Override
            public long size() throws ObjectManagerException {
                long size = 0L;
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    ++size;
                    it.next();
                }
                return size;
            }
        }
    }

    abstract class TreeMapIterator
    implements Iterator {
        private final AbstractTreeMap backingMap;
        private int expectedModCount;
        private final AbstractMapEntry.Type type;
        private boolean hasEnd = false;
        private Entry node;
        private Entry lastNode;
        private Object endKey;

        TreeMapIterator(AbstractTreeMap map, AbstractMapEntry.Type value) throws ObjectManagerException {
            this.backingMap = map;
            this.type = value;
            this.expectedModCount = map.modCount;
            if (map.getRoot() != null) {
                this.node = AbstractTreeMap.minimum(map.getRoot());
            }
        }

        TreeMapIterator(AbstractTreeMap map, AbstractMapEntry.Type value, Entry startNode, boolean checkEnd, Object end) {
            this.backingMap = map;
            this.type = value;
            this.expectedModCount = map.modCount;
            this.node = startNode;
            this.hasEnd = checkEnd;
            this.endKey = end;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public Object next() throws ObjectManagerException {
            if (this.expectedModCount == this.backingMap.modCount) {
                if (this.node != null) {
                    this.lastNode = this.node;
                    this.node = AbstractTreeMap.successor(this.node);
                    if (this.hasEnd && this.node != null) {
                        Comparator c = this.backingMap.comparator();
                        if (c == null) {
                            if (((Comparable)this.endKey).compareTo(this.node.key) <= 0) {
                                this.node = null;
                            }
                        } else if (c.compare(this.endKey, this.node.key) <= 0) {
                            this.node = null;
                        }
                    }
                    return this.type.get(this.lastNode);
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() throws ObjectManagerException {
            if (this.expectedModCount != this.backingMap.modCount) throw new ConcurrentModificationException();
            if (this.lastNode == null) throw new IllegalStateException();
            this.backingMap.rbDelete(this.lastNode);
            this.lastNode = null;
            ++this.expectedModCount;
        }
    }
}

