/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics;

import com.ibm.ws.jpa.diagnostics.EclipselinkIntrospection;
import com.ibm.ws.jpa.diagnostics.OpenJPAIntrospection;
import com.ibm.ws.jpa.diagnostics.PlatformIntrospection;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractIntrospection
implements PlatformIntrospection {
    private static final String[] openJPAEntityManagerFactoryImplClasses = new String[]{"org.apache.openjpa.persistence.EntityManagerFactoryImpl", "com.ibm.ws.persistence.EntityManagerFactoryImpl"};
    private static final String[] eclipselinkEntityManagerFactoryImplClasses = new String[]{"org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl"};

    public static boolean isSupportedPlatform(Class jpaProviderImplClass) {
        if (jpaProviderImplClass == null) {
            return false;
        }
        String className = jpaProviderImplClass.getName();
        if (eclipselinkEntityManagerFactoryImplClasses[0].equals(className)) {
            return true;
        }
        return openJPAEntityManagerFactoryImplClasses[0].equals(className) || openJPAEntityManagerFactoryImplClasses[1].equals(className);
    }

    public static PlatformIntrospection getPlatformIntrospection(Class jpaProviderImplClass) {
        if (jpaProviderImplClass == null) {
            return null;
        }
        String className = jpaProviderImplClass.getName();
        if (eclipselinkEntityManagerFactoryImplClasses[0].equals(className)) {
            return new EclipselinkIntrospection();
        }
        if (openJPAEntityManagerFactoryImplClasses[0].equals(className) || openJPAEntityManagerFactoryImplClasses[1].equals(className)) {
            return new OpenJPAIntrospection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object reflectObjValue(Object o, String field) throws Exception {
        Class<?> c = o.getClass();
        Field f = AbstractIntrospection.findField(c, field);
        if (f == null) {
            return null;
        }
        boolean accessible = f.isAccessible();
        try {
            f.setAccessible(true);
            Object object = f.get(o);
            return object;
        }
        finally {
            f.setAccessible(accessible);
        }
    }

    protected static Field findField(Class<?> c, String field) {
        if (c == null) {
            return null;
        }
        try {
            return c.getDeclaredField(field);
        }
        catch (Exception exception) {
            if (Object.class.equals(c)) {
                return null;
            }
            return AbstractIntrospection.findField(c.getSuperclass(), field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object reflectMethodCall(Object o, Method m) throws Exception {
        if (m == null) {
            return null;
        }
        boolean accessible = m.isAccessible();
        try {
            m.setAccessible(true);
            Object object = m.invoke(o, new Object[0]);
            return object;
        }
        finally {
            m.setAccessible(accessible);
        }
    }

    protected static Object reflectMethodCall(Object o, String method) throws Exception {
        Class<?> c = o.getClass();
        Method m = AbstractIntrospection.findMethod(c, method);
        return AbstractIntrospection.reflectMethodCall(o, m);
    }

    protected static Method findMethod(Class<?> c, String methodName) {
        if (c == null) {
            return null;
        }
        try {
            Method[] methods = c.getMethods();
            if (methods != null) {
                for (Method m : methods) {
                    Class<?>[] pt;
                    if (!m.equals(methodName) || (pt = m.getParameterTypes()) != null && pt.length > 0) continue;
                    return m;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Object.class.equals(c)) {
            return null;
        }
        return AbstractIntrospection.findMethod(c.getSuperclass(), methodName);
    }

    protected static List<Method> getMethodsWithPrefix(Class<?> c, String prefix) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        if (c == null) {
            return methodList;
        }
        try {
            Method[] methods = c.getDeclaredMethods();
            if (methods != null) {
                for (Method m : methods) {
                    Class<?>[] pt;
                    if (!m.getName().startsWith(prefix) || (pt = m.getParameterTypes()) != null && pt.length > 0) continue;
                    methodList.add(m);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Object.class.equals(c)) {
            methodList.addAll(AbstractIntrospection.getMethodsWithPrefix(c.getSuperclass(), prefix));
        }
        return methodList;
    }

    protected static boolean isCastable(String superclassClass, Class<?> c) {
        return AbstractIntrospection.isCastable(superclassClass, c, new HashSet());
    }

    private static boolean isCastable(String superclassClass, Class<?> c, Set<Class<?>> checkedSet) {
        if (c == null || superclassClass == null || superclassClass.trim().isEmpty() || checkedSet.contains(c)) {
            return false;
        }
        if (superclassClass.equals(c.getName())) {
            return true;
        }
        checkedSet.add(c);
        Class<?>[] iFaces = c.getInterfaces();
        if (iFaces != null && iFaces.length > 0) {
            for (Class<?> iFace : iFaces) {
                if (!AbstractIntrospection.isCastable(superclassClass, iFace)) continue;
                return true;
            }
        }
        if (Object.class != c) {
            return AbstractIntrospection.isCastable(superclassClass, c.getSuperclass());
        }
        return false;
    }

    protected static String getObjectAddress(Object o) {
        if (o == null) {
            return "";
        }
        if (o.getClass().isPrimitive()) {
            return "";
        }
        return "@" + Integer.toHexString(System.identityHashCode(o));
    }

    protected static String poa(Object o, String indent, boolean dumpCollection) {
        return AbstractIntrospection.poa(o, indent, dumpCollection, 0);
    }

    protected static String poa(Object o, String indent, boolean dumpCollection, int depth) {
        if (!dumpCollection || o == null || depth > 5) {
            return AbstractIntrospection.poa(o);
        }
        Class<?> oClass = o.getClass();
        StringBuilder sb = new StringBuilder();
        if (oClass.isArray()) {
            sb.append(AbstractIntrospection.getInstanceClassAndAddress(o));
            Object[] objarr = (Object[])o;
            int idx = 0;
            for (Object obj : objarr) {
                sb.append("\n").append(indent).append(idx++).append(" : ");
                sb.append(AbstractIntrospection.poa(obj, indent + "   ", true, depth++));
            }
        } else if (AbstractIntrospection.isCastable("java.util.Collection", oClass)) {
            sb.append(AbstractIntrospection.getInstanceClassAndAddress(o));
            sb.append(":");
            Collection c = (Collection)o;
            for (Object obj : c) {
                sb.append("\n").append(indent).append(AbstractIntrospection.poa(obj, indent + "   ", true, depth++));
            }
        } else if (AbstractIntrospection.isCastable("java.util.Map", oClass)) {
            sb.append(AbstractIntrospection.getInstanceClassAndAddress(o));
            sb.append(":");
            Map map = (Map)o;
            for (Map.Entry entry : map.entrySet()) {
                sb.append("\n").append(indent).append(AbstractIntrospection.poa(entry.getKey())).append(" |---> ");
                sb.append(AbstractIntrospection.poa(entry.getValue(), indent + "   ", true, depth++));
            }
        } else {
            return AbstractIntrospection.poa(o);
        }
        return sb.toString();
    }

    protected static String poa(Object o) {
        if (o == null) {
            return "<<null>>";
        }
        return o.toString() + " " + AbstractIntrospection.getObjectAddress(o);
    }

    protected static String getInstanceClassAndAddress(Object o) {
        if (o == null) {
            return "<<null>>";
        }
        Class<?> oClass = o.getClass();
        if (oClass.isPrimitive()) {
            return oClass.getName();
        }
        return oClass.getName() + AbstractIntrospection.getObjectAddress(o);
    }
}

