/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Components;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ReferenceValidator {
    private static final TraceComponent tc = Tr.register(ReferenceValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final ReferenceValidator INSTANCE = new ReferenceValidator();
    static final long serialVersionUID = 219614568221994192L;

    public static ReferenceValidator getInstance() {
        return INSTANCE;
    }

    private ReferenceValidator() {
    }

    public Object validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, String $ref) {
        if ($ref != null && !$ref.trim().isEmpty()) {
            if (!$ref.startsWith("#")) {
                return null;
            }
            boolean validRefStruct = true;
            String[] references = $ref.split("/");
            if (!$ref.startsWith("#/components/") || references.length != 4) {
                validRefStruct = false;
            }
            if (validRefStruct) {
                Components components = context.getModel().getComponents();
                if (components == null) {
                    String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                    return null;
                }
                block20: for (int i = 2; i < references.length - 1; ++i) {
                    String name = references[i + 1];
                    switch (references[i]) {
                        case "schemas": {
                            Map schemas = components.getSchemas();
                            if (schemas != null && schemas.containsKey(name)) {
                                return schemas.get(name);
                            }
                            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                            continue block20;
                        }
                        case "responses": {
                            Map responses = components.getResponses();
                            if (responses != null && responses.containsKey(name)) {
                                return responses.get(name);
                            }
                            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                            continue block20;
                        }
                        case "parameters": {
                            Map parameters = components.getParameters();
                            if (parameters != null && parameters.containsKey(name)) {
                                return parameters.get(name);
                            }
                            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                            continue block20;
                        }
                        case "examples": {
                            Map examples = components.getExamples();
                            if (examples != null && examples.containsKey(name)) {
                                return examples.get(name);
                            }
                            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                            continue block20;
                        }
                        case "requestBodies": {
                            Map requestBodies = components.getRequestBodies();
                            if (requestBodies != null && requestBodies.containsKey(name)) {
                                return requestBodies.get(name);
                            }
                            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                            continue block20;
                        }
                        case "headers": {
                            Map headers = components.getHeaders();
                            if (headers != null && headers.containsKey(name)) {
                                return headers.get(name);
                            }
                            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                            continue block20;
                        }
                        case "securitySchemes": {
                            Map securitySchemes = components.getSecuritySchemes();
                            if (securitySchemes != null && securitySchemes.containsKey(name)) {
                                return securitySchemes.get(name);
                            }
                            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                            continue block20;
                        }
                        case "links": {
                            Map links = components.getLinks();
                            if (links != null && links.containsKey(name)) {
                                return links.get(name);
                            }
                            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotPartOfModel", (Object[])new Object[]{$ref});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                            continue block20;
                        }
                        default: {
                            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotValid", (Object[])new Object[]{$ref});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                        }
                    }
                }
            } else {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNotValidFormat", (Object[])new Object[]{$ref});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        } else {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"referenceNull", (Object[])new Object[0]);
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
        }
        return null;
    }
}

