/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models.parameters;

import io.smallrye.openapi.api.models.ExtensibleImpl;
import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;

public class ParameterImpl
extends ExtensibleImpl<Parameter>
implements Parameter,
ModelImpl {
    private String ref;
    private String name;
    private Parameter.In in;
    private String description;
    private Boolean required;
    private Schema schema;
    private Boolean allowEmptyValue;
    private Boolean deprecated;
    private Parameter.Style style;
    private Boolean explode;
    private Boolean allowReserved;
    private Object example;
    private Map<String, Example> examples;
    private Content content;
    private String paramRef;
    public static final String HIDDEN = "smallrye.internal.hidden";

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        if (ref != null && !ref.contains("/")) {
            ref = "#/components/parameters/" + ref;
        }
        this.ref = ref;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public void setAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
    }

    public Parameter.Style getStyle() {
        return this.style;
    }

    public void setStyle(Parameter.Style style) {
        this.style = style;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public void setExplode(Boolean explode) {
        this.explode = explode;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public void setAllowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Map<String, Example> getExamples() {
        return ModelUtil.unmodifiableMap(this.examples);
    }

    public void setExamples(Map<String, Example> examples) {
        this.examples = ModelUtil.replace(examples, LinkedHashMap::new);
    }

    public Parameter addExample(String key, Example example) {
        this.examples = ModelUtil.add(key, example, this.examples, LinkedHashMap::new);
        return this;
    }

    public void removeExample(String key) {
        ModelUtil.remove(this.examples, key);
    }

    public Object getExample() {
        return this.example;
    }

    public void setExample(Object example) {
        this.example = example;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public Parameter.In getIn() {
        return this.in;
    }

    public void setIn(Parameter.In in) {
        if (in == Parameter.In.PATH) {
            this.required = true;
        }
        this.in = in;
    }

    public String getParamRef() {
        return this.paramRef;
    }

    public void setParamRef(String paramRef) {
        this.paramRef = paramRef;
    }

    public static String getParamRef(Parameter parameter) {
        return parameter instanceof ParameterImpl ? ((ParameterImpl)parameter).getParamRef() : null;
    }

    public static boolean isHidden(Parameter parameter) {
        return parameter != null && parameter.getExtensions() != null && !parameter.getExtensions().isEmpty() && parameter.getExtensions().containsKey(HIDDEN) && parameter.getExtensions().get(HIDDEN) != null && parameter.getExtensions().get(HIDDEN).equals(true);
    }

    public static void setHidden(Parameter parameter, boolean hidden) {
        if (parameter != null) {
            parameter.addExtension(HIDDEN, (Object)hidden);
        }
    }
}

