/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.webcontainer.osgi.response.WCOutputStream;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.http.HttpOutputStream;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.ByteBufferWriter;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SRTOutputStream
extends ServletOutputStream
implements ByteBufferWriter {
    private OutputStream _conn;
    private IOutputStreamObserver _observer;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.SRTOutputStream";
    private static TraceNLS nls = TraceNLS.getTraceNLS(SRTOutputStream.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    private int fastCheck = 0;

    public void init(OutputStream str) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "init", "Initializing");
        }
        this._conn = str;
        this.fastCheck = 0;
    }

    public void flush() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "flush", "Flushing");
        }
        if (this.fastCheck == 0) {
            this.fastCheck = this._conn instanceof WCOutputStream ? 1 : 2;
        }
        if (this.fastCheck == 1) {
            ((WCOutputStream)((Object)this._conn)).flush(false);
        } else {
            this._conn.flush();
        }
    }

    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "reset", "Reseting");
        }
        this._conn = null;
        this.fastCheck = 0;
    }

    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "close", "Closing");
        }
        if (this._observer != null) {
            this._observer.alertClose();
        }
        super.close();
    }

    protected void setObserver(IOutputStreamObserver obs) {
        this._observer = obs;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "write", "Writing");
        }
        if (this._observer != null) {
            this._observer.alertFirstWrite();
        }
        this._conn.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    @Override
    public void writeByteBuffer(WsByteBuffer[] buf) {
        ((ByteBufferWriter)((Object)this._conn)).writeByteBuffer(buf);
    }

    public void write(FileChannel fileChannel) throws IOException {
        ((HttpOutputStream)this._conn).writeFile(fileChannel);
    }
}

