/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.metadata.ComponentMetaDataListener;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.extended.MetaDataIdentifierService;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.concurrent.tracker"}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, service={ComponentMetaDataListener.class, ThreadGroupTracker.class})
public class ThreadGroupTracker
implements ComponentMetaDataListener {
    static final ConcurrentHashMap<Thread, ThreadGroup> OTHER_ACTIVE_THREADS;
    private final ScheduledExecutorService deferrableScheduledExecutor;
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, ThreadGroup>> metadataIdentifierToThreadGroups = new ConcurrentHashMap();
    private final MetaDataIdentifierService metadataIdentifierService;
    final AccessControlContext serverAccessControlContext;
    static final long serialVersionUID = -8205737842625470620L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    public ThreadGroupTracker(ComponentContext context, @Reference(name="deferrableScheduledExecutor", target="(deferrable=true)") ScheduledExecutorService deferrableScheduledExecutor, @Reference(name="metadataIdentifierService") MetaDataIdentifierService metadataIdentifierService) {
        this.deferrableScheduledExecutor = deferrableScheduledExecutor;
        this.metadataIdentifierService = metadataIdentifierService;
        this.serverAccessControlContext = AccessController.getContext();
    }

    @Trivial
    public void componentMetaDataCreated(MetaDataEvent<ComponentMetaData> event) {
    }

    public void componentMetaDataDestroyed(MetaDataEvent<ComponentMetaData> event) {
        Collection<ThreadGroup> groupsToDestroy;
        String identifier = this.metadataIdentifierService.getMetaDataIdentifier(event.getMetaData());
        ConcurrentHashMap<String, ThreadGroup> threadFactoryToThreadGroup = this.metadataIdentifierToThreadGroups.remove(identifier);
        if (threadFactoryToThreadGroup != null && !(groupsToDestroy = threadFactoryToThreadGroup.values()).isEmpty()) {
            AccessController.doPrivileged(new InterruptAndDestroyThreadGroups(groupsToDestroy, this.deferrableScheduledExecutor), this.serverAccessControlContext);
        }
    }

    ThreadGroup getThreadGroup(String identifier, String threadFactoryName, ThreadGroup parentGroup) {
        ThreadGroup group;
        ConcurrentHashMap<String, ThreadGroup> threadFactoryToThreadGroup = this.metadataIdentifierToThreadGroups.get(identifier);
        if (threadFactoryToThreadGroup == null) {
            if (this.metadataIdentifierService.isMetaDataAvailable(identifier)) {
                threadFactoryToThreadGroup = new ConcurrentHashMap();
                ConcurrentHashMap<String, ThreadGroup> added = this.metadataIdentifierToThreadGroups.putIfAbsent(identifier, threadFactoryToThreadGroup);
                if (added != null) {
                    threadFactoryToThreadGroup = added;
                }
            } else {
                throw new IllegalStateException(identifier.toString());
            }
        }
        if ((group = threadFactoryToThreadGroup.get(threadFactoryName)) == null) {
            group = AccessController.doPrivileged(new CreateThreadGroupIfAbsentAction(parentGroup, threadFactoryName, identifier, threadFactoryToThreadGroup), this.serverAccessControlContext);
        }
        return group;
    }

    void threadFactoryDestroyed(String threadFactoryName, ThreadGroup parentGroup) {
        LinkedList<ThreadGroup> groupsToDestroy = new LinkedList<ThreadGroup>();
        for (ConcurrentHashMap<String, ThreadGroup> threadFactoryToThreadGroup : this.metadataIdentifierToThreadGroups.values()) {
            ThreadGroup group = threadFactoryToThreadGroup.remove(threadFactoryName);
            if (group == null) continue;
            groupsToDestroy.add(group);
        }
        groupsToDestroy.add(parentGroup);
        AccessController.doPrivileged(new InterruptAndDestroyThreadGroups(groupsToDestroy, this.deferrableScheduledExecutor), this.serverAccessControlContext);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.internal.ThreadGroupTracker", ThreadGroupTracker.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
        OTHER_ACTIVE_THREADS = new ConcurrentHashMap();
    }

    @Trivial
    private static class InterruptAndDestroyThreadGroups
    implements PrivilegedAction<Void> {
        private static final TraceComponent tc = Tr.register(InterruptAndDestroyThreadGroups.class);
        private static final long DESTROY_RETRY_INTERVAL_MS = 2000L;
        private final Collection<ThreadGroup> groups;
        private final ScheduledExecutorService scheduledExecutor;
        static final long serialVersionUID = 1701109464847712862L;

        private InterruptAndDestroyThreadGroups(Collection<ThreadGroup> groups, ScheduledExecutorService scheduledExecutor) {
            this.groups = groups;
            this.scheduledExecutor = scheduledExecutor;
        }

        @Override
        @FFDCIgnore(value={IllegalThreadStateException.class})
        public Void run() {
            Iterator<Object> it = OTHER_ACTIVE_THREADS.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Thread, ThreadGroup> entry = it.next();
                if (!this.groups.contains(entry.getValue())) continue;
                entry.getKey().interrupt();
                it.remove();
            }
            it = this.groups.iterator();
            while (it.hasNext()) {
                ThreadGroup group = (ThreadGroup)it.next();
                boolean remove = true;
                group.interrupt();
                if (!group.isDestroyed()) {
                    try {
                        group.destroy();
                    }
                    catch (IllegalThreadStateException x) {
                        remove = group.isDestroyed();
                    }
                }
                if (!remove) continue;
                it.remove();
            }
            if (!this.groups.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("remaining thread groups: " + this.groups), (Object[])new Object[0]);
                }
                this.scheduledExecutor.schedule(Executors.callable(this), 2000L, TimeUnit.MILLISECONDS);
            }
            return null;
        }
    }

    @Trivial
    private static class CreateThreadGroupIfAbsentAction
    implements PrivilegedAction<ThreadGroup> {
        private final String identifier;
        private final ThreadGroup parentGroup;
        private final String threadFactoryName;
        private final ConcurrentHashMap<String, ThreadGroup> threadFactoryToThreadGroup;

        private CreateThreadGroupIfAbsentAction(ThreadGroup parentGroup, String threadFactoryName, String identifier, ConcurrentHashMap<String, ThreadGroup> threadFactoryToThreadGroup) {
            this.identifier = identifier;
            this.parentGroup = parentGroup;
            this.threadFactoryName = threadFactoryName;
            this.threadFactoryToThreadGroup = threadFactoryToThreadGroup;
        }

        @Override
        public ThreadGroup run() {
            ThreadGroup newGroup = new ThreadGroup(this.parentGroup, this.threadFactoryName + ' ' + this.identifier + " Thread Group");
            newGroup.setDaemon(this.parentGroup.isDaemon());
            newGroup.setMaxPriority(this.parentGroup.getMaxPriority());
            ThreadGroup group = this.threadFactoryToThreadGroup.putIfAbsent(this.threadFactoryName, newGroup);
            if (group == null) {
                group = newGroup;
            } else {
                newGroup.destroy();
            }
            return group;
        }
    }
}

