/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.persistence.internal.eclipselink;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.wsspi.persistence.internal.eclipselink.LogChannel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.platform.server.ServerLog;

@Trivial
@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class Log
extends ServerLog {
    public static final String LOG_PREFIX = "eclipselink.ps";
    private static final String EMPTY_CHANNEL = "eclipselink.ps";
    private static final LogChannel EMPTY_LOG_CHANNEL = new LogChannel("eclipselink.ps");
    private static final TraceComponent _tc = Tr.register(Log.class, (String)"persistenceService");
    private static final Map<String, LogChannel> _channels = new HashMap<String, LogChannel>();
    static final long serialVersionUID = 2084976487677973137L;

    @Trivial
    public void log(SessionLogEntry entry) {
        String category = entry.getNameSpace();
        int level = entry.getLevel();
        LogChannel channel = this.getLogChannel(category);
        if (channel.shouldLog(level)) {
            channel.log(entry, this.formatMessage(entry));
        }
    }

    @Trivial
    public boolean shouldLog(int level, String category) {
        return this.getLogChannel(category).shouldLog(level);
    }

    @Trivial
    private LogChannel getLogChannel(String category) {
        if (category == null) {
            return EMPTY_LOG_CHANNEL;
        }
        LogChannel channel = _channels.get(category);
        if (channel == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Found an unmapped logging channel (" + category + ") in log(...). Possibly something wrong in EclipseLink, remapping to base channel."), (Object[])new Object[0]);
            }
            channel = EMPTY_LOG_CHANNEL;
        }
        return channel;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        for (String category : SessionLog.loggerCatagories) {
            _channels.put(category, new LogChannel("eclipselink.ps." + category));
        }
        _channels.put("eclipselink.ps", EMPTY_LOG_CHANNEL);
    }
}

