/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility.extension;

import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.product.utility.CommandUtils;
import java.io.File;
import java.util.Map;

public class VersionUtils {
    protected static Map<String, ProductInfo> getAllProductInfo(File wlpInstallationDirectory) throws VersionParsingException {
        Map productIdToVersionPropertiesMap;
        File versionPropertyDirectory = new File(wlpInstallationDirectory, "lib/versions");
        if (!versionPropertyDirectory.exists()) {
            throw new VersionParsingException(CommandUtils.getMessage("ERROR_NO_PROPERTIES_DIRECTORY", versionPropertyDirectory.getAbsoluteFile()));
        }
        if (!versionPropertyDirectory.isDirectory()) {
            throw new VersionParsingException(CommandUtils.getMessage("ERROR_NOT_PROPERTIES_DIRECTORY", versionPropertyDirectory.getAbsoluteFile()));
        }
        if (!versionPropertyDirectory.canRead()) {
            throw new VersionParsingException(CommandUtils.getMessage("ERROR_UNABLE_READ_PROPERTIES_DIRECTORY", versionPropertyDirectory.getAbsoluteFile()));
        }
        try {
            productIdToVersionPropertiesMap = ProductInfo.getAllProductInfo((File)wlpInstallationDirectory);
        }
        catch (IllegalArgumentException e) {
            throw new VersionParsingException(CommandUtils.getMessage("ERROR_UNABLE_READ_PROPERTIES_DIRECTORY", versionPropertyDirectory.getAbsoluteFile()));
        }
        catch (ProductInfoParseException e) {
            String missingKey = e.getMissingKey();
            if (missingKey != null) {
                throw new VersionParsingException(CommandUtils.getMessage("version.missing.key", missingKey, e.getFile().getAbsoluteFile()));
            }
            throw new VersionParsingException(CommandUtils.getMessage("ERROR_UNABLE_READ_FILE", e.getFile().getAbsoluteFile(), e.getCause().getMessage()));
        }
        catch (DuplicateProductInfoException e) {
            throw new VersionParsingException(CommandUtils.getMessage("version.duplicated.productId", "com.ibm.websphere.productId", e.getProductInfo1().getFile().getAbsoluteFile(), e.getProductInfo2().getFile().getAbsoluteFile()));
        }
        catch (ProductInfoReplaceException e) {
            ProductInfo productInfo = e.getProductInfo();
            String replacesId = productInfo.getReplacesId();
            if (replacesId.equals(productInfo.getId())) {
                throw new VersionParsingException(CommandUtils.getMessage("version.replaced.product.can.not.itself", productInfo.getFile().getAbsoluteFile()));
            }
            throw new VersionParsingException(CommandUtils.getMessage("version.replaced.product.not.exist", replacesId, productInfo.getFile().getAbsoluteFile()));
        }
        if (productIdToVersionPropertiesMap.isEmpty()) {
            throw new VersionParsingException(CommandUtils.getMessage("ERROR_NO_PROPERTIES_FILE", versionPropertyDirectory.getAbsoluteFile()));
        }
        return productIdToVersionPropertiesMap;
    }

    protected static class VersionParsingException
    extends Exception {
        private static final long serialVersionUID = 2079114457028206162L;

        protected VersionParsingException(String message) {
            super(message);
        }
    }
}

