/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.destination;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport;
import com.ibm.ws.sib.processor.impl.destination.LocalisationManager;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractProtoRealization {
    private static final TraceComponent tc = SibTr.register(AbstractProtoRealization.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected BaseDestinationHandler _baseDestinationHandler;
    protected MessageProcessor _messageProcessor;
    protected DestinationManager _destinationManager;
    private LockManager _reallocationLockManager = null;
    protected LocalisationManager _localisationManager = null;
    protected AbstractRemoteSupport _remoteSupport = null;
    HashMap _postMediatedItemStreamsRequiringCleanup = new HashMap(1);

    public abstract void reconstituteEnoughForDeletion() throws MessageStoreException, SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException;

    public void reconstituteGDTargetStreams() throws MessageStoreException, SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteGDTargetStreams");
        }
        this._remoteSupport.reconstituteGDTargetStreams();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteGDTargetStreams");
        }
    }

    public OutputHandler choosePtoPOutputHandler(SIBUuid8 fixedMEUuid, SIBUuid8 preferredME, boolean localMessage, boolean forcePut, boolean singleServer, HashSet<SIBUuid8> scopedMEs) throws SIRollbackException, SIConnectionLostException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)new Object[]{fixedMEUuid, preferredME, localMessage, forcePut, singleServer, scopedMEs});
        }
        OutputHandler result = null;
        boolean checkLocal = false;
        if (this._localisationManager.hasLocal()) {
            if (fixedMEUuid == null) {
                if (scopedMEs == null || scopedMEs.contains(this._messageProcessor.getMessagingEngineUuid())) {
                    checkLocal = true;
                }
            } else if (fixedMEUuid.equals((Object)this._messageProcessor.getMessagingEngineUuid()) && (scopedMEs == null || scopedMEs.contains(this._messageProcessor.getMessagingEngineUuid()))) {
                checkLocal = true;
            }
        }
        if (fixedMEUuid != null || scopedMEs != null && !scopedMEs.contains(preferredME)) {
            preferredME = null;
        }
        if (checkLocal && (singleServer || preferredME != null && preferredME.equals((Object)this._messageProcessor.getMessagingEngineUuid()) || fixedMEUuid != null)) {
            result = this.getLocalPostMedPtoPOH(localMessage, forcePut, singleServer);
        }
        if (!(result != null || singleServer || checkLocal && fixedMEUuid != null)) {
            HashSet<Object> localScopedMEs = scopedMEs;
            if (fixedMEUuid != null) {
                localScopedMEs = new HashSet();
                localScopedMEs.add(fixedMEUuid);
                preferredME = fixedMEUuid;
            }
            result = this._localisationManager.searchForOutputHandler(preferredME, localMessage, this._remoteSupport, localScopedMEs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)result);
        }
        return result;
    }

    public abstract OutputHandler getLocalPostMedPtoPOH(boolean var1, boolean var2, boolean var3) throws SIRollbackException, SIConnectionLostException, SIResourceException;

    public void updateLocalisationSet(SIBUuid8 messagingEngineUuid, Set newQueuePointLocalisingMEUuids) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLocalisationSet", (Object)new Object[]{messagingEngineUuid, newQueuePointLocalisingMEUuids});
        }
        this._localisationManager.updateLocalisationSet(messagingEngineUuid, newQueuePointLocalisingMEUuids);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLocalisationSet");
        }
    }

    public boolean hasRemote() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasRemote");
        }
        boolean hasRemote = this._localisationManager.hasRemote();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasRemote", (Object)new Boolean(hasRemote));
        }
        return hasRemote;
    }

    public abstract boolean cleanupLocalisations() throws SIResourceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanupPremediatedItemStreams() {
        boolean allCleanedUp;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupPremediatedItemStreams");
        }
        if (allCleanedUp = true) {
            HashMap hashMap = this._postMediatedItemStreamsRequiringCleanup;
            synchronized (hashMap) {
                HashMap clonedLocalisations = (HashMap)this._postMediatedItemStreamsRequiringCleanup.clone();
                for (SIBUuid8 uuid : clonedLocalisations.keySet()) {
                    boolean removeFromXmitPoints;
                    PtoPMessageItemStream ptoPMessageItemStream = (PtoPMessageItemStream)this._postMediatedItemStreamsRequiringCleanup.get(uuid);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Removing Localisation " + uuid + " for destination " + this._baseDestinationHandler.getName() + " : " + this._baseDestinationHandler.getUuid()));
                    }
                    boolean itemStreamCleanedUp = ptoPMessageItemStream.reallocateMsgs();
                    boolean bl = removeFromXmitPoints = !ptoPMessageItemStream.getDeleteRequiredAtReconstitute();
                    if (itemStreamCleanedUp) {
                        this._postMediatedItemStreamsRequiringCleanup.remove(uuid);
                        if (removeFromXmitPoints) {
                            this._localisationManager.removeXmitQueuePoint(uuid);
                        }
                    }
                    if (!allCleanedUp) continue;
                    allCleanedUp = itemStreamCleanedUp;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupPremediatedItemStreams", (Object)new Boolean(allCleanedUp));
        }
        return allCleanedUp;
    }

    public void addAllLocalisationsForCleanUp(boolean singleServer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addAllLocalisationsForCleanUp", (Object)new Object[]{new Boolean(singleServer)});
        }
        this._localisationManager.addAllLocalisationsForCleanUp(singleServer, this._postMediatedItemStreamsRequiringCleanup);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addAllLocalisationsForCleanUp");
        }
    }

    public void addLocalisationForCleanUp(SIBUuid8 meUuid, PtoPMessageItemStream ptoPMessageItemStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLocalisationForCleanUp", (Object)new Object[]{meUuid, ptoPMessageItemStream});
        }
        this._postMediatedItemStreamsRequiringCleanup.put(meUuid, ptoPMessageItemStream);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLocalisationForCleanUp");
        }
    }

    public LockManager getReallocationLockManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReallocationLockManager");
            SibTr.exit((TraceComponent)tc, (String)"getReallocationLockManager", (Object)this._reallocationLockManager);
        }
        if (this._reallocationLockManager == null) {
            this._reallocationLockManager = new LockManager();
        }
        return this._reallocationLockManager;
    }

    public void setToBeDeleted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setToBeDeleted");
        }
        if (this._remoteSupport != null) {
            this._remoteSupport.setToBeDeleted();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setToBeDeleted");
        }
    }

    public void registerControlAdapters() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapters");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapters");
        }
    }

    public AbstractRemoteSupport getRemoteSupport() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteSupport");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteSupport", (Object)this._remoteSupport);
        }
        return this._remoteSupport;
    }

    public abstract void onExpiryReport();
}

