/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation.v20;

import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.beanvalidation.AbstractBeanValidation;
import com.ibm.ws.beanvalidation.service.ConstrainedHelper;
import com.ibm.ws.beanvalidation.service.Validation20ClassLoader;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.classloading.ClassLoadingService;
import jakarta.validation.BootstrapConfiguration;
import jakarta.validation.Configuration;
import jakarta.validation.Validation;
import jakarta.validation.executable.ExecutableType;
import jakarta.validation.executable.ValidateOnExecution;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import java.lang.annotation.ElementType;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.validator.internal.properties.DefaultGetterPropertySelectionStrategy;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ExecutableHelper;
import org.hibernate.validator.internal.util.TypeResolutionHelper;
import org.hibernate.validator.internal.util.classhierarchy.ClassHierarchyHelper;
import org.hibernate.validator.internal.util.classhierarchy.Filter;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.spi.properties.ConstrainableExecutable;
import org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class ConstrainedHelperImpl
implements ConstrainedHelper {
    private static final TraceComponent tc = Tr.register(ConstrainedHelperImpl.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private static final EnumSet<ExecutableType> ALL_EXECUTABLE_TYPES = EnumSet.of(ExecutableType.CONSTRUCTORS, ExecutableType.NON_GETTER_METHODS, ExecutableType.GETTER_METHODS);
    private static final EnumSet<ExecutableType> DEFAULT_EXECUTABLE_TYPES = EnumSet.of(ExecutableType.CONSTRUCTORS, ExecutableType.NON_GETTER_METHODS);
    private final ExecutableHelper executableHelper = new ExecutableHelper(new TypeResolutionHelper());
    private final GetterPropertySelectionStrategy getterPropertySelectionStrategy = new DefaultGetterPropertySelectionStrategy();
    private Set<ExecutableType> globalExecutableTypes;
    private boolean isExecutableValidationEnabled;
    @Reference
    private ClassLoadingService classLoadingService;
    static final long serialVersionUID = -7707308673385677817L;

    private EnumSet<ExecutableType> commonExecutableTypeChecks(ValidateOnExecution validateOnExecutionAnnotation) {
        if (validateOnExecutionAnnotation == null) {
            return EnumSet.noneOf(ExecutableType.class);
        }
        EnumSet<ExecutableType> executableTypes = EnumSet.noneOf(ExecutableType.class);
        if (validateOnExecutionAnnotation.type().length == 0) {
            executableTypes.add(ExecutableType.NONE);
        } else {
            Collections.addAll(executableTypes, validateOnExecutionAnnotation.type());
        }
        if (executableTypes.contains(ExecutableType.IMPLICIT) && executableTypes.size() > 1) {
            throw log.getMixingImplicitWithOtherExecutableTypesException();
        }
        if (executableTypes.contains(ExecutableType.NONE) && executableTypes.size() > 1) {
            executableTypes.remove(ExecutableType.NONE);
        }
        if (executableTypes.contains(ExecutableType.ALL)) {
            executableTypes = ALL_EXECUTABLE_TYPES;
        }
        return executableTypes;
    }

    private AbstractBeanValidation.ClassLoaderTuple configureBvalClassloader(ClassLoader cl) {
        if (cl == null) {
            cl = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        }
        if (cl != null) {
            if (this.classLoadingService.isThreadContextClassLoader(cl)) {
                return AbstractBeanValidation.ClassLoaderTuple.of((ClassLoader)cl, (boolean)false);
            }
            if (this.classLoadingService.isAppClassLoader(cl)) {
                return AbstractBeanValidation.ClassLoaderTuple.of((ClassLoader)this.createTCCL(cl), (boolean)true);
            }
        }
        return AbstractBeanValidation.ClassLoaderTuple.of((ClassLoader)this.createTCCL(ConstrainedHelper.class.getClassLoader()), (boolean)true);
    }

    private ClassLoader createTCCL(ClassLoader parentCL) {
        return AccessController.doPrivileged(() -> this.classLoadingService.createThreadContextClassLoader(parentCL));
    }

    private EnumSet<ExecutableType> executableTypesDefinedOnConstructor(Constructor<?> constructor) {
        ValidateOnExecution validateOnExecutionAnnotation = constructor.getAnnotation(ValidateOnExecution.class);
        EnumSet<ExecutableType> executableTypes = this.commonExecutableTypeChecks(validateOnExecutionAnnotation);
        if (executableTypes.contains(ExecutableType.IMPLICIT)) {
            executableTypes.add(ExecutableType.CONSTRUCTORS);
        }
        return executableTypes;
    }

    private EnumSet<ExecutableType> executableTypesDefinedOnMethod(Method method, boolean isGetter) {
        ValidateOnExecution validateOnExecutionAnnotation = method.getAnnotation(ValidateOnExecution.class);
        EnumSet<ExecutableType> executableTypes = this.commonExecutableTypeChecks(validateOnExecutionAnnotation);
        if (executableTypes.contains(ExecutableType.IMPLICIT)) {
            if (isGetter) {
                executableTypes.add(ExecutableType.GETTER_METHODS);
            } else {
                executableTypes.add(ExecutableType.NON_GETTER_METHODS);
            }
        }
        return executableTypes;
    }

    private EnumSet<ExecutableType> executableTypesDefinedOnType(Class<?> clazz) {
        ValidateOnExecution validateOnExecutionAnnotation = clazz.getAnnotation(ValidateOnExecution.class);
        EnumSet<ExecutableType> executableTypes = this.commonExecutableTypeChecks(validateOnExecutionAnnotation);
        if (executableTypes.contains(ExecutableType.IMPLICIT)) {
            return DEFAULT_EXECUTABLE_TYPES;
        }
        return executableTypes;
    }

    public boolean isConstructorConstrained(Constructor<?> constructor, BeanDescriptor beanDescriptor, ClassLoader moduleClassLoader, String moduleUri) {
        EnumSet<ExecutableType> memberLevelExecutableType;
        this.setupGlobalValidationSettings(moduleClassLoader, moduleUri);
        if (!this.isExecutableValidationEnabled) {
            return false;
        }
        EnumSet<ExecutableType> classLevelExecutableTypes = this.executableTypesDefinedOnType(constructor.getDeclaringClass());
        if (this.veto(classLevelExecutableTypes, memberLevelExecutableType = this.executableTypesDefinedOnConstructor(constructor), ExecutableType.CONSTRUCTORS)) {
            return false;
        }
        return beanDescriptor.getConstraintsForConstructor((Class[])constructor.getParameterTypes()) != null;
    }

    private boolean isGetterConstrained(BeanDescriptor beanDescriptor, Method method, String property) {
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty(property);
        return propertyDescriptor != null && propertyDescriptor.findConstraints().declaredOn(new ElementType[]{ElementType.METHOD}).hasConstraints();
    }

    public boolean isMethodConstrained(Method method, BeanDescriptor beanDescriptor, ClassLoader moduleClassLoader, String moduleUri) {
        ExecutableType currentExecutableType;
        this.setupGlobalValidationSettings(moduleClassLoader, moduleUri);
        if (!this.isExecutableValidationEnabled) {
            return false;
        }
        List<Method> overriddenAndImplementedMethods = InheritedMethodsHelper.getAllMethods(method.getDeclaringClass());
        Optional correspondingProperty = this.getterPropertySelectionStrategy.getProperty((ConstrainableExecutable)new ConstrainableMethod(method));
        Method methodForExecutableTypeRetrieval = this.replaceWithOverriddenOrInterfaceMethod(method, overriddenAndImplementedMethods);
        EnumSet<ExecutableType> classLevelExecutableTypes = this.executableTypesDefinedOnType(methodForExecutableTypeRetrieval.getDeclaringClass());
        EnumSet<ExecutableType> memberLevelExecutableType = this.executableTypesDefinedOnMethod(methodForExecutableTypeRetrieval, correspondingProperty.isPresent());
        ExecutableType executableType = currentExecutableType = correspondingProperty.isPresent() ? ExecutableType.GETTER_METHODS : ExecutableType.NON_GETTER_METHODS;
        if (this.veto(classLevelExecutableTypes, memberLevelExecutableType, currentExecutableType)) {
            return false;
        }
        boolean needsValidation = correspondingProperty.isPresent() ? this.isGetterConstrained(beanDescriptor, method, (String)correspondingProperty.get()) : this.isNonGetterConstrained(beanDescriptor, method);
        return needsValidation;
    }

    private boolean isNonGetterConstrained(BeanDescriptor beanDescriptor, Method method) {
        return beanDescriptor.getConstraintsForMethod(method.getName(), (Class[])method.getParameterTypes()) != null;
    }

    private void releaseLoader(ClassLoader tccl) {
        AccessController.doPrivileged(() -> {
            this.classLoadingService.destroyThreadContextClassLoader(tccl);
            return null;
        });
    }

    private Method replaceWithOverriddenOrInterfaceMethod(Method method, List<Method> allMethodsOfType) {
        LinkedList<Method> list = new LinkedList<Method>(allMethodsOfType);
        Iterator<Method> iterator = list.descendingIterator();
        while (iterator.hasNext()) {
            Method overriddenOrInterfaceMethod = iterator.next();
            if (!this.executableHelper.overrides(method, overriddenOrInterfaceMethod)) continue;
            if (method.getAnnotation(ValidateOnExecution.class) != null) {
                throw log.getValidateOnExecutionOnOverriddenOrInterfaceMethodException((Executable)method);
            }
            return overriddenOrInterfaceMethod;
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupGlobalValidationSettings(ClassLoader moduleClassLoader, String moduleUri) {
        AbstractBeanValidation.ClassLoaderTuple tuple;
        block8: {
            SetContextClassLoaderPrivileged setClassLoader = null;
            ClassLoader oldClassLoader = null;
            tuple = null;
            try {
                tuple = this.configureBvalClassloader(moduleClassLoader);
                ClassLoader tcclClassLoaderTmp = tuple.classLoader;
                ClassLoader bvalClassLoader = AccessController.doPrivileged(() -> new Validation20ClassLoader(tcclClassLoaderTmp, moduleUri));
                ThreadContextAccessor tca = AccessController.doPrivileged(() -> ThreadContextAccessor.getThreadContextAccessor());
                setClassLoader = new SetContextClassLoaderPrivileged(tca);
                oldClassLoader = setClassLoader.execute(bvalClassLoader);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Called setClassLoader with oldClassLoader of " + oldClassLoader + " and newClassLoader of " + bvalClassLoader), (Object[])new Object[0]);
                }
                Configuration config = Validation.byDefaultProvider().configure();
                BootstrapConfiguration bootstrap = config.getBootstrapConfiguration();
                this.globalExecutableTypes = bootstrap.getDefaultValidatedExecutableTypes();
                this.isExecutableValidationEnabled = bootstrap.isExecutableValidationEnabled();
                if (setClassLoader == null) break block8;
            }
            catch (Throwable throwable) {
                if (setClassLoader != null) {
                    setClassLoader.execute(oldClassLoader);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                    }
                }
                if (tuple != null && tuple.wasCreatedViaClassLoadingService) {
                    this.releaseLoader(tuple.classLoader);
                }
                throw throwable;
            }
            setClassLoader.execute(oldClassLoader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
            }
        }
        if (tuple != null && tuple.wasCreatedViaClassLoadingService) {
            this.releaseLoader(tuple.classLoader);
        }
    }

    private boolean veto(EnumSet<ExecutableType> classLevelExecutableTypes, EnumSet<ExecutableType> memberLevelExecutableType, ExecutableType currentExecutableType) {
        if (!memberLevelExecutableType.isEmpty()) {
            return !memberLevelExecutableType.contains(currentExecutableType) && !memberLevelExecutableType.contains(ExecutableType.IMPLICIT);
        }
        if (!classLevelExecutableTypes.isEmpty()) {
            return !classLevelExecutableTypes.contains(currentExecutableType) && !classLevelExecutableTypes.contains(ExecutableType.IMPLICIT);
        }
        return !this.globalExecutableTypes.contains(currentExecutableType);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class InheritedMethodsHelper {
        static final long serialVersionUID = 3322847469324098480L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private InheritedMethodsHelper() {
        }

        public static List<Method> getAllMethods(Class<?> clazz) {
            Contracts.assertNotNull(clazz);
            ArrayList methods = CollectionHelper.newArrayList();
            for (Class hierarchyClass : ClassHierarchyHelper.getHierarchy(clazz, (Filter[])new Filter[0])) {
                Collections.addAll(methods, InheritedMethodsHelper.run(() -> hierarchyClass.getMethods()));
            }
            return methods;
        }

        private static <T> T run(PrivilegedAction<T> action) {
            return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.beanvalidation.v20.ConstrainedHelperImpl$InheritedMethodsHelper", InheritedMethodsHelper.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ConstrainableMethod
    implements ConstrainableExecutable {
        private final Method method;
        static final long serialVersionUID = -893741108674720255L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ConstrainableMethod(Method method) {
            this.method = method;
        }

        public String getName() {
            return this.method.getName();
        }

        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.beanvalidation.v20.ConstrainedHelperImpl$ConstrainableMethod", ConstrainableMethod.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
        }
    }
}

