/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.sender.okhttp.internal;

import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.StringJoiner;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.Response;

public final class RetryInterceptor
implements Interceptor {
    private static final Logger logger = Logger.getLogger(RetryInterceptor.class.getName());
    private final RetryPolicy retryPolicy;
    private final Function<Response, Boolean> isRetryable;
    private final Predicate<IOException> retryExceptionPredicate;
    private final Sleeper sleeper;
    private final BoundedLongGenerator randomLong;

    public RetryInterceptor(RetryPolicy retryPolicy, Function<Response, Boolean> isRetryable) {
        this(retryPolicy, isRetryable, retryPolicy.getRetryExceptionPredicate() == null ? RetryInterceptor::isRetryableException : retryPolicy.getRetryExceptionPredicate(), TimeUnit.NANOSECONDS::sleep, bound -> ThreadLocalRandom.current().nextLong(bound));
    }

    RetryInterceptor(RetryPolicy retryPolicy, Function<Response, Boolean> isRetryable, Predicate<IOException> retryExceptionPredicate, Sleeper sleeper, BoundedLongGenerator randomLong) {
        this.retryPolicy = retryPolicy;
        this.isRetryable = isRetryable;
        this.retryExceptionPredicate = retryExceptionPredicate;
        this.sleeper = sleeper;
        this.randomLong = randomLong;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = null;
        IOException exception = null;
        int attempt = 0;
        long nextBackoffNanos = this.retryPolicy.getInitialBackoff().toNanos();
        do {
            if (attempt > 0) {
                long upperBoundNanos = Math.min(nextBackoffNanos, this.retryPolicy.getMaxBackoff().toNanos());
                long backoffNanos = this.randomLong.get(upperBoundNanos);
                nextBackoffNanos = (long)((double)nextBackoffNanos * this.retryPolicy.getBackoffMultiplier());
                try {
                    this.sleeper.sleep(backoffNanos);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                if (response != null) {
                    response.close();
                }
            }
            ++attempt;
            try {
                response = chain.proceed(chain.request());
            }
            catch (IOException e) {
                exception = e;
            }
            if (response != null) {
                boolean retryable = Boolean.TRUE.equals(this.isRetryable.apply(response));
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Attempt " + attempt + " returned " + (retryable ? "retryable" : "non-retryable") + " response: " + RetryInterceptor.responseStringRepresentation(response));
                }
                if (!retryable) {
                    return response;
                }
            }
            if (exception == null) continue;
            boolean retryable = this.retryExceptionPredicate.test(exception);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Attempt " + attempt + " failed with " + (retryable ? "retryable" : "non-retryable") + " exception", exception);
            }
            if (retryable) continue;
            throw exception;
        } while (attempt < this.retryPolicy.getMaxAttempts());
        if (response != null) {
            return response;
        }
        throw exception;
    }

    private static String responseStringRepresentation(Response response) {
        StringJoiner joiner = new StringJoiner(",", "Response{", "}");
        joiner.add("code=" + response.code());
        joiner.add("headers=" + response.headers().toMultimap().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + String.join((CharSequence)",", (Iterable)entry.getValue())).collect(Collectors.joining(",", "[", "]")));
        return joiner.toString();
    }

    boolean shouldRetryOnException(IOException e) {
        return this.retryExceptionPredicate.test(e);
    }

    static boolean isRetryableException(IOException e) {
        if (e instanceof SocketTimeoutException) {
            return true;
        }
        if (e instanceof ConnectException) {
            return true;
        }
        if (e instanceof UnknownHostException) {
            return true;
        }
        return e instanceof SocketException;
    }

    static interface Sleeper {
        public void sleep(long var1) throws InterruptedException;
    }

    static interface BoundedLongGenerator {
        public long get(long var1);
    }
}

