/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.web.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.web.factories.WeldListenerFactory;
import com.ibm.ws.cdi.web.impl.security.PrincipalServletRequestListener;
import com.ibm.ws.cdi.web.interfaces.CDIWebRuntime;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.facade.ServletContextFacade;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.JspApplicationContext;
import jakarta.servlet.jsp.JspFactory;
import java.util.EventListener;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractServletInitializer
implements ServletContainerInitializer {
    private static final TraceComponent tc = Tr.register(AbstractServletInitializer.class, (String)"JCDI", (String)"com.ibm.ws.cdi.impl.resources.CDI");
    private final AtomicServiceReference<CDIWebRuntime> cdiWebRuntimeRef = new AtomicServiceReference("cdiWebRuntime");
    static final long serialVersionUID = 2075701207646636103L;

    public void activate(ComponentContext context) {
        this.cdiWebRuntimeRef.activate(context);
    }

    protected void deactivate(ComponentContext context) {
        this.cdiWebRuntimeRef.deactivate(context);
    }

    @Reference(name="cdiWebRuntime", service=CDIWebRuntime.class)
    protected void setCdiWebRuntime(ServiceReference<CDIWebRuntime> ref) {
        this.cdiWebRuntimeRef.setReference(ref);
    }

    protected void unsetCdiWebRuntime(ServiceReference<CDIWebRuntime> ref) {
        this.cdiWebRuntimeRef.unsetReference(ref);
    }

    protected CDIWebRuntime getCDIWebRuntime() {
        return (CDIWebRuntime)this.cdiWebRuntimeRef.getService();
    }

    protected abstract String getApplicationJ2EEName(IServletContext var1);

    public void onStartup(Set<Class<?>> c, ServletContext ctx) {
        CDIWebRuntime cdiWebRuntime;
        IServletContext isc = (IServletContext)ctx;
        while (isc instanceof ServletContextFacade) {
            isc = ((ServletContextFacade)isc).getIServletContext();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"calling isCDIEnabled()", (Object[])new Object[0]);
        }
        if ((cdiWebRuntime = this.getCDIWebRuntime()) != null && cdiWebRuntime.isCdiEnabled(isc)) {
            String contextID = this.getApplicationJ2EEName(isc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CDI WEB APP: " + contextID), (Object[])new Object[0]);
            }
            isc.setInitParameter("WELD_CONTEXT_ID_KEY", contextID);
            BeanManager beanManager = cdiWebRuntime.getCurrentBeanManager();
            if (beanManager == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Bean Manager not found: " + contextID), (Object[])new Object[0]);
                }
            } else {
                isc.addListener((EventListener)((Object)new PrincipalServletRequestListener()));
                JspFactory factory = JspFactory.getDefaultFactory();
                if (factory != null) {
                    JspApplicationContext applicationCtx = factory.getJspApplicationContext(ctx);
                    applicationCtx.addELContextListener(WeldListenerFactory.newWeldELContextListener());
                    beanManager.wrapExpressionFactory(applicationCtx.getExpressionFactory());
                    applicationCtx.addELResolver(beanManager.getELResolver());
                }
            }
        }
    }
}

