/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBufferPool;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.IOWriteRequestContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.impl.BaseConnectionWriteCallback;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.PriorityQueue;
import com.ibm.ws.sib.jfapchannel.impl.TransmissionData;
import com.ibm.ws.sib.jfapchannel.netty.NettyIOWriteRequestContext;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class NettyConnectionWriteCompletedCallback
extends BaseConnectionWriteCallback {
    private static final TraceComponent tc = SibTr.register(NettyConnectionWriteCompletedCallback.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private final PriorityQueue priorityQueue;
    private final NettyIOWriteRequestContext writeCtx;
    private final Connection connection;
    private boolean idle = true;
    private boolean terminate = false;
    private boolean connectionClosed = false;
    private final Object connectionClosedLock = new String("connectionClosedLock");
    private final BlockingQueue<Pair<SendListener, Conversation>> sendCallbacks = new LinkedBlockingQueue<Pair<SendListener, Conversation>>();
    private TransmissionData partiallySentTransmission = null;
    private final AtomicBoolean firstInvocation = new AtomicBoolean(true);

    public NettyConnectionWriteCompletedCallback(PriorityQueue priorityQueue, IOWriteRequestContext x, Connection connection) throws FrameworkException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{priorityQueue, x, connection});
        }
        this.priorityQueue = priorityQueue;
        if (x != null && !(x instanceof NettyIOWriteRequestContext)) {
            throw new FrameworkException("Invalid connection write context passed");
        }
        this.writeCtx = (NettyIOWriteRequestContext)x;
        this.connection = connection;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void proddle() throws SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"proddle");
        }
        boolean useThisThread = false;
        PriorityQueue priorityQueue = this.priorityQueue;
        synchronized (priorityQueue) {
            NettyConnectionWriteCompletedCallback nettyConnectionWriteCompletedCallback = this;
            synchronized (nettyConnectionWriteCompletedCallback) {
                if (this.idle) {
                    useThisThread = this.isWorkAvailable();
                    this.idle = !useThisThread;
                }
            }
        }
        if (useThisThread) {
            this.doWork(false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"proddle");
        }
    }

    @Override
    public void complete(NetworkConnection vc, IOWriteRequestContext wctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"complete", (Object)new Object[]{vc, wctx});
        }
        if (this.connection.isLoggingIOEvents()) {
            this.connection.getConnectionEventRecorder().logDebug("complete method invoked on write context " + System.identityHashCode(wctx));
        }
        try {
            this.doWork(true);
        }
        catch (SIConnectionDroppedException connectionDroppedException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught SIConnectionDroppedException, Priority Queue has been purged");
            }
        }
        catch (Error error) {
            FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.sib.jfapchannel.impl.NettyConnectionWriteCompletedCallback", (String)"00060004", (Object)this.connection.getDiagnostics(true));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)error);
            }
            this.connection.invalidate(false, error, "Error caught in NettyConnectionWriteCompletedCallback.complete()");
            throw error;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.jfapchannel.impl.NettyConnectionWriteCompletedCallback", (String)"00060006", (Object)this.connection.getDiagnostics(true));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)runtimeException);
            }
            this.connection.invalidate(false, runtimeException, "RuntimeException caught in NettyConnectionWriteCompletedCallback.complete()");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork(boolean hasWritten) throws SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"doWork", (Object)hasWritten);
        }
        LinkedBlockingQueue<Pair<SendListener, Conversation>> readySendCallbacks = new LinkedBlockingQueue<Pair<SendListener, Conversation>>();
        boolean hasGoneAsync = false;
        while (true) {
            block17: {
                Object object;
                if (hasWritten) {
                    this.sendCallbacks.drainTo(readySendCallbacks);
                }
                hasWritten = false;
                boolean hasMoreWork = false;
                PriorityQueue priorityQueue = this.priorityQueue;
                synchronized (priorityQueue) {
                    object = this;
                    synchronized (object) {
                        if (!this.isWorkAvailable()) {
                            break block17;
                        }
                    }
                }
                WsByteBuffer writeBuffer = this.getWriteContextBuffer();
                writeBuffer.clear();
                if (this.dequeueTransmissionData(writeBuffer)) {
                    object = this.connectionClosedLock;
                    synchronized (object) {
                        if (!this.connectionClosed) {
                            NetworkConnection vc;
                            writeBuffer.flip();
                            if (this.connection.isLoggingIOEvents()) {
                                this.connection.getConnectionEventRecorder().logDebug("invoking writeCtx.write() on context " + System.identityHashCode(this.writeCtx) + " to write all data with no timeout");
                            }
                            hasGoneAsync = (vc = this.writeCtx.write(writeBuffer, this)) == null;
                            hasWritten = true;
                            hasMoreWork = !hasGoneAsync;
                        }
                    }
                }
                if (hasMoreWork) continue;
            }
            if (hasGoneAsync || this.switchToIdle()) break;
        }
        this.notifyReadySendListeners(readySendCallbacks);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"doWork");
        }
    }

    private void notifyReadySendListeners(BlockingQueue<Pair<SendListener, Conversation>> readySendCallbacks) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"notifyReadySendListeners", readySendCallbacks);
        }
        try {
            for (Pair pair : readySendCallbacks) {
                ((SendListener)pair.left).dataSent((Conversation)pair.right);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.jfapchannel.impl.NettyConnectionWriteCompletedCallback", (String)"00060002", (Object)this.connection.getDiagnostics(true));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"exception invoking send listener data sent");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Throwable)t);
            }
            this.connection.invalidate(true, t, "send listener threw exception");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"notifyReadySendListeners");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchToIdle() throws SIConnectionDroppedException {
        boolean noMoreWork;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"switchToIdle");
        }
        PriorityQueue priorityQueue = this.priorityQueue;
        synchronized (priorityQueue) {
            NettyConnectionWriteCompletedCallback nettyConnectionWriteCompletedCallback = this;
            synchronized (nettyConnectionWriteCompletedCallback) {
                this.idle = noMoreWork = !this.isWorkAvailable();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"switchToIdle", (Object)noMoreWork);
        }
        return noMoreWork;
    }

    private WsByteBuffer getWriteContextBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getWriteContextBuffer");
        }
        WsByteBuffer writeBuffer = null;
        if (this.firstInvocation.compareAndSet(true, false) || writeBuffer == null) {
            int writeBufferSize = Integer.parseInt(RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.DEFAULT_WRITE_BUFFER_SIZE", (String)"32768"));
            writeBuffer = WsByteBufferPool.getInstance().allocateDirect(writeBufferSize);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getWriteContextBuffer", (Object)writeBuffer);
        }
        return writeBuffer;
    }

    @Override
    public void error(NetworkConnection vc, IOWriteRequestContext wrc, IOException t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"error", (Object)new Object[]{vc, wrc, t});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && t != null) {
            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)t);
        }
        if (this.connection.isLoggingIOEvents()) {
            this.connection.getConnectionEventRecorder().logDebug("error method invoked on write context " + System.identityHashCode(wrc) + " with exception " + t);
        }
        try {
            String message = "IOException received - " + t == null ? "" : t.getMessage();
            this.connection.invalidate(false, t, message);
        }
        catch (Error error) {
            FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.sib.jfapchannel.impl.NettyConnectionWriteCompletedCallback", (String)"00060002", (Object)this.connection.getDiagnostics(true));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)error);
            }
            this.connection.invalidate(false, error, "Error caught in NettyConnectionWriteCompletedCallback.error()");
            throw error;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.jfapchannel.impl.NettyConnectionWriteCompletedCallback", (String)"00060007", (Object)this.connection.getDiagnostics(true));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)runtimeException);
            }
            this.connection.invalidate(false, runtimeException, "RuntimeException caught in NettyConnectionWriteCompletedCallback.error()");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void physicalCloseNotification() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"physicalCloseNotification");
        }
        Object object = this.connectionClosedLock;
        synchronized (object) {
            this.connectionClosed = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"physicalCloseNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dequeueTransmissionData(WsByteBuffer bufferToFill) throws SIConnectionDroppedException {
        TransmissionData data;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dequeueTransmissionData", (Object)bufferToFill);
        }
        boolean exhaustedTransmissionsToSend = false;
        boolean dataCopied = false;
        boolean isTerminal = false;
        NettyConnectionWriteCompletedCallback nettyConnectionWriteCompletedCallback = this;
        synchronized (nettyConnectionWriteCompletedCallback) {
            data = this.partiallySentTransmission;
        }
        try {
            do {
                if (data == null) {
                    PriorityQueue priorityQueue = this.priorityQueue;
                    synchronized (priorityQueue) {
                        data = this.priorityQueue.dequeue();
                    }
                }
                if (data == null) {
                    exhaustedTransmissionsToSend = true;
                    continue;
                }
                boolean finishedThisTransmission = data.buildTransmission(bufferToFill);
                dataCopied = true;
                if (!finishedThisTransmission) continue;
                SendListener sendListener = data.getSendListener();
                if (sendListener != null) {
                    this.sendCallbacks.add(new Pair<SendListener, Conversation>(sendListener, data.getConversation()));
                }
                isTerminal = data.isTerminal();
                data.release();
                data = null;
            } while (!exhaustedTransmissionsToSend && !isTerminal && bufferToFill.remaining() > 0);
        }
        finally {
            NettyConnectionWriteCompletedCallback nettyConnectionWriteCompletedCallback2 = this;
            synchronized (nettyConnectionWriteCompletedCallback2) {
                this.partiallySentTransmission = data;
                this.terminate = isTerminal;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dequeueTransmissionData", (Object)dataCopied);
        }
        return dataCopied;
    }

    private boolean isWorkAvailable() throws SIConnectionDroppedException {
        boolean isWork;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isWorkAvailable");
        }
        if (this.terminate) {
            isWork = false;
        } else {
            boolean bl = isWork = this.partiallySentTransmission != null || !this.priorityQueue.isEmpty();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isWorkAvailable", (Object)isWork);
        }
        return isWork;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/NettyConnectionWriteCompletedCallback.java, SIB.comms, WAS70.SIB, uu1215.01 1.46.1.3");
        }
    }

    private static final class Pair<L, R> {
        public final L left;
        public final R right;

        Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }

        public String toString() {
            return String.format("{ %s, %s }", this.left, this.right);
        }
    }
}

