/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.Conjunction;
import com.ibm.ws.sib.matchspace.EvalCache;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.matchspace.MatchTarget;
import com.ibm.ws.sib.matchspace.MatchingException;
import com.ibm.ws.sib.matchspace.SearchResults;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.impl.ContentMatcher;
import com.ibm.ws.sib.matchspace.impl.InternTable;
import com.ibm.ws.sib.matchspace.impl.Matching;
import com.ibm.ws.sib.matchspace.impl.SetValEvaluationContext;
import com.ibm.ws.sib.matchspace.impl.WrappedNodeResults;
import com.ibm.ws.sib.matchspace.selector.impl.OrdinalPosition;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceComponent;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;
import java.util.ArrayList;
import java.util.List;

public final class DifficultMatcher
extends ContentMatcher {
    private static final Class cclass = DifficultMatcher.class;
    private static Trace tc = TraceUtils.getTrace(DifficultMatcher.class, (String)"SIBMatchSpace");
    private static final int INIT_MTTL_SIZE = 0;
    List roots;
    List objs;
    MatchTargetTypeList alwaysMatch;
    public static int totalDifficultEntries = 0;

    public DifficultMatcher(OrdinalPosition pid) {
        super(pid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "DifficultMatcher", (Object)("pid: " + pid));
        }
        this.roots = new ArrayList(2);
        this.objs = new ArrayList(2);
        this.alwaysMatch = new MatchTargetTypeList();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "DifficultMatcher", (Object)this);
        }
    }

    @Override
    public void put(Conjunction selector, MatchTarget object, InternTable subExpr) throws MatchingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "put", new Object[]{selector, object, subExpr});
        }
        if (selector == null || this.noEligibleTests(selector)) {
            MatchTargetTypeList mttl;
            Selector expr;
            Selector selector2 = expr = selector == null ? null : selector.getResidual();
            if (expr == null) {
                mttl = this.alwaysMatch;
            } else {
                expr = expr.intern((Selector.InternTable)subExpr);
                totalDifficultEntries = subExpr.size();
                int pos = this.roots.indexOf(expr);
                if (pos == -1) {
                    MatchTargetTypeList tlist;
                    mttl = tlist = new MatchTargetTypeList();
                    this.objs.add(tlist);
                    this.roots.add(expr);
                } else {
                    mttl = (MatchTargetTypeList)this.objs.get(pos);
                }
            }
            mttl.addTarget(object);
        } else {
            super.put(selector, object, subExpr);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "put");
        }
    }

    private boolean noEligibleTests(Conjunction selector) {
        for (int i = 0; i < selector.getSimpleTests().length; ++i) {
            OrdinalPosition ordPos = (OrdinalPosition)selector.getSimpleTests()[i].getIdentifier().getOrdinalPosition();
            if (ordPos.compareTo(this.ordinalPosition) <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void get(Object rootVal, MatchSpaceKey msg, EvalCache cache, Object contextValue, SearchResults result) throws MatchingException, BadMessageFormatMatchingException {
        List[] v;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "get", (Object)("msg: " + msg + ", result: " + result));
        }
        if ((v = this.alwaysMatch.lists).length > 0) {
            result.addObjects(v);
        }
        if (msg != null) {
            int numExpr = this.roots.size();
            for (int current = 0; current < numExpr; ++current) {
                Boolean res = null;
                if (contextValue != null) {
                    if (contextValue instanceof SetValEvaluationContext) {
                        SetValEvaluationContext evalContext = (SetValEvaluationContext)contextValue;
                        ArrayList wrappedParentList = evalContext.getWrappedNodeList();
                        if (wrappedParentList.isEmpty()) {
                            Object docRoot = Matching.getEvaluator().getDocumentRoot(msg);
                            WrappedNodeResults wrapper = new WrappedNodeResults(docRoot);
                            evalContext.addNode(wrapper);
                        }
                        for (WrappedNodeResults nextWrappedNode : wrappedParentList) {
                            Object nextNode = nextWrappedNode.getNode();
                            res = (Boolean)Matching.getEvaluator().eval((Selector)this.roots.get(current), msg, cache, nextNode, true);
                            if (res == null || !res.booleanValue()) continue;
                            break;
                        }
                    }
                } else {
                    res = (Boolean)Matching.getEvaluator().eval((Selector)this.roots.get(current), msg, cache, contextValue, false);
                }
                if (res == null || !res.booleanValue()) continue;
                MatchTargetTypeList tlist = (MatchTargetTypeList)this.objs.get(current);
                v = tlist.lists;
                if (v.length <= 0) continue;
                result.addObjects(v);
            }
        }
        super.get(null, msg, cache, contextValue, result);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "get");
        }
    }

    @Override
    public ContentMatcher remove(Conjunction selector, MatchTarget object, InternTable subExpr, OrdinalPosition parentId) throws MatchingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "remove", (Object)("selector: " + selector + ", object: " + object));
        }
        if (this.objs == null) {
            throw new IllegalStateException();
        }
        if (selector == null || this.noEligibleTests(selector)) {
            int len = this.objs.size();
            boolean removed = false;
            for (int i = 0; !removed && i < len; ++i) {
                MatchTargetTypeList tlist = (MatchTargetTypeList)this.objs.get(i);
                removed = tlist.deleteTarget(object);
                if (!removed) continue;
                Selector node = (Selector)this.roots.get(i);
                if (node == null) {
                    throw new IllegalStateException();
                }
                node.unintern((Selector.InternTable)subExpr);
                if (tlist.size() != 0) continue;
                this.objs.remove(i);
                this.roots.remove(i);
            }
            if (!removed && !(removed = this.alwaysMatch.deleteTarget(object))) {
                throw new IllegalStateException();
            }
        } else {
            super.remove(selector, object, subExpr, this.ordinalPosition);
        }
        ContentMatcher result = this;
        if (this.roots.size() == 0 && this.alwaysMatch.size() == 0) {
            result = this.vacantChild;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "remove", (Object)("result: " + result));
        }
        return result;
    }

    @Override
    boolean hasTests() {
        return this.roots.size() > 0 || this.vacantChild != null;
    }

    private class MatchTargetTypeList {
        List[] lists = new List[0];

        MatchTargetTypeList() {
        }

        public void addTarget(MatchTarget t) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.entry((Object)this, cclass, "addTarget", (Object)("target: " + t));
            }
            int type = t.type();
            this.resize(type);
            if (this.lists[type] == null) {
                this.lists[type] = new ArrayList(2);
            }
            t.setIndex(this.lists[type].size());
            this.lists[type].add(t);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "addTarget");
            }
        }

        public boolean deleteTarget(MatchTarget t) {
            int index;
            List set;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.entry((Object)this, cclass, "addTarget", (Object)("target: " + t));
            }
            int type = t.type();
            boolean result = false;
            if (type < this.lists.length && (set = this.lists[type]) != null && (index = t.getIndex()) < set.size() && t == set.get(index)) {
                if (set.size() == 1) {
                    set.clear();
                } else {
                    MatchTarget toMove = (MatchTarget)set.get(set.size() - 1);
                    toMove.setIndex(index);
                    set.set(index, toMove);
                    set.remove(set.size() - 1);
                }
                if (set.isEmpty()) {
                    this.lists[type] = null;
                    if (type == this.lists.length - 1) {
                        int newlen;
                        for (newlen = this.lists.length; newlen > 0 && this.lists[newlen - 1] == null; --newlen) {
                        }
                        if (newlen > 0) {
                            List[] list2 = new List[newlen];
                            System.arraycopy(this.lists, 0, list2, 0, newlen);
                            this.lists = list2;
                        } else {
                            this.lists = new List[0];
                        }
                    }
                }
                result = true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "deleteTarget", (Object)("result: " + new Boolean(result)));
            }
            return result;
        }

        public List getTypeList(int type) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.entry((Object)this, cclass, "getTypeList", (Object)("type: " + new Integer(type)));
            }
            List result = null;
            if (type < this.lists.length) {
                result = this.lists[type];
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "getTypeList", (Object)("result: " + result));
            }
            return result;
        }

        private void resize(int maxType) {
            int size;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.entry((Object)this, cclass, "resize", (Object)("maxType: " + new Integer(maxType)));
            }
            if ((size = this.lists.length) <= maxType) {
                List[] list2 = new List[maxType + 1];
                System.arraycopy(this.lists, 0, list2, 0, size);
                this.lists = list2;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "resize");
            }
        }

        public int size() {
            return this.lists.length;
        }
    }
}

