/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.proxyhandler.BusGroup;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener;
import com.ibm.ws.sib.processor.proxyhandler.Neighbours;
import com.ibm.ws.sib.processor.proxyhandler.SubscriptionMessageHandler;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;

public final class MultiMEProxyHandler
extends SIMPItemStream {
    private static final int NUM_MESSAGES = 2;
    private static final TraceComponent tc = SibTr.register(MultiMEProxyHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Neighbours _neighbours = null;
    private MessageProcessor _messageProcessor;
    private ObjectPool _subscriptionMessagePool;
    private NeighbourProxyListener _proxyListener;
    private LockManager _lockManager;
    private ConsumerSession _proxyAsyncConsumer;
    private SIMPTransactionManager _transactionManager;
    private boolean _reconciling = false;
    private boolean _started = false;

    public MultiMEProxyHandler() {
    }

    public MultiMEProxyHandler(MessageProcessor messageProcessor, SIMPTransactionManager txManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MultiMEProxyHandler", (Object)new Object[]{messageProcessor, txManager});
        }
        this.initialiseNonPersistent(messageProcessor, txManager);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MultiMEProxyHandler", (Object)((Object)this));
        }
    }

    public void initialiseNonPersistent(MessageProcessor messageProcessor, SIMPTransactionManager txManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialiseNonPersistent", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        this._subscriptionMessagePool = new ObjectPool("SubscriptionMessages", 2);
        this._neighbours = new Neighbours(this, this._messageProcessor.getMessagingEngineBus());
        this._lockManager = new LockManager();
        this._transactionManager = txManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialiseNonPersistent");
        }
    }

    public void initalised() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initalised");
        }
        try {
            this._lockManager.lockExclusive();
            this._started = true;
            if (this._proxyListener == null) {
                this.createProxyListener();
            }
            this._reconciling = false;
            this._neighbours.resetBusSubscriptionList();
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initalised");
        }
    }

    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        try {
            this._lockManager.lockExclusive();
            this._started = false;
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void removeUnusedNeighbours() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeUnusedNeighbours");
        }
        Enumeration neighbourList = this._neighbours.getAllRecoveredNeighbours();
        LocalTransaction transaction = null;
        try {
            this._lockManager.lockExclusive();
            transaction = this._transactionManager.createLocalTransaction(true);
            while (neighbourList.hasMoreElements()) {
                Neighbour neighbour = (Neighbour)((Object)neighbourList.nextElement());
                if (this._messageProcessor.getDestinationManager().getLinkDefinition(neighbour.getBusId()) != null) continue;
                this._neighbours.removeRecoveredNeighbour(neighbour.getUUID(), (Transaction)transaction);
            }
            transaction.commit();
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler.removeUnusedNeighbours", (String)"1:310:1.96", (Object)((Object)this));
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
            }
            catch (SIException e1) {
                FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler.removeUnusedNeighbours", (String)"1:324:1.96", (Object)((Object)this));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e1));
            }
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeUnusedNeighbours", (Object)"SIErrorException");
            }
            throw new SIErrorException((Throwable)e);
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeUnusedNeighbours");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeEvent(ConsumerDispatcherState subState, Transaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"subscribeEvent", (Object)new Object[]{subState, transaction});
        }
        try {
            this._lockManager.lock();
            if (!this._started) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"subscribeEvent", (Object)"Returning as stopped");
                }
                return;
            }
            BusGroup[] buses = this._neighbours.getAllBuses();
            SubscriptionMessageHandler messageHandler = null;
            if (!this._reconciling) {
                for (int i = 0; i < buses.length; ++i) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Forwarding topic " + subState.getTopic() + " to Bus " + buses[i]));
                    }
                    if ((messageHandler = buses[i].addLocalSubscription(subState, messageHandler, transaction, true)) == null) continue;
                    this.addMessageHandler(messageHandler);
                    messageHandler = null;
                }
            }
        }
        finally {
            this._lockManager.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"subscribeEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subscribeEvent(List topicSpaces, List topics, String busId, Transaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"subscribeEvent", (Object)new Object[]{topics, topicSpaces, busId, transaction});
        }
        try {
            this._lockManager.lock();
            if (!this._started) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"subscribeEvent", (Object)"Returning as stopped");
                }
                return;
            }
            if (!this._reconciling) {
                this.remoteSubscribeEvent(topicSpaces, topics, busId, transaction, true);
            }
        }
        finally {
            this._lockManager.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"subscribeEvent");
        }
    }

    protected void remoteSubscribeEvent(List topicSpaces, List topics, String busId, Transaction transaction, boolean sendProxy) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remoteSubscribeEvent", (Object)new Object[]{topicSpaces, topics, busId, transaction});
        }
        BusGroup[] buses = this._neighbours.getAllBuses();
        for (int i = 0; i < buses.length; ++i) {
            if (buses[i].getName().equals(busId)) continue;
            SubscriptionMessageHandler messageHandler = null;
            ListIterator topicIterator = topics.listIterator();
            ListIterator tsIterator = topicSpaces.listIterator();
            while (topicIterator.hasNext()) {
                SIBUuid12 topicSpace = (SIBUuid12)tsIterator.next();
                String topic = (String)topicIterator.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Forwarding topic " + topicSpace + topic + " to bus " + buses[i]));
                }
                messageHandler = buses[i].addRemoteSubscription(topicSpace, topic, messageHandler, sendProxy);
            }
            if (messageHandler == null) continue;
            buses[i].sendToNeighbours(messageHandler.getSubscriptionMessage(), transaction, false);
            this.addMessageHandler(messageHandler);
            messageHandler = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remoteSubscribeEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeEvent(ConsumerDispatcherState subState, Transaction transaction, boolean sendProxy) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unsubscribeEvent", (Object)new Object[]{subState, transaction, new Boolean(sendProxy)});
        }
        try {
            this._lockManager.lock();
            if (!this._started) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"unsubscribeEvent", (Object)"Returning as stopped");
                }
                return;
            }
            BusGroup[] buses = this._neighbours.getAllBuses();
            SubscriptionMessageHandler messageHandler = null;
            if (!this._reconciling) {
                for (int i = 0; i < buses.length; ++i) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Forwarding topic " + subState.getTopicSpaceUuid() + ":" + subState.getTopic() + " to Bus " + buses[i]));
                    }
                    messageHandler = buses[i].removeLocalSubscription(subState, messageHandler, transaction, sendProxy);
                }
            }
            if (messageHandler != null) {
                this.addMessageHandler(messageHandler);
            }
        }
        finally {
            this._lockManager.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unsubscribeEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeEvent(List topicSpaces, List topics, String busId, Transaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unsubscribeEvent", (Object)new Object[]{topicSpaces, topics, busId});
        }
        try {
            this._lockManager.lock();
            if (!this._started) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"unsubscribeEvent", (Object)"Returning as stopped");
                }
                return;
            }
            if (!this._reconciling) {
                this.remoteUnsubscribeEvent(topicSpaces, topics, busId, transaction, true);
            }
        }
        finally {
            this._lockManager.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unsubscribeEvent");
        }
    }

    protected void remoteUnsubscribeEvent(List topicSpaces, List topics, String busId, Transaction transaction, boolean sendProxy) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remoteUnsubscribeEvent", (Object)new Object[]{topicSpaces, topics, busId, transaction});
        }
        BusGroup[] buses = this._neighbours.getAllBuses();
        for (int i = 0; i < buses.length; ++i) {
            if (buses[i].getName().equals(busId)) continue;
            SubscriptionMessageHandler messageHandler = null;
            ListIterator topicIterator = topics.listIterator();
            ListIterator tsIterator = topicSpaces.listIterator();
            while (topicIterator.hasNext()) {
                SIBUuid12 topicSpace = (SIBUuid12)tsIterator.next();
                String topic = (String)topicIterator.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Forwarding topic " + topicSpace + ":" + topic + " to Bus " + buses[i]));
                }
                if ((messageHandler = buses[i].removeRemoteSubscription(topicSpace, topic, messageHandler, sendProxy)) == null) continue;
                buses[i].sendToNeighbours(messageHandler.getSubscriptionMessage(), transaction, false);
                this.addMessageHandler(messageHandler);
                messageHandler = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remoteUnsubscribeEvent");
        }
    }

    public void topicSpaceCreatedEvent(DestinationHandler destination) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"topicSpaceCreatedEvent", (Object)destination);
        }
        try {
            this._lockManager.lockExclusive();
            this._neighbours.topicSpaceCreated(destination);
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"topicSpaceCreatedEvent");
        }
    }

    public void topicSpaceDeletedEvent(DestinationHandler destination) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"topicSpaceDeletedEvent", (Object)destination);
        }
        try {
            this._lockManager.lockExclusive();
            this._neighbours.topicSpaceDeleted(destination);
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"topicSpaceDeletedEvent");
        }
    }

    public void linkStarted(String busId, SIBUuid8 meUuid) throws SIIncorrectCallException, SIErrorException, SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException {
        Neighbour neighbour;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"linkStarted", (Object)new Object[]{busId, meUuid});
        }
        if ((neighbour = this.getNeighbour(meUuid)) == null) {
            LocalTransaction tran = this._transactionManager.createLocalTransaction(true);
            neighbour = this.createNeighbour(meUuid, busId, (Transaction)tran);
            tran.commit();
        }
        this._neighbours.resetBusSubscriptionList();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"linkStarted");
        }
    }

    public void cleanupLinkNeighbour(String busName) throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        Neighbour neighbour;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupLinkNeighbour");
        }
        if ((neighbour = this._neighbours.getBusNeighbour(busName)) != null) {
            LocalTransaction tran = this._messageProcessor.getTXManager().createLocalTransaction(true);
            this.deleteNeighbourForced(neighbour.getUUID(), busName, (Transaction)tran);
            tran.commit();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupLinkNeighbour");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Neighbour createNeighbour(SIBUuid8 meUUID, String busId, Transaction transaction) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createNeighbour", (Object)new Object[]{meUUID, busId, transaction});
        }
        Neighbour neighbour = null;
        try {
            this._lockManager.lockExclusive();
            neighbour = this._neighbours.addNeighbour(meUUID, busId, transaction);
            if (!this._reconciling && this._proxyListener == null) {
                this.createProxyListener();
            }
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createNeighbour", (Object)((Object)neighbour));
        }
        return neighbour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNeighbourForced(SIBUuid8 meUUID, String busId, Transaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteNeighbourForced", (Object)new Object[]{meUUID, busId, transaction});
        }
        try {
            this._lockManager.lockExclusive();
            this._neighbours.removeNeighbour(meUUID, busId, transaction);
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteNeighbourForced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllNeighboursForced(Transaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteAllNeighboursForced", (Object)new Object[]{transaction});
        }
        try {
            Neighbour neighbour;
            this._lockManager.lockExclusive();
            Enumeration neighbs = this._neighbours.getAllNeighbours();
            while (neighbs.hasMoreElements()) {
                neighbour = (Neighbour)((Object)neighbs.nextElement());
                this._neighbours.removeNeighbour(neighbour.getUUID(), neighbour.getBusId(), transaction);
            }
            neighbs = this._neighbours.getAllRecoveredNeighbours();
            while (neighbs.hasMoreElements()) {
                neighbour = (Neighbour)((Object)neighbs.nextElement());
                this._neighbours.removeNeighbour(neighbour.getUUID(), neighbour.getBusId(), transaction);
            }
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteAllNeighboursForced");
        }
    }

    public void recoverNeighbours() throws SIResourceException, MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"recoverNeighbours");
        }
        try {
            this._lockManager.lockExclusive();
            this._reconciling = true;
            this._neighbours.recoverNeighbours();
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"recoverNeighbours");
        }
    }

    Enumeration reportAllNeighbours() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportAllNeighbours");
        }
        Enumeration neighbours = this._neighbours.getAllNeighbours();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportAllNeighbours");
        }
        return neighbours;
    }

    protected BusGroup[] getAllBusGroups() {
        return this._neighbours.getAllBuses();
    }

    final ObjectPool getMessageObjectPool() {
        return this._subscriptionMessagePool;
    }

    void addMessageHandler(SubscriptionMessageHandler messageHandler) {
        boolean inserted;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMessageHandler", (Object)messageHandler);
        }
        if (!(inserted = this._subscriptionMessagePool.add((Object)messageHandler)) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"SubscriptionObjectPool size exceeded");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMessageHandler");
        }
    }

    SubscriptionMessageHandler getMessageHandler() {
        SubscriptionMessageHandler messageHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageHandler");
        }
        if ((messageHandler = (SubscriptionMessageHandler)this._subscriptionMessagePool.remove()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"doProxySubscribeOp", (Object)"Creating a new Message Handler as none available");
            }
            messageHandler = new SubscriptionMessageHandler(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageHandler", (Object)messageHandler);
        }
        return messageHandler;
    }

    private void createProxyListener() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createProxyListener");
        }
        this._proxyListener = new NeighbourProxyListener(this._neighbours, this);
        try {
            this._proxyAsyncConsumer = this._messageProcessor.getSystemConnection().createSystemConsumerSession((SIDestinationAddress)this._messageProcessor.getProxyHandlerDestAddr(), null, null, Reliability.ASSURED_PERSISTENT, false, false, null, false);
            this._proxyAsyncConsumer.registerAsynchConsumerCallback((AsynchConsumerCallback)this._proxyListener, 0, 0L, 1, null);
            this._proxyAsyncConsumer.start(false);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler.createProxyListener", (String)"1:1271:1.96", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createProxyListener", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createProxyListener");
        }
    }

    public NeighbourProxyListener getProxyListener() {
        return this._proxyListener;
    }

    final MessageProcessor getMessageProcessor() {
        return this._messageProcessor;
    }

    public final Neighbour getNeighbour(SIBUuid8 neighbourUUID) {
        return this._neighbours.getNeighbour(neighbourUUID);
    }

    public final Neighbour getNeighbour(SIBUuid8 neighbourUUID, boolean includeRecovered) {
        Neighbour neighbour;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNeighbour", (Object)new Object[]{neighbourUUID, includeRecovered});
        }
        if ((neighbour = this._neighbours.getNeighbour(neighbourUUID)) == null && includeRecovered) {
            neighbour = this._neighbours.getRecoveredNeighbour(neighbourUUID);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNeighbour", (Object)((Object)neighbour));
        }
        return neighbour;
    }

    final Neighbours getNeighbours() {
        return this._neighbours;
    }

    final SIMPTransactionManager getTransactionManager() {
        return this._transactionManager;
    }

    public String toString() {
        return "Instance " + super.toString();
    }

    protected LockManager getLockManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLockManager");
            SibTr.exit((TraceComponent)tc, (String)"getLockManager", (Object)this._lockManager);
        }
        return this._lockManager;
    }
}

