/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.repository.internal;

import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.asset.ESAAsset;
import com.ibm.ws.install.repository.RepositoryException;
import com.ibm.ws.install.repository.internal.BaseRepository;
import com.ibm.ws.install.repository.internal.RepositoryUtils;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.zip.ZipException;

public class DirectoryRepository
extends BaseRepository {
    private File rootPath = null;

    public DirectoryRepository(File rootPath) throws RepositoryException {
        this.classname = "DirectoryRepository";
        if (!rootPath.exists()) {
            throw this.createException(RepositoryUtils.getMessage("ERROR_DIRECTORY_NOT_EXISTS", rootPath.getAbsolutePath()));
        }
        if (rootPath.isFile()) {
            throw this.createException(RepositoryUtils.getMessage("ERROR_PATH_IS_FILE", rootPath.getAbsolutePath()));
        }
        this.rootPath = rootPath;
    }

    @Override
    protected Collection<?> getEsaAsset(String productId, String productVersion, String productInstallType, String productLicenseType, String productEdition, Visibility visibility) {
        File[] esas;
        String method = "getEsaAsset()";
        ArrayList<ESAAsset> esaAssets = new ArrayList<ESAAsset>();
        Properties props = new Properties();
        props.put("com.ibm.websphere.productId", productId);
        props.put("com.ibm.websphere.productVersion", productVersion);
        props.put("com.ibm.websphere.productInstallType", productInstallType);
        props.put("com.ibm.websphere.productEdition", productEdition);
        if (productLicenseType != null) {
            props.put("com.ibm.websphere.productLicenseType", productLicenseType);
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".esa");
            }
        };
        for (File esa : esas = this.rootPath.listFiles(filter)) {
            try {
                ESAAsset esaAsset = new ESAAsset(esa, "", false);
                if (esaAsset.getSubsystemEntry() == null) {
                    this.log(method, InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.content.no.subsystem.manifest", new Object[0]));
                    continue;
                }
                ProvisioningFeatureDefinition fd = esaAsset.getProvisioningFeatureDefinition();
                if (fd.getVisibility() == visibility) {
                    if (fd.isSupportedFeatureVersion()) {
                        String appliesTo = fd.getHeader("IBM-AppliesTo");
                        if (!RepositoryUtils.matchAppliesTo("Feature", esaAsset.getFeatureName(), esa.getName(), appliesTo, productId, productVersion, productInstallType, productLicenseType, productEdition)) continue;
                        esaAssets.add(esaAsset);
                        continue;
                    }
                    this.log(method, InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("UNSUPPORTED_FEATURE_VERSION", fd.getFeatureName(), fd.getIbmFeatureVersion()));
                    continue;
                }
                this.log(method, "The feature " + fd.getFeatureName() + " is not " + visibility);
            }
            catch (ZipException e) {
                this.log(method, InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.bad.zip", esa.getAbsolutePath()), e);
            }
            catch (IOException e) {
                this.log(method, InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.bad.zip", esa.getAbsolutePath()), e);
            }
        }
        return esaAssets;
    }
}

